/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.Calendar;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class TimeUtil {
    public static DateTimeFormatter ISO_ZONED_DATE_TIME3 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").parseLenient().appendOffset("+HH:MM", "Z").toFormatter();
    public static final DateTimeFormatter ISO8601_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).parseLenient().optionalStart().appendOffset("+H", "Z").optionalEnd().optionalStart().appendOffset("+HH", "Z").optionalEnd().optionalStart().appendOffset("+HHmm", "Z").optionalEnd().optionalStart().appendOffset("+HH:mm", "Z").optionalEnd().optionalStart().appendOffset("+HHMM", "Z").optionalEnd().optionalStart().appendOffset("+HH:MM", "Z").optionalEnd().optionalStart().appendOffset("+HHMMss", "Z").optionalEnd().optionalStart().appendOffset("+HH:MM:ss", "Z").optionalEnd().optionalStart().appendOffset("+HHMMSS", "Z").optionalEnd().optionalStart().appendOffset("+HH:MM:SS", "Z").optionalEnd().optionalStart().appendOffset("+HHmmss", "Z").optionalEnd().optionalStart().appendOffset("+HH:mm:ss", "Z").optionalEnd().parseStrict().toFormatter();
    public static final DateTimeFormatter ISO8601_ZONED_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO8601_OFFSET_DATE_TIME).optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    public static DateTimeFormatter UTC_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static ZoneId ZONE_ID_ONTARIO = ZoneId.of("America/Toronto");
    protected static Random RANDOM = new Random();
    protected static final BigDecimal MINUTES60 = BigDecimal.valueOf(60L);
    protected static final BigDecimal DAYS7 = BigDecimal.valueOf(7L);

    public static long getSecondsSinceMidnight(Calendar c) {
        return 3600 * c.get(11) + 60 * c.get(12) + c.get(13);
    }

    public static long getSecondsTillMidnight(Calendar c) {
        return 86400L - TimeUtil.getSecondsSinceMidnight(c);
    }

    public static int[] seconds2DHMS(long totalSeconds) {
        int[] ymdhms = new int[]{0, 0, 0, 0};
        long day = totalSeconds / 86400L;
        long hour = totalSeconds / 3600L % 24L;
        long minute = totalSeconds % 3600L / 60L;
        long second = totalSeconds % 60L;
        ymdhms[3] = (int)day;
        ymdhms[2] = (int)hour;
        ymdhms[1] = (int)minute;
        ymdhms[0] = (int)second;
        return ymdhms;
    }

    public static String seconds2DHMSString(long totalSeconds) {
        int[] ymdhms = TimeUtil.seconds2DHMS(totalSeconds);
        int day = ymdhms[3];
        int hour = ymdhms[2];
        int min = ymdhms[1];
        int sec = ymdhms[0];
        return day + " day" + (day > 1 ? "s " : " ") + hour + " hour" + (hour > 1 ? "s " : " ") + min + " min" + (min > 1 ? "s " : " ") + sec + " sec" + (sec > 1 ? "s " : " ");
    }

    public static String utcDateTimeToLocalDateTime(String utcTime, ZoneId zoneId) {
        if (StringUtils.isBlank((CharSequence)utcTime)) {
            return null;
        }
        return ZonedDateTime.parse(utcTime, UTC_DATE_TIME_FORMATTER).withZoneSameInstant(zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static LocalDateTime toLocalDateTime(long epochTs) {
        return TimeUtil.toLocalDateTime(epochTs, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long epochTs, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return Instant.ofEpochMilli(epochTs).atZone(zoneId).toLocalDateTime();
    }

    public static OffsetDateTime toOffsetDateTime(long epochTs, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return Instant.ofEpochMilli(epochTs).atZone(zoneId).toOffsetDateTime();
    }

    public static ZonedDateTime toZonedDateTime(ZoneId zoneId, long epochSec, int days, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSec), zoneId).plusDays(days).withHour(hourOfDay).withMinute(minuteOfHour).withSecond(secondOfMinute);
    }

    public static OffsetDateTime toOffsetDateTime(LocalDate localDate, ZoneId zoneId) {
        ZonedDateTime zdt = TimeUtil.toZonedDateTime(localDate, zoneId);
        return zdt.withZoneSameInstant(zoneId).toOffsetDateTime();
    }

    public static ZonedDateTime toZonedDateTime(LocalDate localDate, ZoneId zoneId) {
        LocalDateTime localDateTime = localDate.atStartOfDay();
        return ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
    }

    public static int random(int low, int high) {
        int result = RANDOM.nextInt(high - low) + low;
        return result;
    }

    public static double truncatedExponentialBackoffSlots(int retry, int truncatedMaxRetry) {
        if (retry < 1) {
            return 0.0;
        }
        int n = Math.min(retry, truncatedMaxRetry);
        int max = (1 << n) - 1;
        double min = max / 2;
        return Math.random() * ((double)max - min) + min;
    }

    public static String cronExpression4JobSkippedWhenDSTStarts(int hour, int minute) {
        return TimeUtil.getAnnualCompensationForDSTGapCronExpression(ZoneId.systemDefault(), hour, minute);
    }

    public static ZoneOffsetTransitionInfo getZoneOffsetTransitionInfo(ZoneId zoneId) {
        ZoneOffsetTransition[] dstInfo = TimeUtil.getDSTChangeInfo(zoneId, ZonedDateTime.now());
        ZoneOffsetTransition dstStartTransition = dstInfo[0];
        if (dstStartTransition == null) {
            return null;
        }
        boolean isFuture = dstStartTransition.getInstant().isAfter(Instant.now());
        if (!isFuture) {
            ZoneOffsetTransition dstEndTransition = dstInfo[1];
            if (dstEndTransition == null) {
                return null;
            }
            ZonedDateTime zdt = ZonedDateTime.ofInstant(dstEndTransition.getInstant().plusSeconds(86400L), zoneId);
            dstInfo = TimeUtil.getDSTChangeInfo(zoneId, zdt);
            dstStartTransition = dstInfo[0];
            if (dstStartTransition == null) {
                return null;
            }
        }
        return new ZoneOffsetTransitionInfo(zoneId, dstStartTransition);
    }

    public static String getAnnualCompensationForDSTGapCronExpression(ZoneId zoneId, int hour, int minute) {
        if (hour < 0 || hour > 24 || minute < 0 || minute > 60) {
            return null;
        }
        if (zoneId.getId().equals("Israel")) {
            return null;
        }
        ZoneOffsetTransitionInfo dstStartTransitionInfo = TimeUtil.getZoneOffsetTransitionInfo(zoneId);
        return dstStartTransitionInfo.buildCronExpression4JobSkippedWhenDSTStarts(hour, minute);
    }

    public static ZoneOffsetTransition[] getDSTChangeInfo(ZoneId zoneId, ZonedDateTime zdt) {
        ZoneRules zoneRules = zoneId.getRules();
        Instant instant = zdt.toInstant();
        ZoneOffsetTransition prevTransition = zoneRules.previousTransition(instant);
        ZoneOffsetTransition nextTransition = zoneRules.nextTransition(instant);
        ZoneOffsetTransition dstStartTransition = null;
        ZoneOffsetTransition dstEndTransition = null;
        if (prevTransition != null) {
            if (zoneRules.isDaylightSavings(prevTransition.getInstant())) {
                dstStartTransition = prevTransition;
            } else {
                dstEndTransition = prevTransition;
            }
        }
        if (nextTransition != null) {
            if (zoneRules.isDaylightSavings(nextTransition.getInstant())) {
                dstStartTransition = nextTransition;
            } else {
                dstEndTransition = nextTransition;
            }
        }
        ZoneOffsetTransition[] ret = new ZoneOffsetTransition[]{dstStartTransition, dstEndTransition};
        return ret;
    }

    public static void print(ZoneOffsetTransition transition) {
        if (transition == null) {
            return;
        }
        int dstStartHour = transition.getDateTimeBefore().getHour();
        long durationMinutes = transition.getDuration().toMinutes();
        boolean isFuture = transition.getInstant().isAfter(Instant.now());
        System.out.println("\ttransition.isFuture=" + isFuture);
        System.out.println("\ttransition.getInstant=" + transition.getInstant());
        System.out.println("\ttransition.getDateTimeBefore=" + transition.getDateTimeBefore());
        System.out.println("\ttransition.getDateTimeAfter=" + transition.getDateTimeAfter());
        System.out.println("\ttransition.dstStartHour=" + dstStartHour + "am");
        System.out.println("\ttransition.getDuration=" + durationMinutes + "minutes");
        System.out.println("\ttransition.getOffsetBefore=" + transition.getOffsetBefore());
        System.out.println("\ttransition.getOffsetAfter=" + transition.getOffsetAfter());
        System.out.println("\ttransition.isGap=" + transition.isGap());
        System.out.println("\ttransition.isOverlap=" + transition.isOverlap());
    }

    public static int toDurationHours(long durationMinutes) {
        return BigDecimal.valueOf(durationMinutes).divide(MINUTES60, RoundingMode.CEILING).intValue();
    }

    public static String buildCronDSTDayOfWeekOption(ZoneId zoneId, int dayOfWeek, int dayOfMonth) {
        int quartzDayOfWeek = (dayOfWeek + 1) % 7;
        int quartzDayOfMonthIndex = BigDecimal.valueOf(dayOfMonth).divide(DAYS7, RoundingMode.CEILING).intValue();
        String dayOfWeekOption = quartzDayOfMonthIndex <= 2 ? quartzDayOfWeek + "#" + quartzDayOfMonthIndex : quartzDayOfWeek + "L";
        return dayOfWeekOption;
    }

    public static class ZoneOffsetTransitionInfo {
        protected final ZoneId zoneId;
        protected final ZoneOffsetTransition dstStartTransition;
        protected final int dstStartHour;
        protected final long durationMinutes;
        protected final long dstStartMinuteOfDay;
        protected final long dstEndMinuteOfDay;

        public ZoneOffsetTransitionInfo(ZoneId zoneId, ZoneOffsetTransition dstStartTransition) {
            this.zoneId = zoneId;
            this.dstStartTransition = dstStartTransition;
            this.dstStartHour = dstStartTransition.getDateTimeBefore().getHour();
            this.durationMinutes = dstStartTransition.getDuration().toMinutes();
            this.dstStartMinuteOfDay = this.dstStartHour * 60;
            this.dstEndMinuteOfDay = this.dstStartMinuteOfDay + this.durationMinutes;
        }

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public ZoneOffsetTransition getDstStartTransition() {
            return this.dstStartTransition;
        }

        public int getDstStartHour() {
            return this.dstStartHour;
        }

        public long getDurationMinutes() {
            return this.durationMinutes;
        }

        public long getDstStartMinuteOfDay() {
            return this.dstStartMinuteOfDay;
        }

        public long getDstEndMinuteOfDay() {
            return this.dstEndMinuteOfDay;
        }

        public boolean willDailyJobBeSkippedWhenDSTStarts(int hour, int minute) {
            long jobMinuteOfDay = hour * 60 + minute;
            return jobMinuteOfDay >= this.dstStartMinuteOfDay && jobMinuteOfDay < this.dstEndMinuteOfDay;
        }

        public String buildCronExpression4JobSkippedWhenDSTStarts(int hour, int minute) {
            if (!this.willDailyJobBeSkippedWhenDSTStarts(hour, minute)) {
                return null;
            }
            long durationHours = TimeUtil.toDurationHours(this.durationMinutes);
            LocalDateTime dstDate = this.dstStartTransition.getDateTimeAfter();
            int month = dstDate.getMonthValue();
            int dayOfWeek = dstDate.getDayOfWeek().getValue();
            int dayOfMonth = dstDate.getDayOfMonth();
            String dayOfWeekOption = TimeUtil.buildCronDSTDayOfWeekOption(this.zoneId, dayOfWeek, dayOfMonth);
            String cronExpression4JobSkippedWhenDSTStarts = "0 " + minute + " " + ((long)hour + durationHours) + " ? " + month + " " + dayOfWeekOption;
            return cronExpression4JobSkippedWhenDSTStarts;
        }
    }

    public static class TimeDto {
        @JsonIgnoreProperties
        protected ZoneId zoneId;
        @JsonIgnoreProperties
        protected long epochTs;
        @JsonIgnoreProperties
        protected Timestamp timestamp;
        @JsonIgnoreProperties
        protected LocalDateTime localDateTime;
        @JsonIgnoreProperties
        protected OffsetDateTime offsetDateTime;
        @JsonIgnoreProperties
        protected ZonedDateTime zonedDateTime;

        public TimeDto() {
        }

        public TimeDto(long epochTs, String zoneIdName) {
            this(epochTs, ZoneId.of(zoneIdName));
        }

        public TimeDto(long epochTs, ZoneId zoneId) {
            this.zoneId = zoneId;
            this.epochTs = epochTs;
            this.timestamp = new Timestamp(epochTs);
            this.localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochTs), zoneId);
            this.offsetDateTime = Instant.ofEpochMilli(epochTs).atZone(zoneId).toOffsetDateTime();
            this.zonedDateTime = Instant.ofEpochMilli(epochTs).atZone(zoneId);
        }

        public void sync() {
            this.timestamp = new Timestamp(this.epochTs);
            this.localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.epochTs), this.zoneId);
            this.offsetDateTime = Instant.ofEpochMilli(this.epochTs).atZone(this.zoneId).toOffsetDateTime();
            this.zonedDateTime = Instant.ofEpochMilli(this.epochTs).atZone(this.zoneId);
        }

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public long getEpochTs() {
            return this.epochTs;
        }

        public void setEpochTs(long epochTs) {
            this.epochTs = epochTs;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public LocalDateTime getLocalDateTime() {
            return this.localDateTime;
        }

        public void setLocalDateTime(LocalDateTime localDateTime) {
            this.localDateTime = localDateTime;
        }

        public OffsetDateTime getOffsetDateTime() {
            return this.offsetDateTime;
        }

        public void setOffsetDateTime(OffsetDateTime offsetDateTime) {
            this.offsetDateTime = offsetDateTime;
        }

        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        public void setZonedDateTime(ZonedDateTime zonedDateTime) {
            this.zonedDateTime = zonedDateTime;
        }
    }
}

