/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigurationMonitor;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;
import org.summerboot.jexpress.boot.event.AppLifecycleListener;
import org.summerboot.jexpress.boot.instrumentation.Timeout;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.security.SSLUtil;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.util.FormatterUtil;

public class ConfigUtil {
    protected static AppLifecycleListener cfgListener;
    protected StringBuilder sb = null;
    protected final String cfgFile;
    public static final String ENCRYPTED_WARPER_PREFIX = "ENC";
    public static final String DECRYPTED_WARPER_PREFIX = "DEC";

    public static Path cfgRoot(String domainFolderPrefix, String domainName, String configDirName) {
        String root = StringUtils.isBlank((CharSequence)domainName) ? domainFolderPrefix : domainFolderPrefix + "_" + domainName;
        Path p = Paths.get(root, configDirName);
        return p.toAbsolutePath();
    }

    public static void setConfigChangeListener(AppLifecycleListener listener) {
        cfgListener = listener;
    }

    public static int loadConfigs(ConfigLoadMode mode, Logger log, Locale defaultRB, Path configFolder, Map<String, JExpressConfig> configs, int CfgMonitorInterval, File cfgConfigDir) throws Exception {
        int updated = 0;
        HashMap<File, Runnable> cfgUpdateTasks = new HashMap<File, Runnable>();
        long timeoutMs = BackOffice.agent.getProcessTimeoutMilliseconds();
        String timeoutDesc = BackOffice.agent.getProcessTimeoutAlertMessage();
        for (String fileName : configs.keySet()) {
            File configFile = Paths.get(configFolder.toString(), fileName).toFile();
            Timeout a = Timeout.watch("loading config file " + configFile, timeoutMs).withDesc(timeoutDesc);
            try {
                updated += ConfigUtil.loadConfig(mode, log, defaultRB, configFile, configs.get(fileName), cfgUpdateTasks, cfgConfigDir);
            }
            finally {
                if (a == null) continue;
                a.close();
            }
        }
        if (!mode.isCliMode() && CfgMonitorInterval > 0) {
            ConfigurationMonitor.cfgMonitor.start(configFolder.toFile(), CfgMonitorInterval, cfgUpdateTasks);
        }
        return updated;
    }

    public static void createConfigFile(Class<? extends JExpressConfig> c, File cfgConfigDir, String cfgName, boolean cliMode) throws IOException {
        Object fileName;
        String configContent = BootConfig.generateTemplate(c);
        ImportResource ir = c.getAnnotation(ImportResource.class);
        Object object = fileName = ir == null ? cfgName : ir.value();
        if (cliMode) {
            fileName = (String)fileName + ".sample";
        }
        File cfgFile = new File(cfgConfigDir, (String)fileName).getAbsoluteFile();
        if (cliMode) {
            System.out.print("saveing " + c.getName() + " to " + cfgFile);
        }
        Files.writeString(cfgFile.toPath(), (CharSequence)configContent, new OpenOption[0]);
        if (cliMode) {
            System.out.println(" done!");
        }
    }

    public static int loadConfig(ConfigLoadMode mode, Logger log, Locale defaultRB, File configFile, JExpressConfig cfg, Map<File, Runnable> cfgUpdateTasks, File cfgConfigDir) throws Exception {
        if (cfg == null) {
            log.warn("null instance for " + configFile);
            return 0;
        }
        if (!configFile.exists()) {
            if (cfgConfigDir == null || !cfgConfigDir.isDirectory() || !cfgConfigDir.canWrite()) {
                return 0;
            }
            ConfigUtil.createConfigFile(cfg.getClass(), cfgConfigDir, configFile.getName(), false);
        }
        int updated = ConfigUtil.updatePasswords(configFile, null, mode.isEncryptMode());
        if (mode.isCliMode()) {
            System.out.println(updated + " config items have been " + (mode.isEncryptMode() ? "encrypted" : "decrypted") + " in " + configFile.getAbsolutePath());
            return updated;
        }
        cfg.load(configFile, true);
        log.debug(() -> cfg.info());
        cfgUpdateTasks.put(configFile, () -> {
            Throwable cause = null;
            if (cfgListener != null) {
                cfgListener.onConfigChangeBefore(configFile, cfg);
            }
            log.warn(I18n.info.cfgChangedBefore.format(defaultRB, cfg.info()));
            try {
                ConfigUtil.updatePasswords(configFile, null, true);
                JExpressConfig temp = cfg.temp();
                if (temp != null) {
                    temp.load(configFile, false);
                }
                cfg.load(configFile, true);
            }
            catch (Throwable ex) {
                try {
                    cause = ex;
                    log.error((Object)configFile, ex);
                }
                catch (Throwable throwable) {
                    log.warn(I18n.info.cfgChangedAfter.format(defaultRB, cfg.info()));
                    if (cfgListener != null) {
                        cfgListener.onConfigChangedAfter(configFile, cfg, cause);
                    }
                    throw throwable;
                }
                log.warn(I18n.info.cfgChangedAfter.format(defaultRB, cfg.info()));
                if (cfgListener != null) {
                    cfgListener.onConfigChangedAfter(configFile, cfg, cause);
                }
            }
            log.warn(I18n.info.cfgChangedAfter.format(defaultRB, cfg.info()));
            if (cfgListener != null) {
                cfgListener.onConfigChangedAfter(configFile, cfg, cause);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            cfg.shutdown();
            System.out.println(Thread.currentThread().getName() + ": shutdown - done!");
        }, "ShutdownHook." + cfg.name()));
        return updated;
    }

    public ConfigUtil(String cfgFile) {
        this.cfgFile = cfgFile;
    }

    public void addError(String e) {
        if (this.sb == null) {
            this.sb = new StringBuilder();
            this.sb.append("config file = ").append(this.cfgFile);
        }
        this.sb.append(BootConstant.BR).append("\t").append(e);
    }

    public String getError() {
        return this.sb == null ? null : this.sb.toString();
    }

    public boolean getAsBoolean(Properties props, String key, Boolean defaultValue) {
        String v = props.getProperty(key);
        if (StringUtils.isBlank((CharSequence)v)) {
            if (defaultValue == null) {
                this.addError("missing \"" + key + "\"");
                return false;
            }
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(v.trim());
        }
        catch (RuntimeException ex) {
            this.addError("invalid \"" + key + "\"");
            return false;
        }
    }

    public int getAsInt(Properties props, String key, Integer defaultValue) {
        String v = props.getProperty(key);
        if (StringUtils.isBlank((CharSequence)v)) {
            if (defaultValue == null) {
                this.addError("missing \"" + key + "\"");
                return Integer.MIN_VALUE;
            }
            return defaultValue;
        }
        try {
            return Integer.parseInt(v.trim());
        }
        catch (RuntimeException ex) {
            this.addError("invalid \"" + key + "\"");
            return Integer.MIN_VALUE;
        }
    }

    public long getAsLong(Properties props, String key, Long defaultValue) {
        String v = props.getProperty(key);
        if (StringUtils.isBlank((CharSequence)v)) {
            if (defaultValue == null) {
                this.addError("missing \"" + key + "\"");
                return Long.MIN_VALUE;
            }
            return defaultValue;
        }
        try {
            return Long.parseLong(v.trim());
        }
        catch (RuntimeException ex) {
            this.addError("invalid \"" + key + "\"");
            return Long.MIN_VALUE;
        }
    }

    public float getAsFloat(Properties props, String key, Float defaultValue) {
        String v = props.getProperty(key);
        if (StringUtils.isBlank((CharSequence)v)) {
            if (defaultValue == null) {
                this.addError("missing \"" + key + "\"");
                return Float.MIN_VALUE;
            }
            return defaultValue.floatValue();
        }
        try {
            return Float.parseFloat(v.trim());
        }
        catch (RuntimeException ex) {
            this.addError("invalid \"" + key + "\"");
            return Float.MIN_VALUE;
        }
    }

    public double getAsDouble(Properties props, String key, Double defaultValue) {
        String v = props.getProperty(key);
        if (StringUtils.isBlank((CharSequence)v)) {
            if (defaultValue == null) {
                this.addError("missing \"" + key + "\"");
                return Double.MIN_VALUE;
            }
            return defaultValue;
        }
        try {
            return Double.parseDouble(v.trim());
        }
        catch (RuntimeException ex) {
            this.addError("invalid \"" + key + "\"");
            return Double.MIN_VALUE;
        }
    }

    public String getAsString(Properties props, String key, String defaultValue) {
        String v = props.getProperty(key);
        if (StringUtils.isBlank((CharSequence)v)) {
            if (defaultValue == null) {
                this.addError("missing \"" + key + "\"");
                return null;
            }
            return defaultValue;
        }
        return v.trim();
    }

    public String[] getAsCSV(Properties props, String key, String defaultValue) {
        String v = props.getProperty(key);
        if (StringUtils.isBlank((CharSequence)v)) {
            if (defaultValue == null) {
                this.addError("missing \"" + key + "\"");
                return FormatterUtil.EMPTY_STR_ARRAY;
            }
            try {
                return FormatterUtil.parseCsv(defaultValue);
            }
            catch (RuntimeException ex) {
                this.addError("invalid default CSV  of \"" + key + "\"");
            }
        }
        try {
            return FormatterUtil.parseCsv(v);
        }
        catch (RuntimeException ex) {
            this.addError("invalid CSV of \"" + key + "\"");
            return FormatterUtil.EMPTY_STR_ARRAY;
        }
    }

    public Long[] getAsRangeLong(Properties props, String key, Set<Long> filterCodeSet) {
        String[] a = this.getAsCSV(props, key, null);
        if (a.length < 1) {
            return null;
        }
        Long[] ret = null;
        if (a.length == 1) {
            Long filterCodeRangeTo;
            String r = a[0];
            String[] ra = r.split("\\s*-\\s*");
            Long filterCodeRangeFrom = Long.valueOf(ra[0]);
            Long l = filterCodeRangeTo = ra.length == 1 ? filterCodeRangeFrom : Long.valueOf(ra[1]);
            if (filterCodeRangeFrom > filterCodeRangeTo) {
                this.addError("\"" + key + "\" " + filterCodeRangeFrom + " should be less than \"" + filterCodeRangeTo + "\"");
            } else {
                Long[] range;
                ret = range = new Long[]{filterCodeRangeFrom, filterCodeRangeTo};
            }
        } else {
            filterCodeSet.addAll(Arrays.asList(a).stream().map(Long::valueOf).collect(Collectors.toList()));
        }
        return ret;
    }

    public Double[] getAsRangeDouble(Properties props, String key, Set<Double> filterCodeSet) {
        String[] a = this.getAsCSV(props, key, null);
        if (a.length < 1) {
            return null;
        }
        Double[] ret = null;
        if (a.length == 1) {
            String r = a[0];
            String[] ra = r.split("\\s*-\\s*");
            Double filterCodeRangeFrom = Double.parseDouble(ra[0]);
            Double filterCodeRangeTo = ra.length == 1 ? filterCodeRangeFrom : Double.parseDouble(ra[1]);
            if (filterCodeRangeFrom > filterCodeRangeTo) {
                this.addError("\"" + key + "\" " + filterCodeRangeFrom + " should be less than \"" + filterCodeRangeTo + "\"");
            } else {
                Double[] range;
                ret = range = new Double[]{filterCodeRangeFrom, filterCodeRangeTo};
            }
        } else {
            filterCodeSet.addAll(Arrays.asList(a).stream().map(Double::valueOf).collect(Collectors.toList()));
        }
        return ret;
    }

    public String getAsPassword(Properties props, String key) {
        String v = props.getProperty(key);
        if (StringUtils.isBlank((CharSequence)v)) {
            return null;
        }
        String pwd = null;
        try {
            String value = v.trim();
            if (value.startsWith("ENC(") && value.endsWith(")")) {
                pwd = SecurityUtil.decrypt(value, true);
            } else {
                this.addError("invalid format, expected:  \"" + key + "\"=ENC(encrypted value)");
            }
        }
        catch (Throwable ex) {
            pwd = null;
            this.addError("invalid \"" + key + "\"");
        }
        return pwd;
    }

    public static int updatePasswords(File configFile, File destFile, boolean encrypt) throws IOException, GeneralSecurityException {
        if (!configFile.exists()) {
            return 0;
        }
        int updated = 0;
        StringBuilder sb = new StringBuilder();
        LineIterator iterator = FileUtils.lineIterator((File)configFile, (String)"UTf-8");
        while (iterator.hasNext()) {
            String updatedLine;
            String line = iterator.nextLine().trim();
            if (!line.startsWith("#") && (updatedLine = FormatterUtil.updateProtectedLine(line, encrypt)) != null) {
                line = updatedLine;
                ++updated;
            }
            sb.append(line).append(BootConstant.BR);
        }
        if (updated > 0) {
            if (destFile == null) {
                destFile = configFile;
            }
            try (FileOutputStream output = new FileOutputStream(destFile);
                 FileChannel foc = output.getChannel();){
                foc.write(ByteBuffer.wrap(sb.toString().getBytes(StandardCharsets.UTF_8)));
            }
        }
        return updated;
    }

    public Map<String, Integer> getAsBindingAddress(Properties props, String key) {
        try {
            String v = props.getProperty(key).trim();
            if (StringUtils.isBlank((CharSequence)v)) {
                this.addError("invalid \"" + key + "\"");
                return null;
            }
            return FormatterUtil.parseBindingAddresss(v);
        }
        catch (Throwable ex) {
            this.addError("invalid \"" + key + "\"");
            return null;
        }
    }

    public KeyManagerFactory getAsKeyManagerFactory(Properties props, String configFolder, String keyFile, String storePwd, String keyAlias, String keyPwd) {
        String keyFileValue = props.getProperty(keyFile);
        if (StringUtils.isBlank((CharSequence)keyFileValue)) {
            return null;
        }
        String sslKeyStorePath = this.getFile(configFolder, keyFileValue).getAbsolutePath();
        String alias = props.getProperty(keyAlias);
        KeyManagerFactory kmf = null;
        try {
            String pwd = this.getAsPassword(props, storePwd);
            char[] pwdStore = pwd == null ? null : pwd.toCharArray();
            pwd = this.getAsPassword(props, keyPwd);
            char[] pwdKey = StringUtils.isBlank((CharSequence)alias) || pwd == null ? null : pwd.toCharArray();
            kmf = SSLUtil.buildKeyManagerFactory(sslKeyStorePath, pwdStore, alias, pwdKey);
        }
        catch (Throwable ex) {
            this.addError("Failed to load \"" + sslKeyStorePath + "\") - " + ex.toString());
        }
        return kmf;
    }

    public TrustManagerFactory getAsTrustManagerFactory(Properties props, String configFolder, String keyFile, String storePwd) {
        String trustStorePath = props.getProperty(keyFile);
        if (StringUtils.isBlank((CharSequence)trustStorePath)) {
            return null;
        }
        String sslKeyStorePath = this.getFile(configFolder, trustStorePath).getAbsolutePath();
        TrustManagerFactory tmf = null;
        try {
            String pwd = this.getAsPassword(props, storePwd);
            char[] pwdStore = pwd == null ? null : pwd.toCharArray();
            tmf = SSLUtil.buildTrustManagerFactory(sslKeyStorePath, pwdStore);
        }
        catch (Throwable ex) {
            this.addError("Failed to load \"" + sslKeyStorePath + "\") - " + ex.toString());
        }
        return tmf;
    }

    public File getFile(String configFolder, String filepath) {
        File file = new File(filepath);
        if (!file.isAbsolute()) {
            file = new File(configFolder + File.separator + filepath);
        }
        return file.getAbsoluteFile();
    }

    public static enum ConfigLoadMode {
        cli_encrypt(true, true),
        cli_decrypt(false, true),
        app_run(true, false);

        private final boolean encryptMode;
        private final boolean cliMode;

        private ConfigLoadMode(boolean encryptMode, boolean cliMode) {
            this.encryptMode = encryptMode;
            this.cliMode = cliMode;
        }

        public boolean isEncryptMode() {
            return this.encryptMode;
        }

        public boolean isCliMode() {
            return this.cliMode;
        }
    }
}

