/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.instrumentation;

import com.google.inject.Injector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.annotation.Inspector;
import org.summerboot.jexpress.boot.annotation.Service;
import org.summerboot.jexpress.boot.event.AppLifecycleListener;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.Timeout;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.util.BeanUtil;

public class HealthMonitor {
    protected static final Logger log = LogManager.getLogger((String)HealthMonitor.class.getName());
    protected static volatile AppLifecycleListener appLifecycleListener;
    protected static final ExecutorService tpe;
    protected static final LinkedBlockingQueue<HealthInspector> healthInspectorQueue;
    protected static final Set<HealthInspector> registeredHealthInspectors;
    private static boolean keepRunning;
    private static volatile boolean started;
    protected static volatile boolean isHealthCheckSuccess;
    protected static volatile boolean isServicePaused;
    protected static volatile String statusReasonHealthCheck;
    protected static volatile String statusReasonPaused;
    protected static volatile String statusReasonLastKnown;
    protected static final Set<String> pauseReleaseCodes;
    private static final String ANNOTATION;
    private static final Runnable AsyncTask;

    public static void setAppLifecycleListener(AppLifecycleListener listener) {
        appLifecycleListener = listener;
    }

    public static void registerDefaultHealthInspectors(Map<String, Object> defaultHealthInspectors, StringBuilder memo) {
        registeredHealthInspectors.clear();
        if (defaultHealthInspectors == null || defaultHealthInspectors.isEmpty()) {
            memo.append(BootConstant.BR).append("\t- @" + ANNOTATION + " registered: none");
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean error2 = false;
        for (Map.Entry<String, Object> entry : defaultHealthInspectors.entrySet()) {
            String name = entry.getKey();
            Object healthInspector = entry.getValue();
            if (healthInspector instanceof HealthInspector) {
                registeredHealthInspectors.add((HealthInspector)healthInspector);
                memo.append(BootConstant.BR).append("\t- @Inspector registered: ").append(name).append("=").append(healthInspector.getClass().getName());
                continue;
            }
            error2 = true;
            sb.append(BootConstant.BR).append("\tCoding Error: class ").append(healthInspector.getClass().getName()).append(" has annotation @").append(Inspector.class.getSimpleName()).append(", should implement ").append(HealthInspector.class.getName());
        }
        if (error2) {
            log.fatal(BootConstant.BR + sb + BootConstant.BR);
            System.exit(2);
        }
    }

    public static int inspect() {
        registeredHealthInspectors.forEach(healthInspectorQueue::offer);
        return registeredHealthInspectors.size();
    }

    public static void inspect(HealthInspector ... healthInspectors) {
        if (healthInspectors == null || healthInspectors.length == 0) {
            HealthMonitor.inspect();
            return;
        }
        for (HealthInspector healthInspector : healthInspectors) {
            if (healthInspector == null) continue;
            healthInspectorQueue.add(healthInspector);
        }
    }

    public static String start(boolean returnRsult, Injector guiceInjector) {
        if (keepRunning) {
            return "HealthMonitor is already running";
        }
        StringBuilder memo = new StringBuilder();
        boolean hasUnregistered = false;
        Iterator<HealthInspector> iterator = registeredHealthInspectors.iterator();
        while (iterator.hasNext()) {
            HealthInspector healthInspector = iterator.next();
            Service serviceAnnotation = healthInspector.getClass().getAnnotation(Service.class);
            if (serviceAnnotation == null) continue;
            Class<?> c = healthInspector.getClass();
            boolean usedByTag = false;
            Class[] bindingClasses = serviceAnnotation.binding();
            if (bindingClasses == null || bindingClasses.length < 1) {
                bindingClasses = c.getInterfaces();
            }
            for (Class bindingClasse : bindingClasses) {
                Object o = guiceInjector.getInstance(bindingClasse);
                if (!o.getClass().equals(c)) continue;
                usedByTag = true;
                break;
            }
            if (usedByTag) continue;
            hasUnregistered = true;
            memo.append(BootConstant.BR).append("\t- @Inspector unused due to CLI argument -" + BootConstant.CLI_USE_IMPL + " <implTag>: ").append(c.getName());
            iterator.remove();
        }
        if (hasUnregistered) {
            log.warn((CharSequence)memo);
        }
        String ret = null;
        if (returnRsult) {
            int size = HealthMonitor.inspect();
            keepRunning = false;
            if (size > 0) {
                AsyncTask.run();
                ret = HealthMonitor.buildMessage();
            } else {
                ret = "No health inspectors registered";
            }
        }
        keepRunning = true;
        if (!HealthMonitor.isServiceAvailable()) {
            HealthMonitor.inspect();
        }
        tpe.execute(AsyncTask);
        return ret;
    }

    public static void shutdown() {
        keepRunning = false;
        tpe.shutdown();
    }

    protected static void setHealthStatus(boolean newStatus, String reason) {
        boolean serviceStatusChanged = isHealthCheckSuccess ^ newStatus;
        isHealthCheckSuccess = newStatus;
        statusReasonHealthCheck = reason;
        HealthMonitor.updateServiceStatus(serviceStatusChanged, reason);
    }

    public static void pauseService(boolean pauseService, String lockCode, String reason) {
        boolean serviceStatusChanged = isServicePaused ^ pauseService;
        if (lockCode == null) {
            lockCode = "";
        }
        if (pauseService) {
            pauseReleaseCodes.add(lockCode);
        } else {
            pauseReleaseCodes.remove(lockCode);
            int size = pauseReleaseCodes.size();
            if (size > 0) {
                pauseService = true;
                reason = (String)reason + ", still paused by other " + size + " reason(s) with different lock code(s)";
            }
        }
        isServicePaused = pauseService;
        statusReasonPaused = reason;
        HealthMonitor.updateServiceStatus(serviceStatusChanged, (String)reason);
    }

    protected static void updateServiceStatus(boolean serviceStatusChanged, String reason) {
        statusReasonLastKnown = reason;
        if (!serviceStatusChanged || !started) {
            return;
        }
        log.warn(HealthMonitor.buildMessage());
        if (appLifecycleListener != null) {
            appLifecycleListener.onApplicationStatusUpdated(isHealthCheckSuccess, isServicePaused, serviceStatusChanged, reason);
        }
    }

    public static String buildMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(BootConstant.BR).append("Self Inspection Result: ").append(isHealthCheckSuccess ? "passed" : "failed").append(BootConstant.BR);
        if (!isHealthCheckSuccess) {
            sb.append("\t cause: ").append(statusReasonHealthCheck).append(BootConstant.BR);
        }
        sb.append("Service Status: ").append(isServicePaused ? "paused" : "running").append(BootConstant.BR).append("\t cause: ").append(statusReasonPaused).append(BootConstant.BR);
        return sb.toString();
    }

    public static boolean isServicePaused() {
        return isServicePaused;
    }

    public static String getStatusReasonPaused() {
        return statusReasonPaused;
    }

    public static boolean isHealthCheckSuccess() {
        return isHealthCheckSuccess;
    }

    public static String getStatusReasonHealthCheck() {
        return statusReasonHealthCheck;
    }

    public static boolean isServiceAvailable() {
        return isHealthCheckSuccess && !isServicePaused;
    }

    public static String getServiceStatusReason() {
        return statusReasonLastKnown;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$static$0() {
        inspectionIntervalSeconds = NioConfig.cfg.getHealthInspectionIntervalSeconds();
        timeoutMs = BackOffice.agent.getProcessTimeoutMilliseconds();
        timeoutDesc = BackOffice.agent.getProcessTimeoutAlertMessage();
        batchInspectors = new TreeSet<HealthInspector>();
        do {
            healthCheckFailedReport = new ServiceError(BootConstant.APP_ID + "-HealthMonitor");
            batchInspectors.clear();
            healthCheckAllPassed = null;
            try {
                do {
                    healthInspector = HealthMonitor.healthInspectorQueue.take();
                    batchInspectors.add(healthInspector);
                } while (!HealthMonitor.healthInspectorQueue.isEmpty());
lbl15:
                // 10 sources

                block19: for (HealthInspector healthInspector : batchInspectors) {
                    name = healthInspector.getClass().getName();
                    try {
                        a = Timeout.watch(name + ".ping()", timeoutMs).withDesc(timeoutDesc);
                        try {
                            inspectionType = healthInspector.inspectionType();
                            errs = healthInspector.ping(new Object[0]);
                            v0 = currentInspectionPassed = errs == null || errs.isEmpty() != false;
                            if (!currentInspectionPassed) {
                                HealthMonitor.healthInspectorQueue.offer(healthInspector);
                            }
                            switch (1.$SwitchMap$org$summerboot$jexpress$boot$instrumentation$HealthInspector$InspectionType[inspectionType.ordinal()]) {
                                case 1: {
                                    lockCode = healthInspector.pauseLockCode();
                                    if (currentInspectionPassed) {
                                        reason = name + " success";
                                        HealthMonitor.pauseService(false, lockCode, (String)reason);
                                        ** break;
                                    }
                                    try {
                                        reason = BeanUtil.toJson(errs, true, true);
                                    }
                                    catch (Throwable ex) {
                                        reason = name + " failed " + ex;
                                    }
                                    HealthMonitor.pauseService(true, lockCode, (String)reason);
                                    ** break;
                                }
                                case 2: {
                                    if (currentInspectionPassed) {
                                        if (healthCheckAllPassed == null) {
                                            healthCheckAllPassed = true;
                                            ** break;
                                        }
                                        healthCheckAllPassed = healthCheckAllPassed & true;
                                        ** break;
                                    }
                                    healthCheckAllPassed = false;
                                    healthCheckFailedReport.addErrors(errs);
                                    continue block19;
                                }
                                ** default:
lbl52:
                                // 1 sources

                                continue block19;
                            }
                        }
                        finally {
                            if (a == null) continue;
                            a.close();
                        }
                    }
                    catch (Throwable ex) {
                        HealthMonitor.healthInspectorQueue.offer(healthInspector);
                        HealthMonitor.log.error("HealthInspector error: " + name, ex);
                    }
                }
                if (healthCheckAllPassed != null) {
                    if (healthCheckAllPassed.booleanValue()) {
                        inspectionReport = "Current all health inspectors passed";
                        HealthMonitor.setHealthStatus(healthCheckAllPassed, (String)inspectionReport);
                    } else {
                        try {
                            inspectionReport = BeanUtil.toJson(healthCheckFailedReport, true, true);
                        }
                        catch (Throwable ex) {
                            inspectionReport = " toJson failed " + ex;
                        }
                        HealthMonitor.setHealthStatus(healthCheckAllPassed, (String)inspectionReport);
                        retryIndex = HealthInspector.retryIndex.get();
                        if (HealthMonitor.appLifecycleListener != null && HealthMonitor.started) {
                            HealthMonitor.appLifecycleListener.onHealthInspectionFailed(HealthMonitor.isHealthCheckSuccess, HealthMonitor.isServicePaused, retryIndex, inspectionIntervalSeconds);
                        }
                    }
                }
                HealthMonitor.started = true;
                TimeUnit.SECONDS.sleep(inspectionIntervalSeconds);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                HealthMonitor.log.error("HealthMonitor interrupted", (Throwable)ex);
            }
        } while (HealthMonitor.keepRunning);
    }

    static {
        tpe = Executors.newSingleThreadExecutor();
        healthInspectorQueue = new LinkedBlockingQueue();
        registeredHealthInspectors = new HashSet<HealthInspector>();
        keepRunning = false;
        started = false;
        isHealthCheckSuccess = true;
        isServicePaused = false;
        pauseReleaseCodes = new HashSet<String>();
        ANNOTATION = HealthInspector.class.getSimpleName();
        AsyncTask = HealthMonitor::lambda$static$0;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HealthMonitor.shutdown(), "HealthMonitor.shutdownHook"));
    }
}

