/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.instrumentation;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;

public class Timeout
implements AutoCloseable {
    protected static Logger log = LogManager.getLogger(Timeout.class);
    protected final String processName;
    protected final long timeoutMilliseconds;
    protected String message;
    protected Runnable task;
    protected final ReentrantLock lock = new ReentrantLock();

    public static Timeout watch(String processName, long timeoutMilliseconds) {
        return new Timeout(processName, timeoutMilliseconds, null, null);
    }

    protected Timeout(String processName, long timeoutMilliseconds, String message, Runnable task) {
        this.processName = processName;
        this.timeoutMilliseconds = timeoutMilliseconds;
        this.message = message;
        this.task = task;
        this.startTheTimer();
    }

    public Timeout withDesc(String desc) {
        this.message = desc;
        return this;
    }

    public Timeout withTask(Runnable task) {
        this.task = task;
        return this;
    }

    protected void startTheTimer() {
        this.lock.lock();
        Runnable runnableTask = () -> {
            try {
                log.trace("Task started: {} - {}", (Object)this.processName, (Object)System.currentTimeMillis());
                if (this.lock.tryLock(this.timeoutMilliseconds, TimeUnit.MILLISECONDS)) {
                    this.lock.unlock();
                    log.trace("Task finished: {} - {}", (Object)this.processName, (Object)System.currentTimeMillis());
                    return;
                }
                String desc = this.message == null ? "" : BootConstant.BR + "\t" + this.message;
                log.warn(BootConstant.BR + BootConstant.BR + "\t*** Warning: " + this.processName + " has timed out over " + this.timeoutMilliseconds + " ms ***" + BootConstant.BR + desc + BootConstant.BR + BootConstant.BR);
                if (this.task != null) {
                    BackOffice.execute(this.task);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        BackOffice.execute(runnableTask);
    }

    @Override
    public void close() throws Exception {
        this.lock.unlock();
    }
}

