/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.instrumentation.jmx;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Singleton;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import org.summerboot.jexpress.boot.config.NamedDefaultThreadFactory;
import org.summerboot.jexpress.boot.instrumentation.HTTPClientStatusListener;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.boot.instrumentation.jmx.BootIOStatusData;
import org.summerboot.jexpress.boot.instrumentation.jmx.ServerStatusMBean;
import org.summerboot.jexpress.util.BeanUtil;

@Singleton
public class ServerStatus
extends NotificationBroadcasterSupport
implements NIOStatusListener,
HTTPClientStatusListener,
ServerStatusMBean {
    protected static final DateTimeFormatter DTF = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    protected static final ExecutorService QPS_SERVICE = Executors.newSingleThreadExecutor(new NamedDefaultThreadFactory("ServerStatus"));
    protected final LinkedList<BootIOStatusData> events;
    protected final AtomicLong sequenceNumber = new AtomicLong(1L);

    public ServerStatus() {
        this.events = new LinkedList();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String name = "IO Status";
        String description = "IO event updated";
        MBeanNotificationInfo info2 = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info2};
    }

    @Override
    public void onNIOBindNewPort(String version, String sslMode, String protocol, String bindAddr, int listeningPort, List<String> loadBalancingEndpoints) {
    }

    @Override
    public void onNIOAccessReportUpdate(String id, long hps, long tps, long totalHit, long pingHit, long bizHit, long totalChannel, long activeChannel, long task, long completed, long queue, long active, long pool, long core, long max, long largest) {
        Runnable asyncTask = () -> {
            BootIOStatusData data = new BootIOStatusData(DTF.format(LocalDateTime.now()), id, hps, tps, totalHit, pingHit, bizHit, totalChannel, activeChannel, task, completed, queue, active, pool, core, max, largest);
            this.events.addFirst(data);
            while (this.events.size() > 100) {
                this.events.removeLast();
            }
            this.setLastIOStatus(data.toString(), id);
        };
        QPS_SERVICE.execute(asyncTask);
    }

    @Override
    public void onHTTPClientAccessReportUpdate(long task, long completed, long queue, long active, long pool, long core, long max, long largest) {
        Runnable asyncTask = () -> {
            BootIOStatusData data = new BootIOStatusData(DTF.format(LocalDateTime.now()), "HTTPClient-IO", -1L, -1L, -1L, -1L, -1L, -1L, -1L, task, completed, queue, active, pool, core, max, largest);
            this.events.addFirst(data);
            while (this.events.size() > 100) {
                this.events.removeLast();
            }
            this.setLastIOStatus(data.toString(), "HTTPClient-IO");
        };
        QPS_SERVICE.execute(asyncTask);
    }

    protected synchronized void setLastIOStatus(String status, String source) {
        AttributeChangeNotification n = new AttributeChangeNotification(source, this.sequenceNumber.getAndIncrement(), System.currentTimeMillis(), status, "New IO Status", "java.lang.String", "", status);
        this.sendNotification(n);
    }

    @Override
    public String getIOReports() {
        String ret;
        try {
            List data = this.events.stream().collect(Collectors.toList());
            ret = BeanUtil.toJson(data);
        }
        catch (JsonProcessingException ex) {
            ret = ex.toString();
        }
        return ret;
    }

    @Override
    public String getLastIOReport() {
        BootIOStatusData event = this.events.getFirst();
        return event == null ? "" : event.toString();
    }

    @Override
    public long getHealthInspector() {
        return HealthInspector.retryIndex.get();
    }

    @Override
    public String getServiceStatus() {
        return HealthMonitor.isServiceAvailable() ? "OK" : "Service Unavaliable";
    }

    @Override
    public String getServiceStatusReason() {
        return HealthMonitor.getServiceStatusReason();
    }
}

