/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.httpclient;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.integration.httpclient.HttpClientConfig;
import org.summerboot.jexpress.integration.httpclient.RPCDelegate;
import org.summerboot.jexpress.integration.httpclient.RPCResult;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceErrorConvertible;

public abstract class RPCDelegate_HTTPClientImpl
implements RPCDelegate {
    protected abstract HttpClientConfig getHttpClientConfig();

    protected void configure(HttpRequest.Builder reqBuilder) {
        HttpClientConfig httpCfg = this.getHttpClientConfig();
        Map<String, String> httpClientDefaultRequestHeaders = httpCfg.getHttpClientDefaultRequestHeaders();
        httpClientDefaultRequestHeaders.keySet().forEach(key -> {
            String value = (String)httpClientDefaultRequestHeaders.get(key);
            reqBuilder.setHeader((String)key, value);
        });
        String proxyAuth = httpCfg.getProxyAuthorizationBasicValue();
        if (proxyAuth != null) {
            reqBuilder.setHeader("Proxy-Authorization", proxyAuth);
        }
        reqBuilder.timeout(Duration.ofMillis(httpCfg.getHttpClientTimeoutMs()));
    }

    @Override
    public <T, E extends ServiceErrorConvertible> RPCResult<T, E> rpcEx(ServiceContext serviceContext, HttpRequest.Builder reqBuilder, HttpResponseStatus ... successStatusList) throws IOException {
        this.configure(reqBuilder);
        HttpRequest req = reqBuilder.build();
        String reqbody = RPCDelegate.getHttpRequestBody(req);
        return this.rpcEx(serviceContext, req, reqbody, successStatusList);
    }

    @Override
    public <T, E extends ServiceErrorConvertible> RPCResult<T, E> rpcEx(ServiceContext serviceContext, HttpRequest req, HttpResponseStatus ... successStatusList) throws IOException {
        Optional<HttpRequest.BodyPublisher> pub = req.bodyPublisher();
        String reqbody = RPCDelegate.getHttpRequestBody(req);
        return this.rpcEx(serviceContext, req, reqbody, successStatusList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends ServiceErrorConvertible> RPCResult<T, E> rpcEx(ServiceContext context, HttpRequest originRequest, String originRequestBody, HttpResponseStatus ... successStatusList) throws IOException {
        HttpResponse<String> httpResponse;
        context.memo("1.RPC_req", originRequest.toString() + " caller=" + context.caller());
        if (originRequestBody != null) {
            context.memo("2.RPC_req.body", originRequestBody);
        }
        context.poi("rpc.begin");
        try {
            HttpClientConfig httpCfg = this.getHttpClientConfig();
            httpResponse = httpCfg.getHttpClient().send(originRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            Err<String> e = new Err<String>(BootErrorCode.APP_INTERRUPTED, null, null, (Throwable)ex, "RPC Interrupted");
            context.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).error(e);
            RPCResult rPCResult = new RPCResult(originRequest, originRequestBody, null, false);
            return rPCResult;
        }
        finally {
            context.poi("rpc.end");
        }
        boolean isRemoteSuccess = false;
        int statusCode = httpResponse.statusCode();
        if (successStatusList == null || successStatusList.length < 1) {
            isRemoteSuccess = statusCode == HttpResponseStatus.OK.code();
        } else {
            for (HttpResponseStatus successStatus : successStatusList) {
                if (statusCode != successStatus.code()) continue;
                isRemoteSuccess = true;
                break;
            }
        }
        RPCResult rpcResult = new RPCResult(originRequest, originRequestBody, httpResponse, isRemoteSuccess);
        String rpcResponseJsonBody = rpcResult.httpResponseBody();
        context.memo("3.RPC_resp", rpcResult.httpStatusCode() + " " + httpResponse.headers());
        context.memo("4.RPC_resp.body", rpcResponseJsonBody);
        return rpcResult;
    }

    @Override
    public <T, E extends ServiceErrorConvertible> RPCResult<T, E> rpcEx(ServiceContext context, RPCResult<T, E> request, HttpResponseStatus ... successStatusList) throws IOException {
        return this.rpcEx(context, request.getOriginRequest(), request.getOriginRequestBody(), successStatusList);
    }
}

