/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.mqtt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttPingSender;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.security.SSLConnectionFactory;

public abstract class MqttClientConfig
extends BootConfig {
    protected static final String FILENAME_TRUSTSTORE_4CLIENT = "truststore_mqtt_client.p12";
    protected static final String ID = "MQTT.client";
    @ConfigHeader(title="1. MQTT.client server endpoint", desc="protocol: tcp/ssl/local/ws/wss", format="protocol://servername:port", example="ssl://localhost:8883")
    @Config(key="MQTT.client.serverURI", predefinedValue="ssl://localhost:8883", required=true)
    protected volatile String serverURI;
    @Config(key="MQTT.client.ssl.Protocol", defaultValue="TLSv1.3")
    protected String sslProtocol;
    protected static final String KEY_kmf_key = "MQTT.client.ssl.KeyStore";
    protected static final String KEY_kmf_StorePwdKey = "MQTT.client.ssl.KeyStorePwd";
    protected static final String KEY_kmf_AliasKey = "MQTT.client.ssl.KeyAlias";
    protected static final String KEY_kmf_AliasPwdKey = "MQTT.client.ssl.KeyPwd";
    @ConfigHeader(title="2. MQTT.client keystore")
    @Config(key="MQTT.client.ssl.KeyStore", StorePwdKey="MQTT.client.ssl.KeyStorePwd", AliasKey="MQTT.client.ssl.KeyAlias", AliasPwdKey="MQTT.client.ssl.KeyPwd", desc="Path to key store file. Use SSL/TLS when keystore is provided, otherwise use plain socket", callbackMethodName4Dump="generateTemplate_keystore")
    protected volatile KeyManagerFactory kmf;
    protected static final String KEY_tmf_key = "MQTT.client.ssl.TrustStore";
    protected static final String KEY_tmf_StorePwdKey = "MQTT.client.ssl.TrustStorePwd";
    @ConfigHeader(title="3. MQTT.client truststore")
    @Config(key="MQTT.client.ssl.TrustStore", StorePwdKey="MQTT.client.ssl.TrustStorePwd", callbackMethodName4Dump="generateTemplate_truststore", desc="Path to trust store file. Auth the remote peer certificate when a truststore is provided, otherwise blindly trust all remote peer certificate")
    @JsonIgnore
    protected volatile TrustManagerFactory tmf;
    @Config(key="MQTT.client.VerifyHostname", defaultValue="true")
    protected volatile boolean verifyHostname;
    @JsonIgnore
    protected volatile SocketFactory socketFactory;
    @ConfigHeader(title="4. MQTT.client user credential")
    @Config(key="MQTT.client.clientId")
    protected volatile String clientId;
    @Config(key="MQTT.client.username")
    protected volatile String username;
    @JsonIgnore
    @Config(key="MQTT.client.password", validate=Config.Validate.Encrypted)
    protected volatile String password;
    @ConfigHeader(title="5. MQTT.client messaging")
    @Config(key="MQTT.client.defaultQoS", defaultValue="2", desc="0=At most once, Fire-and-Forget (QoS 0), 1=At least once (QoS 1), 2=Exactly once (QoS 2)")
    protected volatile int defaultQoS;

    public static void main(String[] args) {
        class A
        extends MqttClientConfig {
            A() {
            }
        }
        String t = MqttClientConfig.generateTemplate(A.class);
        System.out.println(t);
    }

    protected MqttClientConfig() {
    }

    protected void generateTemplate_keystore(StringBuilder sb) {
        sb.append("MQTT.client.ssl.KeyStore=keystore.p12\n");
        sb.append("MQTT.client.ssl.KeyStorePwd=DEC(changeit)\n");
        sb.append("MQTT.client.ssl.KeyAlias=server1_2048.jexpress.org\n");
        sb.append("MQTT.client.ssl.KeyPwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    protected void generateTemplate_truststore(StringBuilder sb) {
        sb.append("MQTT.client.ssl.TrustStore=truststore_mqtt_client.p12\n");
        sb.append("MQTT.client.ssl.TrustStorePwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    @Override
    protected void preLoad(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) {
        this.createIfNotExist("keystore.p12", "keystore.p12");
        this.createIfNotExist("truststore.p12", FILENAME_TRUSTSTORE_4CLIENT);
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        if (this.kmf != null) {
            this.socketFactory = new SSLConnectionFactory(this.kmf, this.tmf, this.sslProtocol);
        }
    }

    @Override
    public void shutdown() {
    }

    public MqttAsyncClient build() throws MqttException {
        return new MqttAsyncClient(this.serverURI, this.clientId, null, null, null);
    }

    public MqttAsyncClient build(MqttClientPersistence persistence, MqttPingSender pingSender, ScheduledExecutorService executorService) throws MqttException {
        return new MqttAsyncClient(this.serverURI, this.clientId, persistence, pingSender, executorService);
    }

    public MqttConnectionOptions buildConnectionOptions() {
        return this.buildConnectionOptions(this.username, this.password, this.socketFactory);
    }

    public MqttConnectionOptions buildConnectionOptions(String username, String password) {
        return this.buildConnectionOptions(username, password, this.socketFactory);
    }

    public MqttConnectionOptions buildConnectionOptions(String username, String password, SocketFactory socketFactory) {
        MqttConnectionOptions connOpts = new MqttConnectionOptions();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            connOpts.setUserName(username);
            connOpts.setPassword(password.getBytes());
        }
        if (socketFactory != null) {
            connOpts.setSocketFactory(socketFactory);
            connOpts.setHttpsHostnameVerificationEnabled(this.isVerifyHostname());
        }
        return connOpts;
    }

    public void shutdown(MqttAsyncClient asyncClient) throws MqttException {
        if (asyncClient != null) {
            asyncClient.disconnect();
            asyncClient.close(true);
        }
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDefaultQoS() {
        return this.defaultQoS;
    }
}

