/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.nio.server.AbortPolicyWithReport;
import org.summerboot.jexpress.nio.server.IoMultiplexer;
import org.summerboot.jexpress.util.BeanUtil;

public class NioConfig
extends BootConfig {
    public static final NioConfig cfg = new NioConfig();
    @ConfigHeader(title="1. NIO Network Listeners", format="ip1:port1, ip2:port2, ..., ipN:portN", example="192.168.1.10:8311, 127.0.0.1:8311, 0.0.0.0:8311")
    @Config(key="nio.server.bindings", predefinedValue="0.0.0.0:8211, 0.0.0.0:8311", required=true)
    protected volatile List<InetSocketAddress> bindingAddresses;
    @Config(key="nio.server.autostart", defaultValue="true")
    protected volatile boolean autoStart = true;
    @ConfigHeader(title="2. NIO Security")
    protected static final String KEY_kmf_key = "nio.server.ssl.KeyStore";
    protected static final String KEY_kmf_StorePwdKey = "nio.server.ssl.KeyStorePwd";
    protected static final String KEY_kmf_AliasKey = "nio.server.ssl.KeyAlias";
    protected static final String KEY_kmf_AliasPwdKey = "nio.server.ssl.KeyPwd";
    @JsonIgnore
    @Config(key="nio.server.ssl.KeyStore", StorePwdKey="nio.server.ssl.KeyStorePwd", AliasKey="nio.server.ssl.KeyAlias", AliasPwdKey="nio.server.ssl.KeyPwd", desc="Path to key store file. Use SSL/TLS when keystore is provided, otherwise use plain socket", callbackMethodName4Dump="generateTemplate_keystore")
    protected volatile KeyManagerFactory kmf = null;
    protected static final String KEY_tmf_key = "nio.server.ssl.TrustStore";
    protected static final String KEY_tmf_StorePwdKey = "nio.server.ssl.TrustStorePwd";
    @Config(key="nio.server.ssl.TrustStore", StorePwdKey="nio.server.ssl.TrustStorePwd", desc="Path to trust store file. Auth the remote peer certificate when a truststore is provided, otherwise blindly trust all remote peer certificate")
    @JsonIgnore
    protected volatile TrustManagerFactory tmf = null;
    @Config(key="nio.server.ssl.VerifyCertificateHost", defaultValue="false")
    protected volatile boolean verifyCertificateHost = false;
    @Config(key="nio.server.ssl.Provider", defaultValue="OPENSSL")
    protected volatile SslProvider sslProvider = SslProvider.OPENSSL;
    @Config(key="nio.server.ssl.Protocols", defaultValue="TLSv1.2, TLSv1.3")
    protected String[] sslProtocols = new String[]{"TLSv1.2", "TLSv1.3"};
    @Config(key="nio.server.ssl.CipherSuites", desc="use system default ciphersuites when not specified")
    protected String[] sslCipherSuites;
    @ConfigHeader(title="3.1 Socket controller")
    @Config(key="nio.server.socket.SO_REUSEADDR", defaultValue="true")
    protected volatile boolean soReuseAddr = true;
    @Config(key="nio.server.socket.SO_KEEPALIVE", defaultValue="true")
    protected volatile boolean soKeepAlive = true;
    @Config(key="nio.server.socket.TCP_NODELAY", defaultValue="true")
    protected volatile boolean soTcpNodelay = true;
    @Config(key="nio.server.socket.SO_LINGER", defaultValue="-1")
    protected volatile int soLinger = -1;
    @ConfigHeader(title="3.2 Socket Performance")
    @Config(key="nio.server.ssl.HandshakeTimeout.second", defaultValue="30")
    protected volatile int sslHandshakeTimeoutSeconds = 30;
    @Config(key="nio.server.socket.CONNECT_TIMEOUT.second", defaultValue="30")
    protected volatile int soConnectionTimeoutSeconds = 30;
    @Config(key="nio.server.socket.SO_BACKLOG", defaultValue="1024")
    protected volatile int soBacklog = 1024;
    @Config(key="nio.server.socket.SO_RCVBUF", defaultValue="1048576", desc=" - cat /proc/sys/net/ipv4/tcp_rmem (max 1024k)")
    protected volatile int soRcvBuf = 0x100000;
    @Config(key="nio.server.socket.SO_SNDBUF", defaultValue="1048576", desc=" - cat /proc/sys/net/ipv4/tcp_smem (max 1024k)")
    protected volatile int soSndBuf = 0x100000;
    @Config(key="nio.server.HttpObjectAggregator.maxContentLength", defaultValue="65536", desc="default - 64kb")
    protected volatile int httpObjectAggregatorMaxContentLength = 65536;
    @ConfigHeader(title="4.1 Netty controller")
    @Config(key="nio.server.multiplexer", defaultValue="AVAILABLE")
    protected volatile IoMultiplexer multiplexer = IoMultiplexer.AVAILABLE;
    @Config(key="nio.server.httpServerCodec.MaxInitialLineLength", defaultValue="8192")
    protected volatile int httpServerCodec_MaxInitialLineLength = 8192;
    @Config(key="nio.server.httpServerCodec.MaxHeaderSize", defaultValue="8192")
    protected volatile int httpServerCodec_MaxHeaderSize = 8192;
    @Config(key="nio.server.httpServerCodec.MaxChunkSize", defaultValue="8192")
    protected volatile int httpServerCodec_MaxChunkSize = 8192;
    @ConfigHeader(title="4.2 Netty Performance - NIO and Biz Exector Pool")
    @Config(key="nio.server.EventLoopGroup.AcceptorSize", defaultValue="0", desc="AcceptorSize 0 = number of bindings")
    protected volatile int nioEventLoopGroupAcceptorSize = 0;
    @Config(key="nio.server.EventLoopGroup.WorkerSize", predefinedValue="0", desc="WorkerSize 0 = current computer/VM's available processors x 2 + 1")
    protected volatile int nioEventLoopGroupWorkerSize = BootConstant.CPU_CORE * 2 + 1;
    @Config(key="nio.server.BizExecutor.mode", defaultValue="Mixed", desc="valid value = CPU, IO and Mixed (default) \nuse CPU core + 1 when application is CPU bound\nuse CPU core x 2 + 1 when application is I/O bound\nneed to find the best value based on your performance test result when nio.server.BizExecutor.mode=Mixed")
    protected volatile BootConfig.ThreadingMode tpeThreadingMode = BootConfig.ThreadingMode.Mixed;
    @Config(key="nio.server.BizExecutor.CoreSize", predefinedValue="0", desc="CoreSize 0 = current computer/VM's available processors x 2 + 1")
    protected volatile int tpeCore = BootConstant.CPU_CORE * 2 + 1;
    @Config(key="nio.server.BizExecutor.MaxSize", predefinedValue="0", desc="MaxSize 0 = current computer/VM's available processors x 2 + 1")
    protected volatile int tpeMax = BootConstant.CPU_CORE * 2 + 1;
    @Config(key="nio.server.BizExecutor.KeepAliveSec", defaultValue="60")
    protected volatile int tpeKeepAliveSeconds = 60;
    @Config(key="nio.server.BizExecutor.QueueSize", defaultValue="2147483647", desc="The waiting list size when the pool is full")
    protected volatile int tpeQueue = Integer.MAX_VALUE;
    @Config(key="nio.server.BizExecutor.prestartAllCoreThreads", defaultValue="false")
    protected boolean prestartAllCoreThreads = false;
    @Config(key="nio.server.BizExecutor.allowCoreThreadTimeOut", defaultValue="false")
    protected boolean allowCoreThreadTimeOut = false;
    protected ThreadPoolExecutor tpe = null;
    @Config(key="nio.server.BizExecutor.bizTimeoutWarnThresholdMs", defaultValue="5000")
    protected volatile long bizTimeoutWarnThresholdMs = 5000L;
    @ConfigHeader(title="4.3 Netty Channel Handler")
    @Config(key="nio.server.ReaderIdleSeconds", defaultValue="0", desc="rec Idle enabled only when value > 0")
    protected volatile int readerIdleSeconds = 0;
    @Config(key="nio.server.WriterIdleSeconds", defaultValue="0", desc="Sent Idle enabled only when value > 0")
    protected volatile int writerIdleSeconds = 0;
    @Config(key="nio.server.health.InspectionIntervalSeconds", defaultValue="5")
    protected volatile int healthInspectionIntervalSeconds = 5;
    @Config(key="nio.JAX-RS.fromJson.CaseInsensitive", defaultValue="false")
    protected volatile boolean fromJsonCaseInsensitive = false;
    @Config(key="nio.JAX-RS.fromJson.failOnUnknownProperties", defaultValue="true")
    protected volatile boolean fromJsonFailOnUnknownProperties = true;
    @Config(key="nio.JAX-RS.toJson.IgnoreNull", defaultValue="true")
    protected volatile boolean toJsonIgnoreNull = true;
    @Config(key="nio.JAX-RS.toJson.Pretty", defaultValue="false")
    protected volatile boolean toJsonPretty = false;
    @Config(key="nio.JAX-RS.jsonParser.TimeZone", desc="The ID for a TimeZone, either an abbreviation such as \"UTC\", a full name such as \"America/Toronto\", or a custom ID such as \"GMT-8:00\", or \"system\" as system default timezone.", defaultValue="system")
    protected TimeZone jsonParserTimeZone = TimeZone.getDefault();
    @Config(key="nio.WebSocket.Compress", defaultValue="true")
    protected volatile boolean webSocketCompress = true;
    @Config(key="nio.WebSocket.AllowExtensions", defaultValue="true")
    protected volatile boolean webSocketAllowExtensions = true;
    @Config(key="nio.WebSocket.maxFrameSize", defaultValue="5242880")
    protected volatile int webSocketMaxFrameSize = 0x500000;
    @Config(key="nio.WebSocket.AllowMaskMismatch", defaultValue="false")
    protected volatile boolean webSocketAllowMaskMismatch = false;
    @Config(key="nio.WebSocket.CheckStartsWith", defaultValue="false")
    protected volatile boolean webSocketCheckStartsWith = false;
    @Config(key="nio.WebSocket.DropPongFrames", defaultValue="true")
    protected volatile boolean webSocketDropPongFrames = true;
    @Config(key="nio.WebSocket.HandshakeTimeoutMs", defaultValue="10000")
    protected volatile long webSocketHandshakeTimeoutMs = 10000L;
    @ConfigHeader(title="5. IO Communication logging filter")
    @Config(key="nio.verbose.filter.usertype", defaultValue="ignore", desc="5.1 caller filter\nvalid value = id, uid, group, role, ignore")
    protected volatile VerboseTargetUserType filterUserType = VerboseTargetUserType.ignore;
    protected static final String KEY_FILTER_USERTYPE_RANGE = "nio.verbose.filter.usertype.range";
    @Config(key="nio.verbose.filter.usertype.range", desc="user range (when type=CallerId): N1 - N2 or N1, N2, ... , Nn \nuser range (when type=CallerName): johndoe, janedoe")
    protected volatile String filterUserVaue;
    protected volatile Set<String> filterCallerNameSet;
    protected volatile Set<Long> filterCallerIdSet;
    protected volatile long filterCallerIdFrom;
    protected volatile long filterCallerIdTo;
    @Config(key="nio.verbose.filter.codetype", defaultValue="all", desc="valid value = HttpStatusCode, AppErrorCode, all, ignore")
    protected volatile VerboseTargetCodeType filterCodeType = VerboseTargetCodeType.all;
    protected static final String KEY_FILTER_CODETYPE_RANGE = "nio.verbose.filter.codetype.range";
    @Config(key="nio.verbose.filter.codetype.range", desc="5.2 error code filter\ncode range: N1 - N2 or N1, N2, ... , Nn")
    protected volatile String filterCodeVaue;
    protected volatile Set<Long> filterCodeSet;
    protected volatile long filterCodeRangeFrom;
    protected volatile long filterCodeRangeTo;
    @Config(key="nio.verbose.aspect.ReqHeader", defaultValue="true")
    protected volatile boolean verboseReqHeader = true;
    @Config(key="nio.verbose.aspect.ReqContent", defaultValue="true")
    protected volatile boolean verboseReqContent = true;
    @Config(key="nio.verbose.aspect.RespHeader", defaultValue="true")
    protected volatile boolean verboseRespHeader = true;
    @Config(key="nio.verbose.aspect.RespContent", defaultValue="true")
    protected volatile boolean verboseRespContent = true;
    @ConfigHeader(title="6. POI logging filter")
    @Config(key="nio.verbose.ServiceTimePOI.type", defaultValue="all", desc="valid value = filter, all, ignore")
    protected volatile VerboseTargetPOIType filterPOIType = VerboseTargetPOIType.all;
    @Config(key="nio.verbose.ServiceTimePOI.filter", defaultValue="auth.begin, auth.end, db.begin, db.end", desc="CSV format")
    protected volatile Set<String> filterPOISet;
    protected static final String HEADER_SERVER_RESPONSE = "server.DefaultResponseHttpHeaders.";
    @ConfigHeader(title="7. Web Server Mode")
    @Config(key="server.http.web.docroot", defaultValue="docroot")
    protected volatile String docroot = "docroot";
    @Config(key="server.http.web.docroot.errorPageFolderName", defaultValue="errorpages")
    protected volatile String errorPageFolderName = "errorpages";
    @Config(key="server.http.web.welcomePage", defaultValue="index.html")
    protected volatile String welcomePage = "index.html";
    @Config(key="server.http.web-server.tempupload", defaultValue="temp/upload")
    protected volatile String tempUoload = "temp/upload";
    protected volatile boolean downloadMode;
    protected volatile File rootFolder;
    @ConfigHeader(title="8. Default Server Response HTTP Headers", desc="put generic HTTP response headers here", format="server.DefaultResponseHttpHeaders.<response_header_name>=<response_header_value>", example="server.DefaultResponseHttpHeaders.Access-Control-Allow-Origin=https://www.summerboot.org\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Headers=X-Requested-With, Content-Type, Origin, Authorization\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Methods=PUT,GET,POST,DELETE,OPTIONS,PATCH\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Credentials=false\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Credentials=false\nserver.DefaultResponseHttpHeaders.Access-Control-Max-Age=3600\nserver.DefaultResponseHttpHeaders.Content-Security-Policy=default-src 'self';script-src 'self' www.google-analytics.com www.google.com www.gstatic. js.stripe.com ajax.cloudflare.com;style-src 'self' 'unsafe-inline' cdnjs.cloudflare.com;img-src 'self' www.google-analytics.com stats.g.doubleclick.net www.gstatic.com;font-src 'self' cdnjs.cloudflare.com fonts.gstatic.com;base-uri 'self';child-src www.google.com js.stripe.com;form-action 'self';frame-ancestors 'none';report-uri=\"https://www.summerboot.org/report-uri\"\nserver.DefaultResponseHttpHeaders.X-XSS-Protection=1; mode=block\nserver.DefaultResponseHttpHeaders.Strict-Transport-Security=max-age=31536000;includeSubDomains;preload\nserver.DefaultResponseHttpHeaders.X-Frame-Options=sameorigin\nserver.DefaultResponseHttpHeaders.Expect-CT=max-age=86400, enforce, report-uri=\"https://www.summerboot.org/report-uri\"\nserver.DefaultResponseHttpHeaders.X-Content-Type-Options=nosniff\nserver.DefaultResponseHttpHeaders.Feature-Policy=autoplay 'none';camera 'none' ", callbackMethodName4Dump="generateTemplate_ResponseHeaders")
    protected HttpHeaders serverDefaultResponseHeaders;
    protected String docrootDir;
    protected String tempUoloadDir;

    public static void main(String[] args) {
        String t = NioConfig.generateTemplate(NioConfig.class);
        System.out.println(t);
    }

    protected NioConfig() {
    }

    @Override
    public void shutdown() {
        String tn = Thread.currentThread().getName();
        if (this.tpe != null && !this.tpe.isShutdown()) {
            System.out.println(tn + ": shutdown tpe");
            this.tpe.shutdown();
        }
    }

    protected void generateTemplate_keystore(StringBuilder sb) {
        sb.append("nio.server.ssl.KeyStore=keystore.p12\n");
        sb.append("nio.server.ssl.KeyStorePwd=DEC(changeit)\n");
        sb.append("nio.server.ssl.KeyAlias=server1_2048.jexpress.org\n");
        sb.append("nio.server.ssl.KeyPwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    protected void generateTemplate_ResponseHeaders(StringBuilder sb) {
        sb.append("#").append(HEADER_SERVER_RESPONSE).append("response_header_name=response_header_value\n");
    }

    public HttpHeaders getServerDefaultResponseHeaders() {
        return this.serverDefaultResponseHeaders;
    }

    @Override
    protected void preLoad(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) {
        this.createIfNotExist("keystore.p12", "keystore.p12");
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        Long[] a;
        this.rootFolder = cfgFile.getParentFile().getParentFile();
        this.docrootDir = null;
        this.docrootDir = this.rootFolder.getAbsolutePath() + File.separator + this.docroot;
        this.downloadMode = StringUtils.isBlank((CharSequence)this.welcomePage);
        this.tempUoloadDir = null;
        this.tempUoloadDir = this.rootFolder.getAbsolutePath() + File.separator + this.tempUoload;
        this.serverDefaultResponseHeaders = new DefaultHttpHeaders();
        Set _keys = props.keySet().stream().map(o -> o.toString()).collect(Collectors.toSet());
        ArrayList<String> keys = new ArrayList<String>(_keys);
        keys.forEach(name -> {
            if (name.startsWith(HEADER_SERVER_RESPONSE)) {
                String headerValue;
                String[] names = name.split("\\.");
                String headerName = names[2];
                if (headerName != null) {
                    headerName = headerName.trim();
                }
                if ((headerValue = props.getProperty((String)name)) != null) {
                    headerValue = headerValue.trim();
                }
                this.serverDefaultResponseHeaders.set(headerName, (Object)headerValue);
            }
        });
        if (this.nioEventLoopGroupAcceptorSize < 1) {
            this.nioEventLoopGroupAcceptorSize = this.bindingAddresses.size();
        }
        if (this.nioEventLoopGroupWorkerSize < 1) {
            this.nioEventLoopGroupWorkerSize = CPU_CORE * 2 + 1;
        }
        this.tpe = NioConfig.buildThreadPoolExecutor(this.tpe, "NIO.Biz", this.tpeThreadingMode, this.tpeCore, this.tpeMax, this.tpeQueue, this.tpeKeepAliveSeconds, new AbortPolicyWithReport("NIOBizThreadPoolExecutor"), this.prestartAllCoreThreads, this.allowCoreThreadTimeOut, false);
        BeanUtil.init(this.jsonParserTimeZone, this.fromJsonFailOnUnknownProperties, this.fromJsonCaseInsensitive, this.toJsonPretty, this.toJsonIgnoreNull);
        switch (this.filterUserType) {
            case id: {
                this.filterCallerIdSet = new HashSet<Long>();
                a = helper.getAsRangeLong(props, KEY_FILTER_USERTYPE_RANGE, this.filterCallerIdSet);
                if (a == null) break;
                this.filterCallerIdFrom = a[0];
                this.filterCallerIdTo = a[1];
                this.filterCallerIdSet = null;
                break;
            }
            case uid: 
            case group: 
            case role: {
                String[] na = helper.getAsCSV(props, KEY_FILTER_USERTYPE_RANGE, null);
                this.filterCallerNameSet = new HashSet<String>();
                this.filterCallerNameSet.addAll(Arrays.asList(na));
            }
        }
        switch (this.filterCodeType) {
            case HttpStatusCode: 
            case AppErrorCode: {
                this.filterCodeSet = new HashSet<Long>();
                a = helper.getAsRangeLong(props, KEY_FILTER_CODETYPE_RANGE, this.filterCodeSet);
                if (a == null) break;
                this.filterCodeRangeFrom = a[0];
                this.filterCodeRangeTo = a[1];
                this.filterCodeSet = null;
            }
        }
    }

    public ThreadPoolExecutor getBizExecutor() {
        return this.tpe;
    }

    public boolean isWebSocketCompress() {
        return this.webSocketCompress;
    }

    public boolean isWebSocketAllowExtensions() {
        return this.webSocketAllowExtensions;
    }

    public int getWebSocketMaxFrameSize() {
        return this.webSocketMaxFrameSize;
    }

    public boolean isWebSocketAllowMaskMismatch() {
        return this.webSocketAllowMaskMismatch;
    }

    public boolean isWebSocketCheckStartsWith() {
        return this.webSocketCheckStartsWith;
    }

    public boolean isWebSocketDropPongFrames() {
        return this.webSocketDropPongFrames;
    }

    public long getWebSocketHandshakeTimeoutMs() {
        return this.webSocketHandshakeTimeoutMs;
    }

    public List<InetSocketAddress> getBindingAddresses() {
        return this.bindingAddresses;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public boolean isVerifyCertificateHost() {
        return this.verifyCertificateHost;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public String[] getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public boolean isSoReuseAddr() {
        return this.soReuseAddr;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isSoTcpNodelay() {
        return this.soTcpNodelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getSslHandshakeTimeoutSeconds() {
        return this.sslHandshakeTimeoutSeconds;
    }

    public int getSoConnectionTimeoutSeconds() {
        return this.soConnectionTimeoutSeconds;
    }

    public int getSoBacklog() {
        return this.soBacklog;
    }

    public int getSoRcvBuf() {
        return this.soRcvBuf;
    }

    public int getSoSndBuf() {
        return this.soSndBuf;
    }

    public int getHttpObjectAggregatorMaxContentLength() {
        return this.httpObjectAggregatorMaxContentLength;
    }

    public IoMultiplexer getMultiplexer() {
        return this.multiplexer;
    }

    public int getHttpServerCodec_MaxInitialLineLength() {
        return this.httpServerCodec_MaxInitialLineLength;
    }

    public int getHttpServerCodec_MaxHeaderSize() {
        return this.httpServerCodec_MaxHeaderSize;
    }

    public int getHttpServerCodec_MaxChunkSize() {
        return this.httpServerCodec_MaxChunkSize;
    }

    public int getNioEventLoopGroupAcceptorSize() {
        return this.nioEventLoopGroupAcceptorSize;
    }

    public int getNioEventLoopGroupWorkerSize() {
        return this.nioEventLoopGroupWorkerSize;
    }

    public BootConfig.ThreadingMode getTpeThreadingMode() {
        return this.tpeThreadingMode;
    }

    public int getTpeCore() {
        return this.tpeCore;
    }

    public int getTpeMax() {
        return this.tpeMax;
    }

    public int getTpeQueue() {
        return this.tpeQueue;
    }

    public long getBizTimeoutWarnThresholdMs() {
        return this.bizTimeoutWarnThresholdMs;
    }

    public int getReaderIdleSeconds() {
        return this.readerIdleSeconds;
    }

    public int getWriterIdleSeconds() {
        return this.writerIdleSeconds;
    }

    public int getHealthInspectionIntervalSeconds() {
        return this.healthInspectionIntervalSeconds;
    }

    public boolean isFromJsonCaseInsensitive() {
        return this.fromJsonCaseInsensitive;
    }

    public boolean isFromJsonFailOnUnknownProperties() {
        return this.fromJsonFailOnUnknownProperties;
    }

    public TimeZone getJsonParserTimeZone() {
        return this.jsonParserTimeZone;
    }

    public boolean isToJsonIgnoreNull() {
        return this.toJsonIgnoreNull;
    }

    public boolean isToJsonPretty() {
        return this.toJsonPretty;
    }

    public VerboseTargetUserType getFilterUserType() {
        return this.filterUserType;
    }

    public Set<String> getFilterCallerNameSet() {
        return this.filterCallerNameSet;
    }

    public Set<Long> getFilterCallerIdSet() {
        return this.filterCallerIdSet;
    }

    public long getFilterCallerIdFrom() {
        return this.filterCallerIdFrom;
    }

    public long getFilterCallerIdTo() {
        return this.filterCallerIdTo;
    }

    public VerboseTargetCodeType getFilterCodeType() {
        return this.filterCodeType;
    }

    public Set<Long> getFilterCodeSet() {
        return this.filterCodeSet;
    }

    public long getFilterCodeRangeFrom() {
        return this.filterCodeRangeFrom;
    }

    public long getFilterCodeRangeTo() {
        return this.filterCodeRangeTo;
    }

    public boolean isVerboseReqHeader() {
        return this.verboseReqHeader;
    }

    public boolean isVerboseReqContent() {
        return this.verboseReqContent;
    }

    public boolean isVerboseRespHeader() {
        return this.verboseRespHeader;
    }

    public boolean isVerboseRespContent() {
        return this.verboseRespContent;
    }

    public VerboseTargetPOIType getFilterPOIType() {
        return this.filterPOIType;
    }

    public Set<String> getFilterPOISet() {
        return this.filterPOISet;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public String getDocrootDir() {
        return this.docrootDir;
    }

    public String getErrorPageFolderName() {
        return this.errorPageFolderName;
    }

    public String getWelcomePage() {
        return this.welcomePage;
    }

    public boolean isDownloadMode() {
        return this.downloadMode;
    }

    public String getTempUoloadDir() {
        return this.tempUoloadDir;
    }

    public static enum VerboseTargetUserType {
        id,
        uid,
        group,
        role,
        ignore;

    }

    public static enum VerboseTargetCodeType {
        HttpStatusCode,
        AppErrorCode,
        all,
        ignore;

    }

    public static enum VerboseTargetPOIType {
        filter,
        all,
        ignore;

    }
}

