/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.summerboot.jexpress.util.FormatterUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class RoleMapping {
    protected final String roleName;
    protected final Set<String> groups = new HashSet<String>();
    protected final Set<String> users = new HashSet<String>();

    public RoleMapping(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void add(Type type, String csv) {
        String[] a = FormatterUtil.parseCsv(csv);
        switch (type) {
            case users: {
                this.users.addAll(Arrays.asList(a));
                break;
            }
            case groups: {
                this.groups.addAll(Arrays.asList(a));
            }
        }
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public static enum Type {
        users,
        groups;

    }
}

