/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.config;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedDefaultThreadFactory
implements ThreadFactory {
    protected static final AtomicInteger poolNumber = new AtomicInteger(1);
    protected final ThreadGroup group;
    protected final AtomicInteger threadCounter = new AtomicInteger(1);
    protected final String namePrefix;

    private NamedDefaultThreadFactory(String tpeName) {
        this.group = Thread.currentThread().getThreadGroup();
        this.namePrefix = tpeName;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadCounter.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    public static ThreadFactory build(String tpeName, boolean useVirtualThread) {
        String namePrefix = tpeName + "-" + poolNumber.getAndIncrement() + (useVirtualThread ? "-vt-" : "-pt-");
        return new NamedDefaultThreadFactory(namePrefix);
    }
}

