/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.event;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpTimeoutException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.boot.event.HttpExceptionListener;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;

@Singleton
public class HttpExceptionHandler
implements HttpExceptionListener {
    @Inject
    protected PostOffice po;

    @Override
    public void onActionNotFound(ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        Err<CallSite> e = new Err<CallSite>(BootErrorCode.AUTH_INVALID_URL, null, null, null, (CallSite)((Object)("Action not found: " + String.valueOf(httptMethod) + " " + httpRequestPath)));
        context.error(e).status(HttpResponseStatus.NOT_FOUND).logRequestHeader(false).logRequestBody(false);
    }

    @Override
    public void onNamingException(NamingException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        if (ex instanceof AuthenticationException) {
            Err<String> e = new Err<String>(BootErrorCode.AUTH_LOGIN_FAILED, null, null, null, "Authentication failed");
            context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
        } else {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            if (cause == null) {
                cause = ex;
            }
            if (cause instanceof IOException) {
                HealthMonitor.inspect();
                this.nakFatal(context, HttpResponseStatus.BAD_GATEWAY, BootErrorCode.NETWORK_ERROR, "LDAP " + cause.getClass().getSimpleName(), ex, SMTPClientConfig.cfg.getEmailToAppSupport(), String.valueOf(httptMethod) + " " + httpRequestPath);
            } else {
                this.onNamingException(ex, cause, httptMethod, httpRequestPath, context);
            }
        }
    }

    protected void onNamingException(NamingException ex, Throwable cause, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        Err<String> e = new Err<String>(BootErrorCode.ACCESS_ERROR_LDAP, null, null, (Throwable)ex, cause.toString());
        context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    @Override
    public void onPersistenceException(PersistenceException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
        if (cause == null) {
            cause = ex;
        }
        if (cause instanceof IOException) {
            HealthMonitor.inspect();
            this.nakFatal(context, HttpResponseStatus.BAD_GATEWAY, BootErrorCode.ACCESS_ERROR_DATABASE, "DB " + cause.getClass().getSimpleName(), (Throwable)ex, SMTPClientConfig.cfg.getEmailToAppSupport(), String.valueOf(httptMethod) + " " + httpRequestPath);
        } else {
            this.onPersistenceException(ex, cause, httptMethod, httpRequestPath, context);
        }
    }

    protected void onPersistenceException(PersistenceException ex, Throwable cause, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        Err<String> e = new Err<String>(BootErrorCode.ACCESS_ERROR_DATABASE, null, null, (Throwable)ex, cause.toString());
        context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    @Override
    public void onHttpConnectTimeoutException(HttpConnectTimeoutException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        HealthMonitor.inspect();
        context.status(HttpResponseStatus.GATEWAY_TIMEOUT).level(Level.WARN).error(new Err<CallSite>(BootErrorCode.HTTP_CONNECTION_TIMEOUT, null, null, (Throwable)ex, (CallSite)((Object)("Http Connect Timeout: " + ex.getMessage()))));
    }

    @Override
    public void onHttpTimeoutException(HttpTimeoutException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        context.status(HttpResponseStatus.GATEWAY_TIMEOUT).level(Level.WARN).error(new Err<CallSite>(BootErrorCode.HTTP_REQUEST_TIMEOUT, null, null, (Throwable)ex, (CallSite)((Object)("Http Request Timeout: " + ex.getMessage()))));
    }

    @Override
    public void onRejectedExecutionException(Throwable ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        context.status(HttpResponseStatus.SERVICE_UNAVAILABLE).level(Level.WARN).error(new Err<CallSite>(BootErrorCode.HTTPCLIENT_TOO_MANY_CONNECTIONS_REJECT, null, null, ex, (CallSite)((Object)("Too many request, try again later: " + ex.getMessage()))));
    }

    @Override
    public void onConnectException(Throwable ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        HealthMonitor.inspect();
        this.nakFatal(context, HttpResponseStatus.BAD_GATEWAY, BootErrorCode.IO_BASE, "Failed to connect: " + ex.getClass().getSimpleName(), ex, SMTPClientConfig.cfg.getEmailToAppSupport(), String.valueOf(httptMethod) + " " + httpRequestPath);
    }

    @Override
    public void onIOException(Throwable ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        HealthMonitor.inspect();
        this.nakFatal(context, HttpResponseStatus.BAD_GATEWAY, BootErrorCode.IO_BASE, "IO issue: " + ex.getClass().getSimpleName(), ex, SMTPClientConfig.cfg.getEmailToAppSupport(), String.valueOf(httptMethod) + " " + httpRequestPath);
    }

    @Override
    public void onInterruptedException(InterruptedException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        Thread.currentThread().interrupt();
        this.nakFatal(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, BootErrorCode.APP_INTERRUPTED, "Service Interrupted", ex, SMTPClientConfig.cfg.getEmailToDevelopment(), String.valueOf(httptMethod) + " " + httpRequestPath);
    }

    @Override
    public void onUnexpectedException(Throwable ex, RequestProcessor processor, ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        this.nakFatal(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, BootErrorCode.NIO_UNEXPECTED_PROCESSOR_FAILURE, "Unexpected Failure: " + ex.getClass().getSimpleName(), ex, SMTPClientConfig.cfg.getEmailToDevelopment(), String.valueOf(httptMethod) + " " + httpRequestPath);
    }

    protected void nakFatal(ServiceContext context, HttpResponseStatus httpResponseStatus, int appErrorCode, String errorMessage, Throwable ex, Collection<String> emailTo, String content) {
        Err<String> e = new Err<String>(appErrorCode, null, null, ex, errorMessage);
        context.status(httpResponseStatus).level(Level.FATAL).error(e);
        if (this.po != null) {
            String briefContent = "caller=" + context.callerId() + ", request#" + context.txId() + ": " + content;
            this.po.sendAlertAsync(emailTo, errorMessage, briefContent, ex, true);
        }
    }
}

