/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.cache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileInputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.util.BeanUtil;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;

public class RedisConfig
implements JExpressConfig {
    protected static final String PK = "primary";
    protected static Logger log = LogManager.getLogger(RedisConfig.class);
    protected File cfgFile;
    protected volatile List<JedisPool> jedisPools;
    protected volatile JedisPool masterPool;
    protected volatile List<String> nodes;
    protected volatile int reconnectRetryIntervalMinutes;
    protected volatile int sendAlertIntervalMinutes;
    public static final RedisConfig cfg = new RedisConfig();

    @Override
    public File getCfgFile() {
        return this.cfgFile;
    }

    @Override
    public String name() {
        return "Redis Config";
    }

    @Override
    public String info() {
        try {
            return BeanUtil.toJson(this, true, false);
        }
        catch (JsonProcessingException ex) {
            return ex.toString();
        }
    }

    @Override
    public JExpressConfig temp() {
        return new RedisConfig();
    }

    @Override
    public void load(File cfgFile, boolean isReal) throws Exception {
        if (log == null) {
            log = LogManager.getLogger(this.getClass());
        }
        this.cfgFile = cfgFile.getAbsoluteFile();
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(cfgFile);){
            props.load(is);
        }
        if (this.jedisPools == null) {
            this.jedisPools = new ArrayList<JedisPool>();
        } else {
            this.jedisPools.clear();
        }
        if (this.nodes == null) {
            this.nodes = new ArrayList<String>();
        } else {
            this.nodes.clear();
        }
        ConfigUtil helper = new ConfigUtil(this.cfgFile.getAbsolutePath());
        this.reconnectRetryIntervalMinutes = helper.getAsInt(props, "redis.Reconnect.Retry.IntervalMinutes", 1);
        this.sendAlertIntervalMinutes = helper.getAsInt(props, "redis.SendAlert.IntervalMinutes", 10);
        this.masterPool = null;
        Set _keys = props.keySet().stream().map(o -> o.toString()).collect(Collectors.toSet());
        ArrayList<String> keys = new ArrayList<String>(_keys);
        Collections.sort(keys);
        keys.forEach(name -> {
            if (name.startsWith("redis.node")) {
                String url = props.getProperty((String)name);
                String[] fields = url.split("\\:");
                String[] f2 = fields[1].split("\\@");
                String encPwd = f2[0];
                String pwd = null;
                if (StringUtils.isNotBlank((CharSequence)encPwd)) {
                    try {
                        if (encPwd.startsWith("ENC(") && encPwd.endsWith(")")) {
                            pwd = SecurityUtil.decrypt(encPwd, true);
                        }
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        // empty catch block
                    }
                }
                String host = f2[1];
                int port = Integer.parseInt(fields[2]);
                JedisPool jp = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port, 2000, pwd);
                this.jedisPools.add(jp);
                this.nodes.add(host + ":" + port);
            }
        });
        String master = this.autoFailover(null);
        if (master != null) {
            this.nodes.add("current master=" + master);
        }
    }

    @Override
    public void shutdown() {
        this.jedisPools.forEach(p -> {
            try {
                p.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public String autoFailover(Throwable cause) {
        if (cause != null) {
            log.error((Object)cause);
        }
        long lastFailoveredMasterPoolTTL = 0L;
        this.masterPool = null;
        String key = PK;
        JedisPool firstAvaliableMasterPool = null;
        JedisPool failoveredMasterPool = null;
        for (JedisPool pool : this.jedisPools) {
            try {
                Jedis jedis = pool.getResource();
                try {
                    jedis.del("arbitraryValue_just_check-writable");
                    String anyValue = jedis.get(key);
                    if (anyValue == null) {
                        if (firstAvaliableMasterPool != null) continue;
                        firstAvaliableMasterPool = pool;
                        continue;
                    }
                    Long currentTTL = jedis.ttl(key);
                    if (currentTTL == null) {
                        currentTTL = 0L;
                    } else if (currentTTL < 0L) {
                        currentTTL = 9223372036854775L;
                    }
                    if (currentTTL <= lastFailoveredMasterPoolTTL) continue;
                    failoveredMasterPool = pool;
                    lastFailoveredMasterPoolTTL = currentTTL;
                }
                finally {
                    if (jedis == null) continue;
                    jedis.close();
                }
            }
            catch (JedisConnectionException | JedisDataException ex) {
                log.warn("find connection: " + String.valueOf(ex));
            }
        }
        if (failoveredMasterPool != null) {
            this.masterPool = failoveredMasterPool;
        } else if (firstAvaliableMasterPool != null) {
            this.masterPool = firstAvaliableMasterPool;
        }
        String ret = null;
        if (this.masterPool != null) {
            try (Jedis jedis = this.masterPool.getResource();){
                ret = jedis.getConnection().toString();
                long ttl = (Long.MAX_VALUE - System.currentTimeMillis() - 1000L) / 1000L;
                jedis.psetex(key, ttl, ret);
            }
        }
        return ret;
    }

    @JsonIgnore
    public Jedis getMaster() {
        if (this.masterPool == null) {
            return null;
        }
        return this.masterPool.getResource();
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public int getReconnectRetryIntervalMinutes() {
        return this.reconnectRetryIntervalMinutes;
    }

    public int getSendAlertIntervalMinutes() {
        return this.sendAlertIntervalMinutes;
    }
}

