/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class GRPCServerConfig
extends BootConfig {
    protected static final String FILENAME_TRUSTSTORE_4SERVER = "truststore_grpc_server.p12";
    protected static final String ID = "gRpc.server";
    public static final GRPCServerConfig cfg = new GRPCServerConfig();
    @ConfigHeader(title="1. gRpc.server Network Listeners", format="ip1:port1, ip2:port2, ..., ipN:portN", example="192.168.1.10:8424, 127.0.0.1:8424, 0.0.0.0:8424")
    @Config(key="gRpc.server.bindings", predefinedValue="0.0.0.0:8424, 0.0.0.0:8425", required=true)
    protected volatile List<InetSocketAddress> bindingAddresses;
    @Config(key="gRpc.server.autostart", defaultValue="true")
    protected volatile boolean autoStart;
    @Config(key="gRpc.server.pool.BizExecutor.mode", defaultValue="VirtualThread", desc="valid value = VirtualThread (default for Java 21+), CPU, IO and Mixed (default for old Java) \n use CPU core + 1 when application is CPU bound\nuse CPU core x 2 + 1 when application is I/O bound\nneed to find the best value based on your performance test result when nio.server.BizExecutor.mode=Mixed")
    protected volatile BootConfig.ThreadingMode tpeThreadingMode = BootConfig.ThreadingMode.VirtualThread;
    @Config(key="gRpc.server.pool.coreSize", predefinedValue="0", desc="coreSize 0 = current computer/VM's available processors x 2 + 1")
    protected volatile int tpeCore = BootConstant.CPU_CORE * 2 + 1;
    @Config(key="gRpc.server.pool.maxSize", predefinedValue="0", desc="maxSize 0 = current computer/VM's available processors x 2 + 1")
    protected volatile int tpeMax = BootConstant.CPU_CORE * 2 + 1;
    @Config(key="gRpc.server.pool.queueSize", defaultValue="2147483647", desc="The waiting list size when the pool is full")
    protected volatile int tpeQueue = Integer.MAX_VALUE;
    @Config(key="gRpc.server.pool.keepAliveSeconds", defaultValue="60")
    protected volatile long tpeKeepAliveSeconds = 60L;
    @Config(key="gRpc.server.pool.prestartAllCoreThreads", defaultValue="false")
    protected boolean prestartAllCoreThreads = false;
    @Config(key="gRpc.server.pool.allowCoreThreadTimeOut", defaultValue="false")
    protected boolean allowCoreThreadTimeOut = false;
    protected ThreadPoolExecutor tpe = null;
    protected static final String KEY_kmf_key = "gRpc.server.ssl.KeyStore";
    protected static final String KEY_kmf_StorePwdKey = "gRpc.server.ssl.KeyStorePwd";
    protected static final String KEY_kmf_AliasKey = "gRpc.server.ssl.KeyAlias";
    protected static final String KEY_kmf_AliasPwdKey = "gRpc.server.ssl.KeyPwd";
    @ConfigHeader(title="2. gRpc.server keystore")
    @Config(key="gRpc.server.ssl.KeyStore", StorePwdKey="gRpc.server.ssl.KeyStorePwd", AliasKey="gRpc.server.ssl.KeyAlias", AliasPwdKey="gRpc.server.ssl.KeyPwd", desc="Path to key store file. Use SSL/TLS when keystore is provided, otherwise use plain socket", callbackMethodName4Dump="generateTemplate_keystore")
    protected volatile KeyManagerFactory kmf;
    protected static final String KEY_tmf_key = "gRpc.server.ssl.TrustStore";
    protected static final String KEY_tmf_StorePwdKey = "gRpc.server.ssl.TrustStorePwd";
    @ConfigHeader(title="3. gRpc.server truststore")
    @Config(key="gRpc.server.ssl.TrustStore", StorePwdKey="gRpc.server.ssl.TrustStorePwd", callbackMethodName4Dump="generateTemplate_truststore", desc="Path to trust store file. Auth the remote peer certificate when a truststore is provided, otherwise blindly trust all remote peer certificate")
    @JsonIgnore
    protected volatile TrustManagerFactory tmf;

    public static void main(String[] args) {
        String t = GRPCServerConfig.generateTemplate(GRPCServerConfig.class);
        System.out.println(t);
    }

    protected GRPCServerConfig() {
    }

    protected void generateTemplate_keystore(StringBuilder sb) {
        sb.append("gRpc.server.ssl.KeyStore=keystore.p12\n");
        sb.append("gRpc.server.ssl.KeyStorePwd=DEC(changeit)\n");
        sb.append("gRpc.server.ssl.KeyAlias=server2_4096.jexpress.org\n");
        sb.append("gRpc.server.ssl.KeyPwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    protected void generateTemplate_truststore(StringBuilder sb) {
        sb.append("#gRpc.server.ssl.TrustStore=truststore_grpc_server.p12\n");
        sb.append("#gRpc.server.ssl.TrustStorePwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    @Override
    protected void preLoad(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) {
        this.createIfNotExist("truststore.p12", "keystore.p12");
        this.createIfNotExist("truststore.p12", FILENAME_TRUSTSTORE_4SERVER);
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws IOException {
        this.tpe = GRPCServerConfig.buildThreadPoolExecutor(this.tpe, "Netty-gRPC.Biz", this.tpeThreadingMode, this.tpeCore, this.tpeMax, this.tpeQueue, this.tpeKeepAliveSeconds, null, this.prestartAllCoreThreads, this.allowCoreThreadTimeOut, true);
    }

    @Override
    public void shutdown() {
        if (this.tpe != null && !this.tpe.isShutdown()) {
            this.tpe.shutdown();
        }
    }

    public List<InetSocketAddress> getBindingAddresses() {
        return this.bindingAddresses;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public BootConfig.ThreadingMode getTpeThreadingMode() {
        return this.tpeThreadingMode;
    }

    public int getTpeCore() {
        return this.tpeCore;
    }

    public int getTpeMax() {
        return this.tpeMax;
    }

    public int getTpeQueue() {
        return this.tpeQueue;
    }

    public long getTpeKeepAliveSeconds() {
        return this.tpeKeepAliveSeconds;
    }

    public ThreadPoolExecutor getTpe() {
        return this.tpe;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }
}

