/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.ws.rs;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.annotation.Deamon;
import org.summerboot.jexpress.boot.annotation.Log;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceRequest;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestParameter;
import org.summerboot.jexpress.nio.server.ws.rs.MetaMatrixParam;
import org.summerboot.jexpress.nio.server.ws.rs.MetaPathParam;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.FormatterUtil;

public class JaxRsRequestProcessor
implements RequestProcessor {
    protected final Object javaInstance;
    protected final Method javaMethod;
    protected final String declaredPath;
    protected final Set<String> rolesAllowed;
    protected final boolean roleBased;
    protected final boolean permitAll;
    protected final List<String> consumes;
    protected final List<String> produces;
    protected final String produce_ExplicitType;
    protected final String produce_DefaultType;
    protected final Log classLevelLogAnnotation;
    protected final boolean rejectWhenPaused;
    protected final boolean rejectWhenHealthCheckFailed;
    protected final List<JaxRsRequestParameter> parameterList;
    protected final boolean hasMatrixParam;
    protected final boolean hasPathParam;
    protected final Map<String, MetaPathParam> pathParamMap;
    protected final List<MetaMatrixParam> metaMatrixParamList;
    protected final Pattern regexPattern;
    protected final int parameterSize;
    public static final List<String> SupportedProducesWithReturnType = Arrays.asList("application/json", "application/json-patch+json", "application/xml", "text/xml", "text/plain", "text/html");
    protected final ProcessorSettings processorSettings;

    public JaxRsRequestProcessor(Object javaInstance, Method javaMethod, HttpMethod httpMethod, String path, Set<String> declareRoles) {
        Controller controllerAnnotation;
        String[] sa;
        String[] sa2;
        this.javaInstance = javaInstance;
        this.javaMethod = javaMethod;
        Class<?> controllerClass = javaInstance.getClass();
        String info2 = controllerClass.getName() + "." + javaMethod.getName();
        DeclareRoles drs = controllerClass.getAnnotation(DeclareRoles.class);
        if (drs != null) {
            declareRoles.addAll(Arrays.asList(drs.value()));
        }
        Deamon classLevelDeamon = controllerClass.getAnnotation(Deamon.class);
        Deamon methodLevelDeamon = javaMethod.getAnnotation(Deamon.class);
        if (methodLevelDeamon != null) {
            this.rejectWhenPaused = !methodLevelDeamon.ignorePause();
            this.rejectWhenHealthCheckFailed = !methodLevelDeamon.ignoreHealthCheck();
        } else if (classLevelDeamon != null) {
            this.rejectWhenPaused = !classLevelDeamon.ignorePause();
            this.rejectWhenHealthCheckFailed = !classLevelDeamon.ignoreHealthCheck();
        } else {
            this.rejectWhenPaused = true;
            this.rejectWhenHealthCheckFailed = true;
        }
        RolesAllowed rolesAllowedAnnotation = javaMethod.getAnnotation(RolesAllowed.class);
        PermitAll permitAllAnnotation = javaMethod.getAnnotation(PermitAll.class);
        DenyAll denyAllAnnotation = javaMethod.getAnnotation(DenyAll.class);
        if (permitAllAnnotation != null && denyAllAnnotation != null || permitAllAnnotation != null && rolesAllowedAnnotation != null || denyAllAnnotation != null && rolesAllowedAnnotation != null) {
            throw new UnsupportedOperationException("Only one security role is allowed: either @RolesAllowed, @PermitAll or @DenyAll @ " + info2);
        }
        if (permitAllAnnotation != null) {
            this.roleBased = true;
            this.rolesAllowed = declareRoles;
            this.permitAll = true;
        } else if (denyAllAnnotation != null) {
            this.roleBased = true;
            this.rolesAllowed = Set.of();
            this.permitAll = false;
        } else {
            this.permitAll = false;
            if (rolesAllowedAnnotation == null) {
                rolesAllowedAnnotation = controllerClass.getAnnotation(RolesAllowed.class);
            }
            if (rolesAllowedAnnotation != null) {
                this.roleBased = true;
                this.rolesAllowed = Set.of(rolesAllowedAnnotation.value());
                declareRoles.addAll(this.rolesAllowed);
            } else {
                this.roleBased = false;
                this.rolesAllowed = null;
            }
        }
        Consumes ac = javaMethod.getAnnotation(Consumes.class);
        if (ac == null) {
            ac = controllerClass.getAnnotation(Consumes.class);
        }
        ArrayList<String> temp = new ArrayList<String>();
        if (ac != null && (sa2 = ac.value()) != null && sa2.length > 0) {
            for (String s : sa2) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                temp.add(s.trim());
            }
        }
        if (temp.isEmpty()) {
            this.consumes = null;
        } else {
            this.consumes = List.copyOf(temp);
            temp.clear();
        }
        Produces ap = javaMethod.getAnnotation(Produces.class);
        if (ap == null) {
            ap = controllerClass.getAnnotation(Produces.class);
        }
        if (ap != null && (sa = ap.value()) != null && sa.length > 0) {
            for (String s : sa) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                temp.add(s.trim());
            }
        }
        if (temp.isEmpty()) {
            this.produces = null;
            this.produce_ExplicitType = null;
            this.produce_DefaultType = null;
        } else {
            Class<?> retType = javaMethod.getReturnType();
            if (retType != null && !retType.equals(String.class) && !retType.equals(File.class)) {
                ArrayList filter = new ArrayList(temp);
                filter.removeAll(SupportedProducesWithReturnType);
                if (!filter.isEmpty()) {
                    throw new UnsupportedOperationException("\n\t@Produces(" + String.valueOf(filter) + ") is not supported with return type(" + String.valueOf(retType) + ") @ " + info2 + ", supported @Produces values with return type are: " + String.valueOf(SupportedProducesWithReturnType));
                }
            }
            this.produces = List.copyOf(temp);
            this.produce_DefaultType = this.produces.get(0);
            this.produce_ExplicitType = this.produces.size() == 1 ? this.produce_DefaultType : null;
            temp.clear();
        }
        Parameter[] params = javaMethod.getParameters();
        ArrayList<JaxRsRequestParameter> parameterListTemp = new ArrayList<JaxRsRequestParameter>();
        ArrayList<MetaMatrixParam> metaMatrixParamListTemp = new ArrayList<MetaMatrixParam>();
        if (params != null && params.length > 0) {
            for (Parameter param : params) {
                JaxRsRequestParameter srp = new JaxRsRequestParameter(info2, httpMethod, this.consumes, param);
                parameterListTemp.add(srp);
                if (!srp.getType().equals((Object)JaxRsRequestParameter.ParamType.MatrixParam)) continue;
                metaMatrixParamListTemp.add(new MetaMatrixParam(srp.getKey()));
            }
        }
        this.parameterList = List.copyOf(parameterListTemp);
        this.parameterSize = this.parameterList.size();
        this.hasMatrixParam = !metaMatrixParamListTemp.isEmpty();
        this.metaMatrixParamList = this.hasMatrixParam ? List.copyOf(metaMatrixParamListTemp) : null;
        String pathParamRegex = "(\\/.*)";
        String pathParamRegex_OptionalInURL = "(\\/.*)?";
        String matrixParamRegx = "(;.+=.*)*";
        HashMap<String, MetaPathParam> pathParamMapTemp = new HashMap<String, MetaPathParam>();
        String[] pathMembers = FormatterUtil.parseURL(path);
        StringBuilder sb = new StringBuilder();
        int size = pathMembers.length;
        int last = size - 1;
        for (int i = 0; i < size; ++i) {
            String pathMember = pathMembers[i];
            if (StringUtils.isBlank((CharSequence)pathMember)) continue;
            if (pathMember.startsWith("{") && pathMember.endsWith("}")) {
                boolean isLast = i == last;
                String pathParamName = pathMember.substring(1, pathMember.length() - 1);
                String[] regexPathParamNames = pathParamName.split(":");
                MetaPathParam meta = new MetaPathParam(i, regexPathParamNames.length > 1 ? regexPathParamNames[1] : null, isLast);
                pathParamMapTemp.put(regexPathParamNames[0], meta);
                if (i < pathMembers.length - 1) {
                    sb.append(pathParamRegex);
                } else {
                    sb.append(pathParamRegex_OptionalInURL);
                }
            } else if (this.hasMatrixParam) {
                sb.append("\\/").append(pathMember);
            } else {
                sb.append("/").append(pathMember);
            }
            if (!this.hasMatrixParam) continue;
            sb.append(matrixParamRegx);
        }
        this.hasPathParam = !pathParamMapTemp.isEmpty();
        this.pathParamMap = this.hasPathParam ? Map.copyOf(pathParamMapTemp) : null;
        this.declaredPath = this.hasPathParam || this.hasMatrixParam ? sb.toString() : path;
        this.regexPattern = this.hasPathParam || this.hasMatrixParam ? Pattern.compile(this.declaredPath) : null;
        this.classLevelLogAnnotation = controllerClass.getAnnotation(Log.class);
        this.processorSettings = new ProcessorSettings();
        this.updateLogSettings(this.classLevelLogAnnotation);
        Log methodLevelLogAnnotation = javaMethod.getAnnotation(Log.class);
        this.updateLogSettings(methodLevelLogAnnotation);
        if (this.processorSettings.getLogSettings() != null) {
            this.processorSettings.getLogSettings().removeDuplicates();
        }
        if ((controllerAnnotation = controllerClass.getAnnotation(Controller.class)) != null) {
            this.processorSettings.setHttpServiceResponseHeaderName_Reference(controllerAnnotation.responseHeader_Reference());
            this.processorSettings.setHttpServiceResponseHeaderName_ServerTimestamp(controllerAnnotation.responseHeader_ServerTs());
        }
    }

    protected void updateLogSettings(Log log) {
        String[] protectedJsonArrayFields;
        String[] protectedJsonStringFields;
        if (log == null) {
            return;
        }
        ProcessorSettings.LogSettings logSettings = this.processorSettings.getLogSettings();
        if (logSettings == null) {
            logSettings = this.processorSettings.new ProcessorSettings.LogSettings();
            this.processorSettings.setLogSettings(logSettings);
        }
        logSettings.setLogRequestHeader(log.requestHeader());
        logSettings.setLogRequestBody(log.requestBody());
        logSettings.setLogResponseHeader(log.responseHeader());
        logSettings.setLogResponseBody(log.responseBody());
        String[] protectedJsonFields = log.hideJsonNumberFields();
        if (protectedJsonFields != null && protectedJsonFields.length > 0) {
            List<String> list = logSettings.getProtectedJsonNumberFields();
            if (list == null) {
                list = new ArrayList<String>();
                logSettings.setProtectedJsonNumberFields(list);
            }
            list.addAll(Arrays.asList(protectedJsonFields));
        }
        if ((protectedJsonStringFields = log.hideJsonStringFields()) != null && protectedJsonStringFields.length > 0) {
            List<String> list = logSettings.getProtectedJsonStringFields();
            if (list == null) {
                list = new ArrayList<String>();
                logSettings.setProtectedJsonStringFields(list);
            }
            list.addAll(Arrays.asList(protectedJsonStringFields));
        }
        if ((protectedJsonArrayFields = log.hideJsonArrayFields()) != null && protectedJsonArrayFields.length > 0) {
            List<String> list = logSettings.getProtectedJsonArrayFields();
            if (list == null) {
                list = new ArrayList<String>();
                logSettings.setProtectedJsonArrayFields(list);
            }
            list.addAll(Arrays.asList(protectedJsonArrayFields));
        }
    }

    @Override
    public ProcessorSettings getProcessorSettings() {
        return this.processorSettings;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.javaMethod.getAnnotation(annotationClass);
    }

    @Override
    public String getDeclaredPath() {
        return this.declaredPath;
    }

    @Override
    public boolean isRoleBased() {
        return this.roleBased;
    }

    @Override
    public boolean matches(String path) {
        if (this.regexPattern != null) {
            return this.regexPattern.matcher(path).matches();
        }
        return this.declaredPath.equals(path);
    }

    @Override
    public boolean authorizationCheck(ChannelHandlerContext channelHandlerCtx, HttpHeaders httpHeaders, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context, int badRequestErrorCode) throws Throwable {
        if (this.roleBased) {
            boolean isAuthorized = false;
            Object caller = context.caller();
            if (caller == null) {
                context.status(HttpResponseStatus.UNAUTHORIZED).error(new Err<String>(BootErrorCode.AUTH_INVALID_USER, null, null, null, "Authentication Required - Unkown caller"));
                return false;
            }
            for (String role : this.rolesAllowed) {
                if (!caller.isInRole(role)) continue;
                isAuthorized = true;
                break;
            }
            if (!isAuthorized) {
                context.status(HttpResponseStatus.FORBIDDEN).error(new Err<CallSite>(BootErrorCode.AUTH_NO_PERMISSION, null, null, null, (CallSite)((Object)("Authorization Failed - Caller is not in role: " + String.valueOf(this.rolesAllowed)))));
                return false;
            }
        }
        return true;
    }

    @Override
    public Object process(ChannelHandlerContext channelHandlerCtx, HttpHeaders httpHeaders, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) throws Throwable {
        Object ret;
        ServiceRequest request;
        Object[] paramValues = new Object[this.parameterSize];
        if (this.parameterSize > 0) {
            request = this.buildServiceRequest(channelHandlerCtx, httpHeaders, httpRequestPath, queryParams, httpPostRequestBody);
            for (int i = 0; i < this.parameterSize; ++i) {
                paramValues[i] = this.parameterList.get(i).value(request, context);
            }
            if (context.error() != null) {
                return null;
            }
        }
        try {
            context.poi("biz.begin");
            if (this.rejectWhenHealthCheckFailed && !HealthMonitor.isHealthCheckSuccess()) {
                context.status(HttpResponseStatus.BAD_GATEWAY).error(new Err<CallSite>(BootErrorCode.SERVICE_HEALTH_CHECK_FAILED, null, null, null, (CallSite)((Object)("Service health check failed: " + HealthMonitor.getStatusReasonHealthCheck()))));
                request = null;
                return request;
            }
            if (this.rejectWhenPaused && HealthMonitor.isServicePaused()) {
                context.status(HttpResponseStatus.SERVICE_UNAVAILABLE).error(new Err<CallSite>(BootErrorCode.SERVICE_PAUSED, null, null, null, (CallSite)((Object)("Service is paused: " + HealthMonitor.getStatusReasonPaused()))));
                request = null;
                return request;
            }
            ret = this.javaMethod.invoke(this.javaInstance, paramValues);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
        finally {
            context.poi("biz.end");
        }
        if (ret != null) {
            if (ret instanceof File) {
                context.file((File)ret, true);
            } else {
                String responseContentType = this.produce_ExplicitType;
                if (responseContentType == null) {
                    String clientAcceptedContentType = context.clientAcceptContentType();
                    if (clientAcceptedContentType == null) {
                        responseContentType = this.produce_DefaultType;
                    } else {
                        clientAcceptedContentType = clientAcceptedContentType.toLowerCase();
                        if (this.produces != null) {
                            for (String produce : this.produces) {
                                if (!clientAcceptedContentType.contains(produce)) continue;
                                responseContentType = produce;
                                break;
                            }
                            if (responseContentType == null) {
                                responseContentType = this.produce_DefaultType;
                            }
                        } else {
                            responseContentType = clientAcceptedContentType.contains("json") ? "application/json" : (clientAcceptedContentType.contains("xml") ? "application/xml" : (clientAcceptedContentType.contains("txt") ? "text/html" : "application/json"));
                        }
                    }
                    if (responseContentType == null) {
                        responseContentType = "application/json";
                    }
                }
                if (ret instanceof String) {
                    context.txt((String)ret);
                } else {
                    switch (responseContentType) {
                        case "application/json": {
                            context.txt(BeanUtil.toJson(ret));
                            break;
                        }
                        case "application/xml": 
                        case "text/xml": {
                            context.txt(BeanUtil.toXML(ret));
                            break;
                        }
                        case "text/html": 
                        case "text/plain": {
                            context.txt(ret.toString());
                        }
                    }
                }
                if (context.contentType() == null) {
                    context.contentType(responseContentType);
                }
            }
        }
        return ret;
    }

    public boolean hasMatrixPara() {
        return this.hasMatrixParam;
    }

    public boolean hasPathParam() {
        return this.hasPathParam;
    }

    public ServiceRequest buildServiceRequest(ChannelHandlerContext channelHandlerCtx, HttpHeaders httpHeaders, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody) {
        ServiceRequest req = new ServiceRequest(channelHandlerCtx, httpHeaders, httpRequestPath, queryParams, httpPostRequestBody);
        if (this.hasPathParam) {
            String[] pathList = FormatterUtil.parseURL(httpRequestPath);
            int size = pathList.length;
            this.pathParamMap.keySet().forEach(pathParamName -> {
                MetaPathParam meta = this.pathParamMap.get(pathParamName);
                int i = meta.getParamOrderIndex();
                if (i >= 0 && i < size) {
                    String value = pathList[i];
                    if (this.hasMatrixParam) {
                        int k = value.indexOf(";");
                        int e = value.indexOf("=");
                        if (k > 0 && e > k) {
                            value = value.substring(0, k);
                        }
                    }
                    if (meta.matches(value)) {
                        req.addPathParam((String)pathParamName, value);
                    }
                }
            });
        }
        if (this.hasMatrixParam) {
            this.metaMatrixParamList.forEach(matrixParamMeta -> {
                String key = matrixParamMeta.getKey();
                String value = matrixParamMeta.value(httpRequestPath);
                req.addMatrixParam(key, value);
            });
        }
        return req;
    }
}

