/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.summerboot.jexpress.nio.server.domain.ErrorCodeDeserializer;
import org.summerboot.jexpress.nio.server.domain.ErrorCodeSerializer;
import org.summerboot.jexpress.util.BeanUtil;

public class Err<T> {
    @JsonSerialize(using=ErrorCodeSerializer.class)
    @JsonDeserialize(using=ErrorCodeDeserializer.class)
    private String errorCode;
    private String errorTag;
    private String errorDesc;
    @JsonIgnore
    private Throwable cause;
    @JsonIgnore
    private T internalInfo;

    public Err(int errorCode, String errorTag, String errorDesc, Throwable ex) {
        this("" + errorCode, errorTag, errorDesc, ex, null);
    }

    public Err(int errorCode, String errorTag, String errorDesc, Throwable ex, T internalInfo) {
        this("" + errorCode, errorTag, errorDesc, ex, internalInfo);
    }

    public Err(String errorCode, String errorTag, String errorDesc, Throwable ex, T internalInfo) {
        this.errorCode = errorCode;
        this.errorTag = errorTag;
        this.errorDesc = errorDesc;
        this.cause = ex;
        this.internalInfo = internalInfo;
    }

    public String toJson() {
        try {
            return BeanUtil.toJson(this, true, true);
        }
        catch (JsonProcessingException ex) {
            return this.toStringEx(false);
        }
    }

    public String toString() {
        return this.toStringEx(true);
    }

    protected String toStringEx(boolean isForInternalDebug) {
        if (!isForInternalDebug) {
            return "{\"errorCode\": " + this.errorCode + ", errorTag=" + this.errorTag + ", \"errorDesc\": \"" + this.errorDesc + "\"}";
        }
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.cause);
        if (rootCause == null) {
            rootCause = this.cause;
        }
        String trace = ExceptionUtils.getStackTrace((Throwable)this.cause);
        return "{\"errorCode\": \"" + this.errorCode + "\", \"errorTag\"=\"" + this.errorTag + "\", \"errorDesc\": \"" + this.errorDesc + "\", \"internalInfo\": \"" + this.internalInfo + "\", \"cause\": \"" + rootCause + "\"}\n\t" + trace + "\n\n";
    }

    @JsonIgnore
    public int getErrorCodeInt() {
        return Integer.parseInt(this.errorCode);
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = "" + errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorTag() {
        return this.errorTag;
    }

    public void setErrorTag(String errorTag) {
        this.errorTag = errorTag;
    }

    public String getErrorDesc() {
        return this.errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public T getInternalInfo() {
        return this.internalInfo;
    }

    public void setInternalInfo(T internalInfo) {
        this.internalInfo = internalInfo;
    }
}

