/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;

public class ReflectionMetadata<T> {
    private final Class targetClass;
    private final String fieldName;
    private Field field;
    private T value;

    public ReflectionMetadata(Class targetClass, String fieldName) {
        this.targetClass = targetClass;
        this.fieldName = fieldName;
        if (targetClass != null && StringUtils.isNotBlank((CharSequence)fieldName)) {
            try {
                this.field = targetClass.getDeclaredField(fieldName);
                this.field.setAccessible(true);
                int modifier = this.field.getModifiers();
                if (!Modifier.isStatic(modifier)) {
                    throw new TypeNotPresentException("Wrong field modifier defined in " + targetClass.getName() + "\n\t found:    " + this.getFieldDefinationDefault() + " " + fieldName + "\n\t expected: " + this.getFieldDefinationExpected(true, null) + " " + fieldName, null);
                }
                this.value = this.field.get(null);
            }
            catch (NoSuchFieldException ex) {
                throw new TypeNotPresentException("No such field: " + targetClass + "." + fieldName, ex);
            }
            catch (IllegalAccessException ex) {
                throw new SecurityException("No access to field: " + targetClass + "." + fieldName, ex);
            }
        }
    }

    public T value() {
        return this.value;
    }

    public String buildClassCastExceptionDesc(String expectedType) {
        if (this.field == null) {
            return null;
        }
        return "Wrong field type defined in " + this.targetClass.getName() + "\n\t found:    " + this.getFieldDefinationDefault() + " " + this.fieldName + "\n\t expected: " + this.getFieldDefinationExpected(null, expectedType) + " " + this.fieldName;
    }

    private String getFieldDefinationDefault() {
        return this.getFieldDefinationExpected(null, null);
    }

    private String getFieldDefinationExpected(Boolean shouldBeStatic, String expectedType) {
        Object fieldType;
        if (this.field == null) {
            return null;
        }
        int modifier = this.field.getModifiers();
        Object modifierType = Modifier.toString(modifier);
        boolean isStatic = Modifier.isStatic(modifier);
        if (shouldBeStatic != null) {
            if (shouldBeStatic.booleanValue() && !isStatic) {
                modifierType = (String)modifierType + " static";
            } else if (!shouldBeStatic.booleanValue() && isStatic) {
                ((String)modifierType).replaceAll("static", "");
            }
        }
        Class<?> fieldClass = this.field.getType();
        if (expectedType == null) {
            Class<?> valueComponentType = fieldClass.getComponentType();
            Object object = fieldType = valueComponentType == null ? fieldClass.getName() : valueComponentType.getName();
            if (fieldClass.isArray()) {
                fieldType = (String)fieldType + "[]";
            }
        } else {
            fieldType = expectedType;
        }
        return (String)modifierType + " " + (String)fieldType;
    }
}

