/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.httpclient;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.integration.httpclient.HTTPClientStringSubscriber;
import org.summerboot.jexpress.integration.httpclient.HttpClientConfig;
import org.summerboot.jexpress.integration.httpclient.RPCResult;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceErrorConvertible;

public abstract class RPCDelegate_HTTPClientImpl {
    protected abstract HttpClientConfig getHttpClientConfig();

    public static String convertFormDataToString(Map<Object, Object> data) {
        StringBuilder sb = new StringBuilder();
        data.entrySet().forEach(entry -> {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8));
        });
        return sb.toString();
    }

    protected void configure(HttpRequest.Builder reqBuilder) {
        HttpClientConfig httpCfg = this.getHttpClientConfig();
        Map<String, String> httpClientDefaultRequestHeaders = httpCfg.getHttpClientDefaultRequestHeaders();
        httpClientDefaultRequestHeaders.keySet().forEach(key -> {
            String value = (String)httpClientDefaultRequestHeaders.get(key);
            reqBuilder.setHeader((String)key, value);
        });
        String proxyAuth = httpCfg.getProxyAuthorizationBasicValue();
        if (proxyAuth != null) {
            reqBuilder.setHeader("Proxy-Authorization", proxyAuth);
        }
        reqBuilder.timeout(Duration.ofMillis(httpCfg.getHttpClientTimeoutMs()));
    }

    protected <T, E extends ServiceErrorConvertible> RPCResult<T, E> rpcEx(ServiceContext serviceContext, HttpRequest.Builder reqBuilder, HttpResponseStatus ... successStatusList) throws IOException {
        this.configure(reqBuilder);
        HttpRequest req = reqBuilder.build();
        String reqbody = null;
        Optional<HttpRequest.BodyPublisher> pub = req.bodyPublisher();
        if (pub.isPresent()) {
            reqbody = pub.map(p -> {
                HttpResponse.BodySubscriber<String> bodySubscriber = HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
                HTTPClientStringSubscriber flowSubscriber = new HTTPClientStringSubscriber(bodySubscriber);
                p.subscribe(flowSubscriber);
                return bodySubscriber.getBody().toCompletableFuture().join();
            }).get();
        }
        return this.rpcEx(serviceContext, req, reqbody, successStatusList);
    }

    protected <T, E extends ServiceErrorConvertible> RPCResult<T, E> rpcEx(ServiceContext serviceContext, HttpRequest req, HttpResponseStatus ... successStatusList) throws IOException {
        String reqbody = null;
        Optional<HttpRequest.BodyPublisher> pub = req.bodyPublisher();
        if (pub.isPresent()) {
            reqbody = pub.map(p -> {
                HttpResponse.BodySubscriber<String> bodySubscriber = HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
                HTTPClientStringSubscriber flowSubscriber = new HTTPClientStringSubscriber(bodySubscriber);
                p.subscribe(flowSubscriber);
                return bodySubscriber.getBody().toCompletableFuture().join();
            }).get();
        }
        return this.rpcEx(serviceContext, req, reqbody, successStatusList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, E extends ServiceErrorConvertible> RPCResult<T, E> rpcEx(ServiceContext context, HttpRequest req, String reqbody, HttpResponseStatus ... successStatusList) throws IOException {
        HttpResponse<String> httpResponse;
        context.memo("1.RPC_req", req.toString() + " caller=" + context.caller());
        if (reqbody != null) {
            context.memo("2.RPC_req.body", reqbody);
        }
        context.poi("rpc.begin");
        try {
            HttpClientConfig httpCfg = this.getHttpClientConfig();
            httpResponse = httpCfg.getHttpClient().send(req, HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            RPCResult<T, E> rPCResult = this.onInterrupted(req, context, ex);
            return rPCResult;
        }
        finally {
            context.poi("rpc.end");
        }
        boolean isRemoteSuccess = false;
        int statusCode = httpResponse.statusCode();
        if (successStatusList == null || successStatusList.length < 1) {
            isRemoteSuccess = statusCode == HttpResponseStatus.OK.code();
        } else {
            for (HttpResponseStatus successStatus : successStatusList) {
                if (statusCode != successStatus.code()) continue;
                isRemoteSuccess = true;
                break;
            }
        }
        RPCResult rpcResult = new RPCResult(httpResponse, isRemoteSuccess);
        String rpcResponseJsonBody = rpcResult.httpResponseBody();
        context.memo("3.RPC_resp", rpcResult.httpStatusCode() + " " + httpResponse.headers());
        context.memo("4.RPC_resp.body", rpcResponseJsonBody);
        return rpcResult;
    }

    protected <T, E extends ServiceErrorConvertible> RPCResult<T, E> onInterrupted(HttpRequest req, ServiceContext serviceContext, Throwable ex) {
        Err<String> e = new Err<String>(BootErrorCode.APP_INTERRUPTED, null, null, ex, "RPC Interrupted");
        serviceContext.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).error(e);
        return new RPCResult(null, false);
    }
}

