/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security.auth;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.invoke.CallSite;
import java.security.Key;
import java.time.Duration;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.grpc.BearerAuthCredential;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.security.JwtUtil;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.security.auth.Authenticator;
import org.summerboot.jexpress.security.auth.AuthenticatorListener;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.security.auth.User;
import org.summerboot.jexpress.util.FormatterUtil;

@Singleton
public abstract class BootAuthenticator<E>
implements Authenticator<E>,
ServerInterceptor {
    protected static final String ERROR_NO_CFG = "JWT is not configured at " + AuthConfig.cfg.getCfgFile().getAbsolutePath();
    @Inject(optional=true)
    protected AuthenticatorListener authenticatorListener;
    @Inject
    protected AuthTokenCache authTokenCache;
    private static final String ERROR = "Bearer Authorization Failed: ";

    @Override
    public String signJWT(String username, String pwd, E metaData, int validForMinutes, ServiceContext context) throws NamingException {
        context.poi("ldap.begin");
        Caller caller = this.authenticate(username, pwd, metaData, this.authenticatorListener, context);
        context.poi("ldap.end");
        if (caller == null) {
            context.status(HttpResponseStatus.UNAUTHORIZED);
            return null;
        }
        Long tokenTtlSec = caller.getTokenTtlSec();
        Duration tokenTTL = tokenTtlSec != null ? Duration.ofSeconds(tokenTtlSec) : Duration.ofMinutes(validForMinutes);
        JwtBuilder builder = this.toJwt(caller);
        Key signingKey = AuthConfig.cfg.getJwtSigningKey();
        if (signingKey == null) {
            throw new UnsupportedOperationException(ERROR_NO_CFG);
        }
        String token = JwtUtil.createJWT(signingKey, builder, tokenTTL);
        if (this.authenticatorListener != null) {
            this.authenticatorListener.onLoginSuccess(caller.getUid(), token);
        }
        context.caller(caller);
        return token;
    }

    protected abstract Caller authenticate(String var1, String var2, E var3, AuthenticatorListener var4, ServiceContext var5) throws NamingException;

    @Override
    public JwtBuilder toJwt(Caller caller) {
        Set<String> keys;
        String groupsCsv;
        String jti = caller.getTenantId() + "." + caller.getId() + "_" + caller.getUid() + "_" + System.currentTimeMillis();
        String issuer = AuthConfig.cfg.getJwtIssuer();
        String userName = caller.getUid();
        Set<String> groups = caller.getGroups();
        String audience = groupsCsv = groups == null || groups.size() < 1 ? null : groups.stream().collect(Collectors.joining(","));
        Claims claims = Jwts.claims();
        claims.setId(jti).setIssuer(issuer).setSubject(userName).setAudience(audience);
        if (caller.getId() != null) {
            claims.put((Object)"callerId", (Object)caller.getId());
        }
        if (caller.getTenantId() != null) {
            claims.put((Object)"tenantId", (Object)caller.getTenantId());
        }
        if (caller.getTenantName() != null) {
            claims.put((Object)"tenantName", (Object)caller.getTenantName());
        }
        if ((keys = caller.propKeySet()) != null) {
            for (String key : keys) {
                Object v = caller.getProp(key, Object.class);
                claims.put((Object)key, v);
            }
        }
        JwtBuilder builder = Jwts.builder().setClaims(claims);
        return builder;
    }

    protected Claims parseJWT(String jwt) {
        JwtParser jwtParser = AuthConfig.cfg.getJwtParser();
        if (jwtParser == null) {
            throw new UnsupportedOperationException(ERROR_NO_CFG);
        }
        return (Claims)JwtUtil.parseJWT(jwtParser, jwt).getBody();
    }

    protected Caller fromJwt(Claims claims) {
        Set keys;
        String userName = claims.getSubject();
        String audience = claims.getAudience();
        Long userId = (Long)claims.get("callerId", Long.class);
        Long tenantId = (Long)claims.get("tenantId", Long.class);
        String tenantName = (String)claims.get("tenantName", String.class);
        User caller = new User(tenantId, tenantName, userId, userName);
        String userGroups = audience;
        if (StringUtils.isNotBlank((CharSequence)userGroups)) {
            String[] groups = FormatterUtil.parseCsv(userGroups);
            for (String group : groups) {
                caller.addGroup(group);
            }
        }
        if ((keys = claims.keySet()) != null) {
            for (String key : keys) {
                Object v = claims.get((Object)key);
                caller.putProp(key, v);
            }
        }
        caller.remove("aud");
        caller.remove("exp");
        caller.remove("jti");
        caller.remove("iat");
        caller.remove("iss");
        caller.remove("nbf");
        caller.remove("sub");
        caller.remove("callerId");
        caller.remove("tenantId");
        caller.remove("tenantName");
        return caller;
    }

    protected String getBearerToken(HttpHeaders httpRequestHeaders) {
        String authHeaderValue = httpRequestHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        return this.getBearerToken(authHeaderValue);
    }

    protected String getBearerToken(String authHeaderValue) {
        if (StringUtils.isBlank((CharSequence)authHeaderValue) || !authHeaderValue.startsWith("Bearer ")) {
            return null;
        }
        String[] a = authHeaderValue.split(" ");
        if (a.length < 2) {
            return null;
        }
        authHeaderValue = a[1];
        if (StringUtils.isBlank((CharSequence)authHeaderValue)) {
            return null;
        }
        return authHeaderValue;
    }

    @Override
    public Caller verifyToken(HttpHeaders httpRequestHeaders, AuthTokenCache cache, Integer errorCode, ServiceContext context) {
        String authToken = this.getBearerToken(httpRequestHeaders);
        return this.verifyToken(authToken, cache, errorCode, context);
    }

    @Override
    public Caller verifyToken(String authToken, AuthTokenCache cache, Integer errorCode, ServiceContext context) {
        errorCode = errorCode == null ? this.overrideVerifyTokenErrorCode() : errorCode;
        Caller caller = null;
        if (authToken == null) {
            Err<String> e = new Err<String>(errorCode != null ? errorCode : BootErrorCode.AUTH_REQUIRE_TOKEN, null, null, null, "Missing AuthToken");
            context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
        } else {
            try {
                Claims claims = this.parseJWT(authToken);
                String jti = claims.getId();
                context.callerId(jti);
                if (cache == null) {
                    cache = this.authTokenCache;
                }
                if (cache != null && cache.isBlacklist(jti)) {
                    Err<String> e = new Err<String>(errorCode != null ? errorCode : BootErrorCode.AUTH_EXPIRED_TOKEN, null, null, null, "AuthToken has been logout");
                    context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
                } else {
                    caller = this.fromJwt(claims);
                }
            }
            catch (ExpiredJwtException ex) {
                Err<CallSite> e = new Err<CallSite>(errorCode != null ? errorCode : BootErrorCode.AUTH_EXPIRED_TOKEN, null, null, null, (CallSite)((Object)("Expired AuthToken: " + ex)));
                context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
            }
            catch (JwtException ex) {
                Err<CallSite> e = new Err<CallSite>(errorCode != null ? errorCode : BootErrorCode.AUTH_INVALID_TOKEN, null, null, null, (CallSite)((Object)("Invalid AuthToken: " + ex)));
                context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
            }
        }
        context.caller(caller);
        return caller;
    }

    @Override
    public boolean customizedAuthorizationCheck(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, ServiceContext context) throws Exception {
        return true;
    }

    protected Integer overrideVerifyTokenErrorCode() {
        return null;
    }

    @Override
    public void logoutToken(HttpHeaders httpRequestHeaders, AuthTokenCache cache, ServiceContext context) {
        String authToken = this.getBearerToken(httpRequestHeaders);
        this.logoutToken(authToken, cache, context);
    }

    @Override
    public void logoutToken(String authToken, AuthTokenCache cache, ServiceContext context) {
        try {
            Claims claims = this.parseJWT(authToken);
            String jti = claims.getId();
            String uid = claims.getSubject();
            Date exp = claims.getExpiration();
            long expireInMilliseconds = exp.getTime() - System.currentTimeMillis();
            if (cache == null) {
                cache = this.authTokenCache;
            }
            if (cache != null) {
                cache.blacklist(jti, authToken, expireInMilliseconds);
            }
            if (this.authenticatorListener != null) {
                this.authenticatorListener.onLogout(claims, authToken, expireInMilliseconds);
            }
        }
        catch (ExpiredJwtException claims) {
        }
        catch (JwtException ex) {
            context.status(HttpResponseStatus.FORBIDDEN);
            return;
        }
        context.status(HttpResponseStatus.NO_CONTENT);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Status status;
        String headerValueAuthorization = (String)metadata.get(BearerAuthCredential.AUTHORIZATION_METADATA_KEY);
        if (headerValueAuthorization == null) {
            return Contexts.interceptCall((Context)Context.current(), serverCall, (Metadata)metadata, serverCallHandler);
        }
        if (!headerValueAuthorization.startsWith("Bearer")) {
            status = Status.INVALID_ARGUMENT.withDescription("Bearer Authorization Failed: Unknown authorization type, non bearer token provided");
        } else {
            try {
                String jwt = headerValueAuthorization.substring("Bearer".length()).trim();
                ServiceContext context = ServiceContext.build(0L);
                Caller caller = this.verifyToken(jwt, this.authTokenCache, null, context);
                if (caller != null) {
                    Context ctx = Context.current().withValue(GrpcCaller, (Object)caller);
                    String jti = context.callerId();
                    if (jti != null) {
                        ctx = ctx.withValue(GrpcCallerId, (Object)jti);
                    }
                    return Contexts.interceptCall((Context)ctx, serverCall, (Metadata)metadata, serverCallHandler);
                }
                String desc = context.error().getErrors().get(0).getErrorDesc();
                status = Status.INVALID_ARGUMENT.withDescription(ERROR + desc);
            }
            catch (Throwable ex) {
                status = Status.INVALID_ARGUMENT.withDescription(ERROR + ex.getMessage()).withCause(ex);
            }
        }
        serverCall.close(status, metadata);
        return new ServerCall.Listener<ReqT>(){};
    }
}

