/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import io.netty.channel.ChannelHandler;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.SummerSingularity;
import org.summerboot.jexpress.boot.annotation.Service;
import org.summerboot.jexpress.util.BeanUtil;

public class ScanedGuiceModule
extends AbstractModule {
    protected final Map<Class, Map<String, List<SummerSingularity.ServiceMetadata>>> scanedServiceBindingMap;
    protected final Set<String> userSpecifiedImplTags;
    protected final StringBuilder memo;
    protected final Map<Service.ChannelHandlerType, Set<String>> channelHandlerNames;
    protected static final String BIND_TO = " --> ";
    protected static final String INFO_FOUND = BootConstant.BR + "\t- Ioc.scan.found: ";
    protected static final String INFO_BIND = BootConstant.BR + "\t- Ioc.override.binding: ";

    public ScanedGuiceModule(Map<Class, Map<String, List<SummerSingularity.ServiceMetadata>>> scanedServiceBindingMap, Set<String> userSpecifiedImplTags, Map<Service.ChannelHandlerType, Set<String>> channelHandlerNames, StringBuilder memo) {
        this.scanedServiceBindingMap = scanedServiceBindingMap;
        this.userSpecifiedImplTags = userSpecifiedImplTags;
        this.channelHandlerNames = channelHandlerNames;
        this.memo = memo;
    }

    protected boolean isCliUseImplTag(String implTag) {
        return this.userSpecifiedImplTags.contains(implTag);
    }

    public void configure() {
        for (Class interfaceClass : this.scanedServiceBindingMap.keySet()) {
            SummerSingularity.ServiceMetadata bindingImpl;
            Map<String, List<SummerSingularity.ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(interfaceClass);
            SummerSingularity.ServiceMetadata defaultImpl = null;
            SummerSingularity.ServiceMetadata tagMatchImpl = null;
            HashMap<String, SummerSingularity.ServiceMetadata> namedServiceImpls = new HashMap<String, SummerSingularity.ServiceMetadata>();
            for (String uniqueKey : taggeServicedMap.keySet()) {
                SummerSingularity.ServiceMetadata serviceImpl = taggeServicedMap.get(uniqueKey).get(0);
                if (serviceImpl == null) continue;
                String implTag = serviceImpl.getImplTag();
                boolean isCliUseImplTag = this.isCliUseImplTag(implTag);
                this.memo.append(INFO_FOUND).append(interfaceClass.getName()).append(", implTag=").append(uniqueKey).append(BIND_TO).append(serviceImpl).append(", isCliUseImplTag=").append(isCliUseImplTag);
                String named = serviceImpl.getNamed();
                boolean notNamed = "".equals(named);
                if (notNamed) {
                    if ("".equals(implTag)) {
                        defaultImpl = serviceImpl;
                    }
                    if (!isCliUseImplTag) continue;
                    tagMatchImpl = serviceImpl;
                    continue;
                }
                if ("".equals(implTag) && !namedServiceImpls.containsKey(named)) {
                    namedServiceImpls.put(named, serviceImpl);
                }
                if (!isCliUseImplTag) continue;
                namedServiceImpls.put(named, serviceImpl);
            }
            SummerSingularity.ServiceMetadata serviceMetadata = bindingImpl = tagMatchImpl != null ? tagMatchImpl : defaultImpl;
            if (bindingImpl != null) {
                Class implClass_NotNamed = bindingImpl.getServiceImplClass();
                this.bind(interfaceClass).to(implClass_NotNamed);
                this.memo.append(INFO_BIND).append(interfaceClass).append(BIND_TO).append(implClass_NotNamed);
            }
            for (String named : namedServiceImpls.keySet()) {
                bindingImpl = (SummerSingularity.ServiceMetadata)namedServiceImpls.get(named);
                Class implClass_Named = bindingImpl.getServiceImplClass();
                this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)named)).to(implClass_Named);
                this.memo.append(INFO_BIND).append(interfaceClass).append(BIND_TO).append(implClass_Named).append(", named=").append(named);
                if (!interfaceClass.equals(ChannelHandler.class)) continue;
                Service.ChannelHandlerType channelHandlerType = bindingImpl.getChannelHandlerType();
                Set<String> nameList = this.channelHandlerNames.get((Object)channelHandlerType);
                if (nameList == null) {
                    nameList = new TreeSet<String>();
                    this.channelHandlerNames.put(channelHandlerType, nameList);
                }
                nameList.add(named);
                this.memo.append(", type=").append((Object)channelHandlerType);
            }
        }
        try {
            String c = BeanUtil.toJson(this.channelHandlerNames, true, true);
            this.memo.append(BootConstant.BR).append("\t- Ioc.userdefined.ChannelHandlers: ").append(c);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

