/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.event;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.OffsetDateTime;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.event.AppLifecycleListener;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;

@Singleton
public class AppLifecycleHandler
implements AppLifecycleListener {
    protected static final Logger log = LogManager.getLogger((String)AppLifecycleHandler.class.getName());
    @Inject
    protected PostOffice postOffice;

    @Override
    public void onApplicationStart(String appVersion, String fullConfigInfo) {
        if (this.postOffice != null) {
            this.postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Started at " + OffsetDateTime.now(), fullConfigInfo, null, false);
        }
    }

    @Override
    public void onApplicationStop(String appVersion) {
        if (this.postOffice != null) {
            this.postOffice.sendAlertSync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Shutdown at " + OffsetDateTime.now() + " - " + appVersion, "EOM", null, false);
        }
    }

    @Override
    public void onApplicationStatusUpdated(boolean healthOk, boolean paused, boolean serviceStatusChanged, String reason) {
        if (serviceStatusChanged) {
            boolean serviceAvaliable = healthOk && !paused;
            String content = "\n\t server status changed: paused=" + paused + ", OK=" + healthOk + ", serviceAvaliable=" + serviceAvaliable + "\n\t reason: " + reason;
            log.log(healthOk ? Level.WARN : Level.FATAL, content);
            if (this.postOffice != null) {
                this.postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Service Status Changed", content, null, false);
            }
        }
    }

    @Override
    public void onHealthInspectionDone(boolean healthOk, String reason) {
        if (!healthOk && this.postOffice != null) {
            this.postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Health Inspection Failed", reason, null, true);
        }
    }
}

