/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.quartz;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.annotation.Scheduled;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.ReflectionMetadata;
import org.summerboot.jexpress.util.TimeUtil;

public class QuartzUtil {
    protected static final Logger log = LogManager.getLogger(QuartzUtil.class);
    public static final TimeUtil.ZoneOffsetTransitionInfo DEFAULT_DST_Transition_INFO = TimeUtil.getZoneOffsetTransitionInfo(ZoneId.systemDefault());
    public static final Map<Integer, String> QUARTZ_WEEKDAY_MAP = Map.of(1, "SUN", 2, "MON", 3, "TUE", 4, "WED", 5, "THU", 6, "FRI", 7, "SAT");

    public static int addQuartzJob(Scheduler scheduler, Class<? extends Job> jobClass) throws SchedulerException {
        int[] daysOfWeek;
        int[] daysOfMonth;
        String[] cronExpressions;
        Scheduled scheduledAnnotation = jobClass.getAnnotation(Scheduled.class);
        if (scheduledAnnotation == null) {
            return 0;
        }
        ReflectionMetadata stringArrayFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.cronField());
        try {
            String[] cronExpressionsConfig = (String[])stringArrayFieldValue.value();
            String[] cronExpressionsHardcoded = scheduledAnnotation.cron();
            cronExpressions = BeanUtil.arrayMergeAndRemoveDuplicated(cronExpressionsHardcoded, cronExpressionsConfig);
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(stringArrayFieldValue.buildClassCastExceptionDesc("String[]"), ex);
        }
        ReflectionMetadata intArrayFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.daysOfMonthField());
        try {
            int[] daysOfMonthConfig = (int[])intArrayFieldValue.value();
            int[] daysOfMonthHardcoded = scheduledAnnotation.daysOfMonth();
            daysOfMonth = BeanUtil.arrayMergeAndRemoveDuplicated(daysOfMonthHardcoded, daysOfMonthConfig);
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(intArrayFieldValue.buildClassCastExceptionDesc("int[]"), ex);
        }
        intArrayFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.daysOfWeekField());
        try {
            int[] daysOfWeekhConfig = (int[])intArrayFieldValue.value();
            int[] daysOfWeekHardcoded = scheduledAnnotation.daysOfWeek();
            daysOfWeek = BeanUtil.arrayMergeAndRemoveDuplicated(daysOfWeekHardcoded, daysOfWeekhConfig);
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(intArrayFieldValue.buildClassCastExceptionDesc("int[]"), ex);
        }
        int hour = scheduledAnnotation.hour();
        ReflectionMetadata intFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.hourField());
        try {
            Integer hourConfig = (Integer)intFieldValue.value();
            if (hourConfig != null) {
                hour = hourConfig;
            }
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(intFieldValue.buildClassCastExceptionDesc("int"), ex);
        }
        int minute = scheduledAnnotation.minute();
        intFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.minuteField());
        try {
            Integer minuteConfig = (Integer)intFieldValue.value();
            if (minuteConfig != null) {
                minute = minuteConfig;
            }
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(intFieldValue.buildClassCastExceptionDesc("int"), ex);
        }
        int second = scheduledAnnotation.second();
        intFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.secondField());
        try {
            Integer secondConfig = (Integer)intFieldValue.value();
            if (secondConfig != null) {
                second = secondConfig;
            }
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(intFieldValue.buildClassCastExceptionDesc("int"), ex);
        }
        long fixedRateMs = scheduledAnnotation.fixedRateMs();
        ReflectionMetadata longFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.fixedRateMsField());
        try {
            Long fixedRateMsConfig = (Long)longFieldValue.value();
            if (fixedRateMsConfig != null) {
                fixedRateMs = fixedRateMsConfig;
            }
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(intFieldValue.buildClassCastExceptionDesc("long"), ex);
        }
        long fixedDelayMs = scheduledAnnotation.fixedDelayMs();
        longFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.fixedDelayMsField());
        try {
            Long fixedDelayMsConfig = (Long)longFieldValue.value();
            if (fixedDelayMsConfig != null) {
                fixedDelayMs = fixedDelayMsConfig;
            }
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(intFieldValue.buildClassCastExceptionDesc("long"), ex);
        }
        long initialDelayMs = scheduledAnnotation.initialDelayMs();
        longFieldValue = new ReflectionMetadata(jobClass, scheduledAnnotation.initialDelayMsField());
        try {
            Long initialDelayMsConfig = (Long)longFieldValue.value();
            if (initialDelayMsConfig != null) {
                initialDelayMs = initialDelayMsConfig;
            }
        }
        catch (ClassCastException ex) {
            throw new TypeNotPresentException(intFieldValue.buildClassCastExceptionDesc("long"), ex);
        }
        return QuartzUtil.addQuartzJob(scheduler, jobClass, daysOfMonth, daysOfWeek, (Integer)hour, (Integer)minute, (Integer)second, (Long)fixedRateMs, (Long)fixedDelayMs, (Long)initialDelayMs, cronExpressions);
    }

    public static int addQuartzJob(Scheduler scheduler, Class<? extends Job> jobClass, int[] daysOfMonth, int[] daysOfWeek, Integer hour, Integer minute, Integer second, Long fixedRateMs, Long fixedDelayMs, Long initialDelayMs, String ... cronExpressions) throws SchedulerException {
        boolean isFixedDelayJob = fixedDelayMs != null && fixedDelayMs > 0L;
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobClass.getName(), jobClass.getName()).storeDurably(!isFixedDelayJob).build();
        return QuartzUtil.addQuartzJob(scheduler, jobDetail, daysOfMonth, daysOfWeek, hour, minute, second, fixedRateMs, fixedDelayMs, initialDelayMs, cronExpressions);
    }

    protected static int trim(Integer hour_minute) {
        if (hour_minute == null || hour_minute < 0) {
            return 0;
        }
        return hour_minute;
    }

    public static int addQuartzJob(Scheduler scheduler, JobDetail jobDetail, int[] daysOfMonth, int[] daysOfWeek, Integer hour, Integer minute, Integer second, Long fixedRateMs, Long fixedDelayMs, Long initialDelayMs, String ... cronExpressions) throws SchedulerException {
        boolean isFixedDelayJob;
        boolean isCronJobs = cronExpressions != null && cronExpressions.length > 0;
        boolean isMonthlyJob = daysOfMonth != null && daysOfMonth.length > 0;
        boolean isWeeklyJob = daysOfWeek != null && daysOfWeek.length == 1;
        boolean isWeeklyJobs = daysOfWeek != null && daysOfWeek.length > 1;
        boolean isNotByDay = !isMonthlyJob && !isWeeklyJob && !isWeeklyJobs;
        boolean isDailyJob = isNotByDay && hour != null && hour >= 0;
        boolean isHourlyJob = isNotByDay && !isDailyJob && minute != null && minute >= 0;
        boolean isMinutelyJob = isNotByDay && !isDailyJob && !isHourlyJob && second != null && second >= 0;
        boolean isFixedRateJob = fixedRateMs != null && fixedRateMs > 0L;
        boolean bl = isFixedDelayJob = fixedDelayMs != null && fixedDelayMs > 0L;
        if ((isMonthlyJob || isWeeklyJob || isWeeklyJobs || isDailyJob || isHourlyJob || isMinutelyJob || isCronJobs || isFixedRateJob) && isFixedDelayJob) {
            throw new SchedulerException("Unable to create Fixed Delay Job with other jobs");
        }
        Class jobClass = jobDetail.getJobClass();
        String jobName = jobClass.getName();
        int triggers = 0;
        JobKey jobKey = jobDetail.getKey();
        if (jobDetail.isDurable()) {
            scheduler.addJob(jobDetail, true);
        }
        if (isMonthlyJob) {
            for (int dayOfMonth : daysOfMonth) {
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withDescription(jobName + ".Monthly@" + dayOfMonth + "md" + QuartzUtil.trim(hour) + "h:" + QuartzUtil.trim(minute) + "m").withSchedule((ScheduleBuilder)CronScheduleBuilder.monthlyOnDayAndHourAndMinute((int)dayOfMonth, (int)QuartzUtil.trim(hour), (int)QuartzUtil.trim(minute))).build();
                scheduler.scheduleJob((Trigger)trigger);
                ++triggers;
            }
        }
        if (isWeeklyJob) {
            int dayOfWeek = daysOfWeek[0];
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withDescription(jobName + ".Weekly@" + QUARTZ_WEEKDAY_MAP.get(dayOfWeek) + "md" + QuartzUtil.trim(hour) + "h:" + QuartzUtil.trim(minute) + "m").withSchedule((ScheduleBuilder)CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)dayOfWeek, (int)QuartzUtil.trim(hour), (int)QuartzUtil.trim(minute))).build();
            scheduler.scheduleJob((Trigger)trigger);
            ++triggers;
        } else if (isWeeklyJobs) {
            int dayOfMonth;
            Integer[] dow = (Integer[])Arrays.stream(daysOfWeek).boxed().toArray(Integer[]::new);
            Object desc = "";
            Integer[] integerArray = dow;
            dayOfMonth = integerArray.length;
            for (int trigger = 0; trigger < dayOfMonth; ++trigger) {
                int dayOfWeek = integerArray[trigger];
                desc = (String)desc + "." + QUARTZ_WEEKDAY_MAP.get(dayOfWeek);
            }
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withDescription(jobName + ".Weekly@" + (String)desc + "wd" + QuartzUtil.trim(hour) + "h:" + QuartzUtil.trim(minute) + "m").withSchedule((ScheduleBuilder)CronScheduleBuilder.atHourAndMinuteOnGivenDaysOfWeek((int)QuartzUtil.trim(hour), (int)QuartzUtil.trim(minute), (Integer[])dow)).build();
            scheduler.scheduleJob((Trigger)trigger);
            ++triggers;
        }
        if (isDailyJob) {
            String desc = jobName + ".Daily@" + hour + "h:" + QuartzUtil.trim(minute) + "m";
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withDescription(desc).withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)hour, (int)QuartzUtil.trim(minute))).build();
            scheduler.scheduleJob((Trigger)trigger);
            ++triggers;
            String cronAnnualCompensationForDSTGap = DEFAULT_DST_Transition_INFO.buildCronExpression4JobSkippedWhenDSTStarts(hour, QuartzUtil.trim(minute));
            if (cronAnnualCompensationForDSTGap != null) {
                CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withDescription(desc + ".Annual Compensation for Daylight Saving Time Gap@" + cronAnnualCompensationForDSTGap).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronAnnualCompensationForDSTGap)).build();
                scheduler.scheduleJob((Trigger)cronTrigger);
                ++triggers;
            }
        } else if (minute != null && minute >= 0) {
            String desc = jobName + ".Hourly@" + minute;
            String cron = QuartzUtil.trim(second) + " " + minute + " * * * ?";
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withDescription(desc).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            scheduler.scheduleJob((Trigger)trigger);
            ++triggers;
        } else if (second != null && second >= 0) {
            String desc = jobName + ".Minutely@" + second;
            String cron = second + " * * * * ?";
            CronTrigger trigger_daily_ExceptTheDayDSTStarts = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withDescription(desc).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            scheduler.scheduleJob((Trigger)trigger_daily_ExceptTheDayDSTStarts);
            ++triggers;
        }
        if (isFixedRateJob) {
            long delay = initialDelayMs;
            if (initialDelayMs == null || initialDelayMs < 0L) {
                delay = 0L;
            }
            Date startTime = new Date(System.currentTimeMillis() + delay);
            String desc = jobName + "@fixedRate:" + fixedRateMs + "ms, start@" + startTime;
            Trigger trigger = TriggerBuilder.newTrigger().forJob(jobKey).withDescription(desc).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(fixedRateMs.longValue()).repeatForever()).startAt(startTime).build();
            scheduler.scheduleJob(trigger);
            ++triggers;
        }
        if (isFixedDelayJob) {
            long delay = initialDelayMs;
            if (initialDelayMs == null || initialDelayMs < 0L) {
                delay = 0L;
            }
            Date startTime = new Date(System.currentTimeMillis() + delay);
            String desc = jobName + "@fixedDelay:" + fixedDelayMs + "ms, start@" + startTime;
            JobDataMap data = jobDetail.getJobDataMap();
            data.put("jExpress_FIXED_DELAY_VALUE", (Object)fixedDelayMs);
            data.put("jExpress_FIXED_DELAY_DESC", desc);
            Trigger trigger = TriggerBuilder.newTrigger().forJob(jobKey).withDescription(desc).startAt(startTime).build();
            scheduler.scheduleJob(jobDetail, trigger);
            ++triggers;
        }
        if (isCronJobs) {
            for (String cronExpression : cronExpressions) {
                if (StringUtils.isBlank((CharSequence)cronExpression)) continue;
                CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(jobKey).withDescription(jobName + ".Cron:" + cronExpression).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
                scheduler.scheduleJob((Trigger)cronTrigger);
                ++triggers;
            }
        }
        return triggers;
    }

    public static List<Date> getNextFireTimes(Scheduler scheduler, StringBuilder sb) throws SchedulerException {
        ArrayList<Date> ret = new ArrayList<Date>();
        Set tks = scheduler.getTriggerKeys(null);
        if (tks == null) {
            return ret;
        }
        for (TriggerKey tk : tks) {
            Trigger t = scheduler.getTrigger(tk);
            Date d = t.getNextFireTime();
            ret.add(d);
            if (sb == null) continue;
            sb.append(BootConstant.BR).append("\t").append(d).append(" - ").append(t.getDescription());
        }
        return ret;
    }
}

