/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.event;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.time.OffsetDateTime;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.event.AppLifecycleListener;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;

@Singleton
public class AppLifecycleHandler
implements AppLifecycleListener {
    protected static final Logger log = LogManager.getLogger((String)AppLifecycleHandler.class.getName());
    @Inject
    protected PostOffice postOffice;

    @Override
    public void onApplicationStart(String appVersion, String fullConfigInfo) {
        if (this.postOffice != null) {
            this.postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Started at " + OffsetDateTime.now(), fullConfigInfo, null, false);
        }
    }

    @Override
    public void onApplicationStop(String appVersion) {
        log.info(appVersion);
        if (this.postOffice != null) {
            this.postOffice.sendAlertSync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Shutdown at " + OffsetDateTime.now() + " - " + appVersion, "EOM", null, false);
        }
    }

    @Override
    public void onApplicationStatusUpdated(boolean healthOk, boolean paused, boolean serviceStatusChanged, String reason) {
        if (serviceStatusChanged) {
            boolean serviceAvaliable = healthOk && !paused;
            String content = "\n\t server status changed: paused=" + paused + ", OK=" + healthOk + ", serviceAvaliable=" + serviceAvaliable + "\n\t reason: " + reason;
            log.log(healthOk ? Level.WARN : Level.FATAL, content);
            if (this.postOffice != null) {
                this.postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Service Status Changed", content, null, false);
            }
        }
    }

    @Override
    public void onHealthInspectionFailed(int retryIndex, String reason, int nextInspectionIntervalSeconds) {
        if (this.postOffice != null) {
            this.postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Health Inspection Failed", reason, null, true);
        }
    }

    @Override
    public void onConfigChangeBefore(File configFile, JExpressConfig cfg) {
        if (this.postOffice != null) {
            this.postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Config Changed - before", cfg.info(), null, false);
        }
    }

    @Override
    public void onConfigChangedAfter(File configFile, JExpressConfig cfg, Throwable ex) {
        if (this.postOffice != null) {
            this.postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Config Changed - after", cfg.info(), ex, false);
        }
    }
}

