/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.util.ReflectionUtil;

public class ApplicationUtil {
    public static final String[] EMPTY_ARGS = new String[0];
    protected static final String JAVA_COMMAND_SUN = "sun.java.command";
    public static final String RESOURCE_PATH = "org/summerboot/jexpress/template/";

    public static String[] getApplicationArgs() {
        String commandLine = System.getProperty(JAVA_COMMAND_SUN);
        if (commandLine != null) {
            return StringUtils.chomp((String)commandLine).split(" ");
        }
        return EMPTY_ARGS;
    }

    public static boolean scanJVM_StartCommand(StringBuilder cmd) {
        String mainClassName;
        boolean jmxRequired = false;
        String OS = System.getProperty("os.name").toLowerCase();
        boolean isWindows = OS.contains("win");
        String java = System.getProperty("java.home") + "/bin/java";
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer vmArgsOneLine = new StringBuffer();
        for (String arg : vmArguments) {
            if (!arg.contains("-agentlib")) {
                vmArgsOneLine.append(arg);
                vmArgsOneLine.append(" ");
            }
            if (!arg.contains("com.sun.management.jmxremote.port")) continue;
            jmxRequired = true;
        }
        String vender = System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version");
        cmd.append("\nJVM = ").append(vender).append("\n");
        if (isWindows) {
            cmd.append("\"").append(java).append("\" ").append(vmArgsOneLine);
        } else {
            cmd.append(java).append(" ").append(vmArgsOneLine);
        }
        cmd.append("");
        String[] mainCommand = ApplicationUtil.getApplicationArgs();
        String string = mainClassName = mainCommand.length > 0 ? mainCommand[0] : "(unknown Main class)";
        if (mainClassName.endsWith(".jar")) {
            cmd.append("-jar ").append(new File(mainClassName).getAbsolutePath());
        } else {
            cmd.append("-cp \"").append(System.getProperty("java.class.path")).append("\" ").append(mainClassName);
        }
        for (int i = 1; i < mainCommand.length; ++i) {
            cmd.append(" ");
            cmd.append(mainCommand[i]);
        }
        return jmxRequired;
    }

    public static Map<Object, Set<String>> checkDuplicateFields(Class errorCodeClass, Class fieldClass) throws IllegalArgumentException, IllegalAccessException {
        HashMap<Object, Set<String>> duplicates = new HashMap<Object, Set<String>>();
        HashMap errorCodes = new HashMap();
        ReflectionUtil.loadFields(errorCodeClass, fieldClass, errorCodes, true);
        HashMap temp = new HashMap();
        errorCodes.keySet().forEach(varName -> {
            Object errorCode = errorCodes.get(varName);
            String duplicated = temp.put(errorCode, varName);
            if (duplicated != null) {
                HashSet<String> names = (HashSet<String>)duplicates.get(errorCode);
                if (names == null) {
                    names = new HashSet<String>();
                    duplicates.put(errorCode, names);
                }
                names.add((String)varName);
                names.add(duplicated);
            }
        });
        return duplicates;
    }

    public static String getServerName(boolean exitWhenFail) {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace(System.err);
            if (exitWhenFail) {
                System.exit(-1);
            }
            return null;
        }
    }

    public static Set<String> getClassNamesFromJarFile(File jarFile) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class")) continue;
            String className = entryName.replace(".class", "").replaceAll("/", ".");
            classNames.add(className);
        }
        return classNames;
    }

    public static Set<Class<?>> loadClassFromJarFile(File jarFile, boolean failOnUndefinedClasses) throws IOException {
        URL url = jarFile.getAbsoluteFile().toURI().toURL();
        URL[] urls = new URL[]{url};
        ClassLoader appClassLoader = ClassLoader.getSystemClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(urls, appClassLoader);
        HashSet classes = new HashSet();
        StringBuilder sb = new StringBuilder(jarFile.getAbsolutePath());
        boolean onError = false;
        Set<String> classNames = ApplicationUtil.getClassNamesFromJarFile(jarFile);
        for (String className : classNames) {
            try {
                Class<?> loadedClass = urlClassLoader.loadClass(className);
                classes.add(loadedClass);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex) {
                onError = true;
                sb.append("\n\t").append(ex.toString());
            }
        }
        if (onError && failOnUndefinedClasses) {
            throw new NoClassDefFoundError(sb.toString());
        }
        return classes;
    }

    public static Path createIfNotExist(String location, ClassLoader classLoader, String srcFileName, String destFileName) {
        Path targetFile = Paths.get(location, destFileName).toAbsolutePath();
        if (Files.exists(targetFile, new LinkOption[0])) {
            return targetFile;
        }
        try (InputStream ioStream = classLoader.getResourceAsStream(RESOURCE_PATH + srcFileName);){
            byte[] bytes = IOUtils.toByteArray((InputStream)ioStream);
            Files.write(targetFile, bytes, new OpenOption[0]);
        }
        catch (Throwable ex) {
            System.out.println(ex + "\n\tCould generate from " + srcFileName + " to " + targetFile);
            ex.printStackTrace();
            System.exit(1);
        }
        return targetFile;
    }
}

