/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.httpclient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.NamedDefaultThreadFactory;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.boot.instrumentation.HTTPClientStatusListener;
import org.summerboot.jexpress.integration.httpclient.RPCResult;
import org.summerboot.jexpress.nio.server.AbortPolicyWithReport;
import org.summerboot.jexpress.security.SSLUtil;

public abstract class HttpClientConfig
extends BootConfig {
    protected static final String FILENAME_KEYSTORE = "keystore.p12";
    protected static final String FILENAME_TRUSTSTORE_4CLIENT = "truststore_httpclient.p12";
    @ConfigHeader(title="1. HTTP Client Security")
    @Config(key="httpclient.ssl.protocol")
    protected volatile String protocol = "TLSv1.3";
    protected static final String KEY_kmf_key = "httpclient.ssl.KeyStore";
    protected static final String KEY_kmf_StorePwdKey = "httpclient.ssl.KeyStorePwd";
    protected static final String KEY_kmf_AliasKey = "httpclient.ssl.KeyAlias";
    protected static final String KEY_kmf_AliasPwdKey = "httpclient.ssl.KeyPwd";
    @JsonIgnore
    @Config(key="httpclient.ssl.KeyStore", StorePwdKey="httpclient.ssl.KeyStorePwd", AliasKey="httpclient.ssl.KeyAlias", AliasPwdKey="httpclient.ssl.KeyPwd", desc="Path to key store file. Use SSL/TLS when keystore is provided, otherwise use plain socket", callbackMethodName4Dump="generateTemplate_keystore")
    protected volatile KeyManagerFactory kmf;
    protected static final String KEY_tmf_key = "httpclient.ssl.TrustStore";
    protected static final String KEY_tmf_StorePwdKey = "httpclient.ssl.TrustStorePwd";
    @Config(key="httpclient.ssl.TrustStore", StorePwdKey="httpclient.ssl.TrustStorePwd", callbackMethodName4Dump="generateTemplate_truststore", desc="Path to trust store file. Auth the remote peer certificate when a truststore is provided, otherwise blindly trust all remote peer certificate")
    @JsonIgnore
    protected volatile TrustManagerFactory tmf;
    @Config(key="httpclient.ssl.HostnameVerification", defaultValue="true")
    protected volatile Boolean hostnameVerification = true;
    @Config(key="httpclient.proxy.host")
    protected volatile String proxyHost;
    @Config(key="httpclient.proxy.port")
    protected volatile int proxyPort = 8080;
    @Config(key="httpclient.proxy.userName")
    protected volatile String proxyUserName;
    @JsonIgnore
    @Config(key="httpclient.proxy.userPwd", validate=Config.Validate.Encrypted)
    protected volatile String proxyUserPwd;
    @JsonIgnore
    protected volatile String proxyAuthorizationBasicValue;
    @Config(key="httpclient.redirectOption")
    protected volatile HttpClient.Redirect redirectOption = HttpClient.Redirect.NEVER;
    @Config(key="httpclient.fromJson.CaseInsensitive")
    protected volatile boolean fromJsonCaseInsensitive = false;
    @Config(key="httpclient.fromJson.failOnUnknownProperties")
    protected volatile boolean fromJsonFailOnUnknownProperties = true;
    @ConfigHeader(title="2. HTTP Client Performance")
    @JsonIgnore
    protected volatile HttpClient httpClient;
    @JsonIgnore
    protected volatile HttpClient.Builder builder;
    @Config(key="httpclient.timeout.connect.ms", desc="The maximum time to wait for only the connection to be established, should be less than httpclient.timeout.ms")
    protected volatile long httpConnectTimeoutMs = 3000L;
    @Config(key="httpclient.timeout.ms", desc="The maximum time to wait from the beginning of the connection establishment until the server sends data back, this is the end-to-end timeout.")
    protected volatile long httpClientTimeoutMs = 5000L;
    @Config(key="httpclient.executor.CoreSize", predefinedValue="0", desc="CoreSize 0 = current computer/VM's available processors x 2 + 1")
    protected volatile int httpClientCoreSize = BootConstant.CPU_CORE * 2 + 1;
    @Config(key="httpclient.executor.MaxSize", predefinedValue="0", desc="MaxSize 0 = current computer/VM's available processors x 2 + 1")
    protected volatile int httpClientMaxSize = BootConstant.CPU_CORE * 2 + 1;
    @Config(key="httpclient.executor.QueueSize", defaultValue="2147483647", desc="The waiting list size when the pool is full")
    protected volatile int httpClientQueueSize = Integer.MAX_VALUE;
    @Config(key="httpclient.executor.KeepAliveSec", defaultValue="60")
    protected volatile int tpeKeepAliveSeconds = 60;
    @Config(key="httpclient.executor.prestartAllCoreThreads", defaultValue="false")
    protected boolean prestartAllCoreThreads = false;
    @Config(key="httpclient.executor.allowCoreThreadTimeOut", defaultValue="false")
    protected boolean allowCoreThreadTimeOut = false;
    protected ThreadPoolExecutor tpe;
    @JsonIgnore
    protected ScheduledExecutorService ses;
    protected static final String HEADER_CLIENT_REQUEST = "httpclient.DefaultReqHttpHeaders.";
    @ConfigHeader(title="3. HTTP Client Default Headers", desc="put generic HTTP Client request headers here", format="httpclient.DefaultReqHttpHeaders.<request_header_name>=<request_header_value>", example="httpclient.DefaultReqHttpHeaders.Accept=application/json\nhttpclient.DefaultReqHttpHeaders.Content-Type=application/json;charset=UTF-8\nhttpclient.DefaultReqHttpHeaders.Accept-Language=en-ca", callbackMethodName4Dump="generateTemplate_RequestHeaders")
    protected final Map<String, String> httpClientDefaultRequestHeaders = new HashMap<String, String>();
    protected HTTPClientStatusListener listener = null;

    public static void main(String[] args) {
        class A
        extends HttpClientConfig {
            A() {
            }
        }
        String t = HttpClientConfig.generateTemplate(A.class);
        System.out.println(t);
    }

    protected HttpClientConfig() {
    }

    @Override
    public void shutdown() {
        String tn = Thread.currentThread().getName();
        if (this.tpe != null && !this.tpe.isShutdown()) {
            System.out.println(tn + ": shutdown tpe: " + this.tpe);
            this.tpe.shutdown();
        } else {
            System.out.println(tn + ": already shutdown tpe: " + this.tpe);
        }
        if (this.ses != null && !this.ses.isShutdown()) {
            System.out.println(tn + ": shutdown ses: " + this.ses);
            this.ses.shutdown();
        }
    }

    protected void generateTemplate_keystore(StringBuilder sb) {
        sb.append("httpclient.ssl.KeyStore=keystore.p12\n");
        sb.append("httpclient.ssl.KeyStorePwd=DEC(changeit)\n");
        sb.append("httpclient.ssl.KeyAlias=server3_2048.jexpress.org\n");
        sb.append("httpclient.ssl.KeyPwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    protected void generateTemplate_truststore(StringBuilder sb) {
        sb.append("httpclient.ssl.TrustStore=truststore_httpclient.p12\n");
        sb.append("httpclient.ssl.TrustStorePwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    protected void generateTemplate_RequestHeaders(StringBuilder sb) {
        sb.append("#").append(HEADER_CLIENT_REQUEST).append("request_header_name=request_header_value\n");
    }

    public void setStatusListener(HTTPClientStatusListener l) {
        this.listener = l;
    }

    @Override
    protected void preLoad(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) {
        this.createIfNotExist(FILENAME_KEYSTORE, FILENAME_KEYSTORE);
        this.createIfNotExist("truststore.p12", FILENAME_TRUSTSTORE_4CLIENT);
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        String error2;
        Set _keys = props.keySet().stream().map(o -> o.toString()).collect(Collectors.toSet());
        ArrayList<String> keys = new ArrayList<String>(_keys);
        Collections.sort(keys);
        this.httpClientDefaultRequestHeaders.clear();
        keys.forEach(name -> {
            if (name.startsWith(HEADER_CLIENT_REQUEST)) {
                String[] names = name.split("\\.");
                String headerName = names[2];
                String headerValue = props.getProperty((String)name);
                this.httpClientDefaultRequestHeaders.put(headerName, headerValue);
            }
        });
        RPCResult.init(this.fromJsonFailOnUnknownProperties, this.fromJsonCaseInsensitive);
        KeyManager[] keyManagers = this.kmf == null ? null : this.kmf.getKeyManagers();
        TrustManager[] trustManagers = this.tmf == null ? SSLUtil.TRUST_ALL_CERTIFICATES : this.tmf.getTrustManagers();
        SSLContext sslContext = SSLUtil.buildSSLContext(keyManagers, trustManagers, this.protocol);
        if (this.hostnameVerification != null) {
            System.setProperty("jdk.internal.httpclient.disableHostnameVerification", this.hostnameVerification != false ? "false" : "true");
        }
        if (this.httpClientCoreSize <= 0) {
            this.httpClientCoreSize = BootConstant.CPU_CORE * 2 + 1;
        }
        if (this.httpClientMaxSize <= 0) {
            this.httpClientMaxSize = BootConstant.CPU_CORE * 2 + 1;
        }
        if (this.httpClientMaxSize < this.httpClientCoreSize) {
            helper.addError("MaxSize should not less than CoreSize");
        }
        if ((error2 = helper.getError()) != null) {
            throw new IllegalArgumentException(error2);
        }
        if (!isReal) {
            return;
        }
        ThreadPoolExecutor old = this.tpe;
        int currentTpeHashCode = old == null ? -1 : old.hashCode();
        this.tpe = HttpClientConfig.buildThreadPoolExecutor(old, "HttpClient", BootConfig.ThreadingMode.Mixed, this.httpClientCoreSize, this.httpClientMaxSize, this.httpClientQueueSize, this.tpeKeepAliveSeconds, new AbortPolicyWithReport("HttpClientExecutor"), this.prestartAllCoreThreads, this.allowCoreThreadTimeOut, false);
        boolean isHttpClientSettingsChanged = this.tpe.hashCode() != currentTpeHashCode;
        ScheduledExecutorService sesold = this.ses;
        this.builder = HttpClient.newBuilder().executor(this.tpe).version(HttpClient.Version.HTTP_2).followRedirects(this.redirectOption).connectTimeout(Duration.ofMillis(this.httpConnectTimeoutMs));
        if (sslContext != null) {
            this.builder.sslContext(sslContext);
        }
        if (StringUtils.isNotBlank((CharSequence)this.proxyHost)) {
            this.builder.proxy(ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.proxyUserName)) {
            if (this.proxyUserPwd == null) {
                this.proxyUserPwd = "";
            }
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            String plain = this.proxyUserName + ":" + this.proxyUserPwd;
            String encoded = new String(Base64.getEncoder().encode(plain.getBytes()));
            this.proxyAuthorizationBasicValue = "Basic " + encoded;
        }
        this.httpClient = this.builder.build();
        this.ses = Executors.newSingleThreadScheduledExecutor(new NamedDefaultThreadFactory("HttpClient.QPS_SERVICE"));
        this.ses.scheduleAtFixedRate(() -> {
            int queue = this.tpe.getQueue().size();
            int active = this.tpe.getActiveCount();
            if (active > 0 || queue > 0) {
                long task = this.tpe.getTaskCount();
                long completed = this.tpe.getCompletedTaskCount();
                long pool = this.tpe.getPoolSize();
                int core = this.tpe.getCorePoolSize();
                long max = this.tpe.getMaximumPoolSize();
                long largest = this.tpe.getLargestPoolSize();
                if (this.listener != null) {
                    this.listener.onHTTPClientAccessReportUpdate(task, completed, queue, active, pool, core, max, largest);
                }
                this.logger.info(() -> "HTTPClient task=" + task + ", completed=" + completed + ", queue=" + queue + ", active=" + active + ", pool=" + pool + ", core=" + core + ", max=" + max + ", largest=" + largest);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        if (old != null && isHttpClientSettingsChanged) {
            old.shutdown();
        }
        if (sesold != null) {
            sesold.shutdown();
        }
        System.gc();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpClient.Builder getBuilder() {
        return this.builder;
    }

    public HttpClient updateBuilder(HttpClient.Builder builder) {
        this.builder = builder;
        this.httpClient = builder.build();
        return this.httpClient;
    }

    public Map<String, String> getHttpClientDefaultRequestHeaders() {
        return this.httpClientDefaultRequestHeaders;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Boolean isHostnameVerificationEnabled() {
        return this.hostnameVerification;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyUserPwd() {
        return this.proxyUserPwd;
    }

    public String getProxyAuthorizationBasicValue() {
        return this.proxyAuthorizationBasicValue;
    }

    public boolean isFromJsonCaseInsensitive() {
        return this.fromJsonCaseInsensitive;
    }

    public boolean isFromJsonFailOnUnknownProperties() {
        return this.fromJsonFailOnUnknownProperties;
    }

    public long getHttpConnectTimeoutMs() {
        return this.httpConnectTimeoutMs;
    }

    public long getHttpClientTimeoutMs() {
        return this.httpClientTimeoutMs;
    }

    public int getHttpClientCoreSize() {
        return this.httpClientCoreSize;
    }

    public int getHttpClientMaxSize() {
        return this.httpClientMaxSize;
    }

    public int getHttpClientQueueSize() {
        return this.httpClientQueueSize;
    }

    public String getHttpClientInfo() {
        return String.valueOf(this.httpClient);
    }

    public String getTpeInfo() {
        return String.valueOf(this.tpe);
    }
}

