/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.event.HttpLifecycleListener;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.nio.server.NioCounter;
import org.summerboot.jexpress.nio.server.NioHttpUtil;

@ChannelHandler.Sharable
@Singleton
public class BootHttpPingHandler
extends SimpleChannelInboundHandler<HttpObject> {
    protected static Logger log = LogManager.getLogger((String)BootHttpPingHandler.class.getName());
    protected final List<String> pingURLs = BackOffice.agent.getLoadBalancingPingEndpoints();
    protected final boolean hasPingURL = this.pingURLs != null && !this.pingURLs.isEmpty();
    @Inject
    protected HttpLifecycleListener httpLifecycleListener;

    public BootHttpPingHandler() {
        super(FullHttpRequest.class, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject httpObject) throws Exception {
        HttpRequest req;
        boolean isPingRequest = false;
        if (this.hasPingURL && httpObject instanceof HttpRequest && HttpMethod.GET.equals((Object)(req = (HttpRequest)httpObject).method()) && this.pingURLs.contains(req.uri())) {
            isPingRequest = true;
            long hit = NioCounter.COUNTER_PING_HIT.incrementAndGet();
            try {
                HttpResponseStatus status = HealthMonitor.isServiceAvaliable() ? HttpResponseStatus.OK : HttpResponseStatus.SERVICE_UNAVAILABLE;
                boolean isContinue = this.httpLifecycleListener.beforeProcessPingRequest(ctx, req.uri(), hit, status);
                if (isContinue) {
                    NioHttpUtil.sendText(ctx, HttpUtil.isKeepAlive((HttpMessage)req), null, status, null, null, null, true, null);
                    this.httpLifecycleListener.afterSendPingResponse(ctx, req.uri(), hit, status);
                }
            }
            finally {
                ReferenceCountUtil.release((Object)req);
            }
        }
        if (!isPingRequest) {
            ctx.fireChannelRead((Object)httpObject);
        }
    }
}

