/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.util.ReflectionUtil;

public class BackOffice
extends BootConfig {
    public static final BackOffice agent = new BackOffice();
    protected ThreadPoolExecutor tpe;
    private List<String> loadBalancingPingEndpoints;
    private String version;
    private String versionShort;
    @ConfigHeader(title="1. Override default error codes with application defined ones", desc="To verify: java -jar <app>.jar -list SystemErrorCode [-dmain <domain>]", format="CSV of <default error code>:<new error code>", example="1:1001, 20:1020, 40:1040, 50:1050", callbackMethodName4Dump="generateTemplate_keystore")
    @Config(key="errorcode.override")
    private volatile Map<Integer, Integer> bootErrorCodeMapping;
    @ConfigHeader(title="2. Application Packages", desc="Only for those applications which have more than one root package names", format="CSV of string", example="com.package1, com.package2")
    @Config(key="rootpackage.names")
    private Set<String> rootPackageNames;
    @ConfigHeader(title="3. Default Settings")
    @Config(key="log.traceWithSystemOut", defaultValue="false", desc="enable trace with system out before logger enabled")
    private boolean traceWithSystemOut = false;
    @Config(key="type.errorCodeAsInt", defaultValue="false")
    private boolean errorCodeAsInt = false;
    @Config(key="default.interval.ConfigChangeMonitor", defaultValue="30")
    private int CfgChangeMonitorIntervalSec = 30;
    @Config(key="default.web.resource.ttl.sec", defaultValue="3600")
    private long webResourceCacheTtlSec = 3600L;
    @Config(key="reflection.package.level", defaultValue="2")
    private int reflectionPackageLevel = 2;
    @Config(key="timeout.alert.milliseconds", defaultValue="10000")
    private long processTimeoutMilliseconds = 10000L;
    private static final String ALERT_MSG_TIMEOUT = "Note: This is a known issue in Linux systems where the/dev/random runs out of \"entropy\" and it causes the system to blockthreads. \n\tTo verify: cat /dev/random or install rng-tools and/or haveged.\n\tOr add a JVM argument to the runner: -Djava.security.egd=file:/dev/./urandom";
    @Config(key="timeout.alert.message", defaultValue="Note: This is a known issue in Linux systems where the/dev/random runs out of \"entropy\" and it causes the system to blockthreads. \n\tTo verify: cat /dev/random or install rng-tools and/or haveged.\n\tOr add a JVM argument to the runner: -Djava.security.egd=file:/dev/./urandom")
    private String processTimeoutAlertMessage = "Note: This is a known issue in Linux systems where the/dev/random runs out of \"entropy\" and it causes the system to blockthreads. \n\tTo verify: cat /dev/random or install rng-tools and/or haveged.\n\tOr add a JVM argument to the runner: -Djava.security.egd=file:/dev/./urandom";
    private static final String ALERT_MSG_PORT_IN_USE = "In order to check which application is listening on a port, you can use the following command from the command line:\n\nFor Microsoft Windows:\n    netstat -ano | find \"80\" | find \"LISTEN\"\n    tasklist /fi \"PID eq <pid>\"\n     \nFor Linux:\n    netstat -anpe | grep \"80\" | grep \"LISTEN\" \n";
    @Config(key="portinuse.alert.message", defaultValue="In order to check which application is listening on a port, you can use the following command from the command line:\n\nFor Microsoft Windows:\n    netstat -ano | find \"80\" | find \"LISTEN\"\n    tasklist /fi \"PID eq <pid>\"\n     \nFor Linux:\n    netstat -anpe | grep \"80\" | grep \"LISTEN\" \n")
    private String portInUseAlertMessage = "In order to check which application is listening on a port, you can use the following command from the command line:\n\nFor Microsoft Windows:\n    netstat -ano | find \"80\" | find \"LISTEN\"\n    tasklist /fi \"PID eq <pid>\"\n     \nFor Linux:\n    netstat -anpe | grep \"80\" | grep \"LISTEN\" \n";
    @Config(key="backoffice.executor.core", defaultValue="3", desc="MaxSize 0 = current computer/VM's available processors + 1")
    private int tpeCore = 3;
    @Config(key="backoffice.executor.max", defaultValue="2147483647", desc="MaxSize 0 = current computer/VM's available processors + 1")
    private int tpeMax = Integer.MAX_VALUE;
    @Config(key="backoffice.executor.queue", defaultValue="0")
    private int tpeQueue = 0;
    @Config(key="backoffice.executor.keepAliveTimeSec", defaultValue="60")
    private int tpeKeepAliveSeconds = 60;
    @Config(key="backoffice.executor.prestartAllCoreThreads", defaultValue="false")
    private boolean prestartAllCoreThreads = false;
    @Config(key="backoffice.executor.allowCoreThreadTimeOut", defaultValue="false")
    private boolean allowCoreThreadTimeOut = false;
    @Config(key="backoffice.jsonParser.TimeZone", desc="The ID for a TimeZone, either an abbreviation such as \"PST\", a full name such as \"America/Los_Angeles\", or a custom ID such as \"GMT-8:00\", or \"default\" as system default timezone.", defaultValue="UTC")
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @ConfigHeader(title="4.1 Default Path/File Naming")
    @Config(key="naming.folder.domainPrefix", defaultValue="standalone")
    private String domainFolderPrefix = "standalone";
    @Config(key="naming.folder.config", defaultValue="configuration")
    private String configFolderName = "configuration";
    @Config(key="naming.folder.log", defaultValue="log")
    private String logFolderName = "log";
    @Config(key="naming.folder.plugin", defaultValue="plugin")
    private String pluginFolderName = "plugin";
    @Config(key="naming.file.AuthConfig", defaultValue="cfg_auth.properties")
    private String authConfigFileName = "cfg_auth.properties";
    @Config(key="naming.file.SMTPConfig", defaultValue="cfg_smtp.properties")
    private String smtpConfigFileName = "cfg_smtp.properties";
    @Config(key="naming.file.NIOConfig", defaultValue="cfg_nio.properties")
    private String nioConfigFileName = "cfg_nio.properties";
    @Config(key="naming.file.gRPCConfig", defaultValue="cfg_grpc.properties")
    private String gRPCConfigFileName = "cfg_grpc.properties";
    @ConfigHeader(title="4.2 Default Log4j2.xml Variables Naming")
    @Config(key="naming.log4j2.xml.var.logId", defaultValue="logId")
    private String log4j2LogId = "logId";
    @Config(key="naming.log4j2.xml.var.logPath", defaultValue="logPath")
    private String log4j2LogFilePath = "logPath";
    @Config(key="naming.log4j2.xml.var.appName", defaultValue="appName")
    private String log4j2LogFileName = "appName";
    @Config(key="naming.log4j2.xml.var.serverName", defaultValue="serverName")
    private String log4j2ServerName = "serverName";
    @Config(key="naming.log4j2.xml.var.appPackageName", defaultValue="appPackageName")
    private String log4j2AppPackageName = "appPackageName";
    @ConfigHeader(title="4.3 Default CLI Naming")
    @Config(key="naming.cli.usage", defaultValue="?")
    private String cliName_usage = "?";
    @Config(key="naming.cli.version", defaultValue="version")
    private String cliName_version = "version";
    @Config(key="naming.cli.domain", defaultValue="domain")
    private String cliName_domain = "domain";
    @Config(key="naming.cli.cfgdir", defaultValue="cfgdir")
    private String cliName_cfgdir = "cfgdir";
    @Config(key="naming.cli.monitorInterval", defaultValue="monitorInterval")
    private String cliName_monitorInterval = "monitorInterval";
    @Config(key="naming.cli.i18n", defaultValue="i18n")
    private String cliName_i18n = "i18n";
    @Config(key="naming.cli.use", defaultValue="use")
    private String cliName_use = "use";
    @Config(key="naming.cli.cfgdemo", defaultValue="cfgdemo")
    private String cliName_cfgdemo = "cfgdemo";
    @Config(key="naming.cli.list", defaultValue="list")
    private String cliName_list = "list";
    @Config(key="naming.cli.authfile", defaultValue="authfile")
    private String cliName_authfile = "authfile";
    @Config(key="naming.cli.auth", defaultValue="auth")
    private String cliName_auth = "auth";
    @Config(key="naming.cli.jwt", defaultValue="jwt")
    private String cliName_jwt = "jwt";
    @Config(key="naming.cli.encrypt", defaultValue="encrypt")
    private String cliName_encrypt = "encrypt";
    @Config(key="naming.cli.decrypt", defaultValue="decrypt")
    private String cliName_decrypt = "decrypt";
    @Config(key="naming.memo.delimiter", defaultValue=": ")
    private String memoDelimiter = ": ";

    public static void main(String[] args) {
        String t = BackOffice.generateTemplate(BackOffice.class);
        System.out.println(t);
    }

    protected BackOffice() {
        this.loadBalancingPingEndpoints = new ArrayList<String>();
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        if (this.tpeCore < 1) {
            this.tpeCore = CPU_CORE + 1;
        }
        if (this.tpeMax < 1) {
            this.tpeMax = CPU_CORE + 1;
        }
        this.tpe = BackOffice.buildThreadPoolExecutor(this.tpe, "BackOffice", BootConfig.ThreadingMode.Mixed, this.tpeCore, this.tpeMax, this.tpeQueue, this.tpeKeepAliveSeconds, new ThreadPoolExecutor.DiscardPolicy(), this.prestartAllCoreThreads, this.allowCoreThreadTimeOut, false);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.tpe.shutdown(), "ShutdownHook.BackOffice"));
    }

    @Override
    public void shutdown() {
    }

    public static void execute(Runnable task) {
        if (BackOffice.agent.tpe == null || BackOffice.agent.tpe.isShutdown()) {
            throw new IllegalStateException("BackOffice.tpe is down:" + BackOffice.agent.tpe);
        }
        BackOffice.agent.tpe.execute(task);
    }

    public List<String> getLoadBalancingPingEndpoints() {
        return this.loadBalancingPingEndpoints;
    }

    public void addLoadBalancingPingEndpoint(String loadBalancingPingEndpoint) {
        this.loadBalancingPingEndpoints.add(loadBalancingPingEndpoint);
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    public String getVersionShort() {
        return this.versionShort;
    }

    void setVersionShort(String versionShort) {
        this.versionShort = versionShort;
    }

    void setRootPackageNames(Set<String> rootPackageNames) {
        this.rootPackageNames = Set.copyOf(rootPackageNames);
    }

    private static String listBootErrorCode() {
        String ret = "";
        try {
            HashMap results = new HashMap();
            ReflectionUtil.loadFields(BootErrorCode.class, Integer.TYPE, results, false);
            Map sorted = results.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (e1, e2) -> e1, LinkedHashMap::new));
            StringBuilder sb = new StringBuilder().append("## Default Error Codes:").append(BR);
            sorted.forEach((key, value) -> sb.append("## ").append(key).append(": ").append((String)value).append(BR));
            ret = sb.toString();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    protected void generateTemplate_keystore(StringBuilder sb) {
        sb.append(BackOffice.listBootErrorCode()).append(System.lineSeparator());
    }

    public Map<Integer, Integer> getBootErrorCodeMapping() {
        return this.bootErrorCodeMapping;
    }

    public Set<String> getRootPackageNames() {
        return this.rootPackageNames;
    }

    public boolean isTraceWithSystemOut() {
        return this.traceWithSystemOut;
    }

    public boolean isErrorCodeAsInt() {
        return this.errorCodeAsInt;
    }

    public int getCfgChangeMonitorIntervalSec() {
        return this.CfgChangeMonitorIntervalSec;
    }

    public long getWebResourceCacheTtlSec() {
        return this.webResourceCacheTtlSec;
    }

    public int getReflectionPackageLevel() {
        return this.reflectionPackageLevel;
    }

    public long getProcessTimeoutMilliseconds() {
        return this.processTimeoutMilliseconds;
    }

    public String getProcessTimeoutAlertMessage() {
        return this.processTimeoutAlertMessage;
    }

    public String getPortInUseAlertMessage() {
        return this.portInUseAlertMessage;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getDomainFolderPrefix() {
        return this.domainFolderPrefix;
    }

    public String getConfigFolderName() {
        return this.configFolderName;
    }

    public String getLogFolderName() {
        return this.logFolderName;
    }

    public String getPluginFolderName() {
        return this.pluginFolderName;
    }

    public String getAuthConfigFileName() {
        return this.authConfigFileName;
    }

    public String getSmtpConfigFileName() {
        return this.smtpConfigFileName;
    }

    public String getNioConfigFileName() {
        return this.nioConfigFileName;
    }

    public String getgRPCConfigFileName() {
        return this.gRPCConfigFileName;
    }

    public String getLog4J2LogId() {
        return this.log4j2LogId;
    }

    public String getLog4j2LogFilePath() {
        return this.log4j2LogFilePath;
    }

    public String getLog4j2LogFileName() {
        return this.log4j2LogFileName;
    }

    public String getLog4j2ServerName() {
        return this.log4j2ServerName;
    }

    public String getLog4j2AppPackageName() {
        return this.log4j2AppPackageName;
    }

    public String getCliName_usage() {
        return this.cliName_usage;
    }

    public String getCliName_version() {
        return this.cliName_version;
    }

    public String getCliName_domain() {
        return this.cliName_domain;
    }

    public String getCliName_cfgdir() {
        return this.cliName_cfgdir;
    }

    public String getCliName_monitorInterval() {
        return this.cliName_monitorInterval;
    }

    public String getCliName_i18n() {
        return this.cliName_i18n;
    }

    public String getCliName_use() {
        return this.cliName_use;
    }

    public String getCliName_cfgdemo() {
        return this.cliName_cfgdemo;
    }

    public String getCliName_list() {
        return this.cliName_list;
    }

    public String getCliName_authfile() {
        return this.cliName_authfile;
    }

    public String getCliName_auth() {
        return this.cliName_auth;
    }

    public String getCliName_jwt() {
        return this.cliName_jwt;
    }

    public String getCliName_encrypt() {
        return this.cliName_encrypt;
    }

    public String getCliName_decrypt() {
        return this.cliName_decrypt;
    }

    public String getMemoDelimiter() {
        return this.memoDelimiter;
    }
}

