/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.config;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;

public class ConfigurationMonitor
implements FileAlterationListener {
    protected static final Logger log = LogManager.getLogger((String)ConfigurationMonitor.class.getName());
    public static final ConfigurationMonitor cfgMonitor = new ConfigurationMonitor();
    public static final String APUSE_FILE_NAME = "pause";
    protected volatile boolean running;
    protected Map<File, Runnable> cfgUpdateTasks;
    protected FileAlterationMonitor monitor;

    protected ConfigurationMonitor() {
    }

    public void start(File folder, int intervalSec, Map<File, Runnable> cfgUpdateTasks) throws Exception {
        File pauseFile = Paths.get(folder.getAbsolutePath(), APUSE_FILE_NAME).toFile();
        HealthMonitor.setPauseStatus(pauseFile.exists(), "by file detection " + pauseFile.getAbsolutePath());
        if (this.running) {
            return;
        }
        this.running = true;
        this.cfgUpdateTasks = cfgUpdateTasks;
        this.monitor = new FileAlterationMonitor(TimeUnit.SECONDS.toMillis(intervalSec));
        for (File listenFile : cfgUpdateTasks.keySet()) {
            FileFilter filter = pathname -> listenFile.getAbsolutePath().equals(pathname.getAbsolutePath());
            FileAlterationObserver observer = new FileAlterationObserver(folder, filter);
            observer.addListener((FileAlterationListener)cfgMonitor);
            this.monitor.addObserver(observer);
        }
        FileFilter filter = pathname -> pauseFile.getAbsolutePath().equals(pathname.getAbsolutePath());
        FileAlterationObserver observer = new FileAlterationObserver(folder, filter);
        observer.addListener((FileAlterationListener)cfgMonitor);
        this.monitor.addObserver(observer);
        this.monitor.start();
    }

    public void start() throws Exception {
        if (this.monitor != null) {
            this.monitor.start();
        }
    }

    public void stop() throws Exception {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    public void onStart(FileAlterationObserver fao) {
    }

    public void onStop(FileAlterationObserver fao) {
    }

    public void onDirectoryCreate(File file) {
        log.info(() -> "dir.new " + file.getAbsoluteFile());
    }

    public void onDirectoryChange(File file) {
        log.info(() -> "dir.mod " + file.getAbsoluteFile());
    }

    public void onDirectoryDelete(File file) {
        log.info(() -> "dir.del " + file.getAbsoluteFile());
    }

    public void onFileCreate(File file) {
        log.info(() -> "new " + file.getAbsoluteFile());
        HealthMonitor.setPauseStatus(true, "file created " + file.getAbsolutePath());
    }

    public void onFileChange(File file) {
        log.info(() -> "mod " + file.getAbsoluteFile());
        Runnable task = this.cfgUpdateTasks.get(file.getAbsoluteFile());
        if (task != null) {
            task.run();
        }
    }

    public void onFileDelete(File file) {
        log.info(() -> "del " + file.getAbsoluteFile());
        HealthMonitor.setPauseStatus(false, "file deleted " + file.getAbsolutePath());
    }
}

