/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BootLoadBalancerProvider
extends NameResolverProvider {
    protected final List<EquivalentAddressGroup> servers;
    protected final String scheme;
    protected final String authority;

    public BootLoadBalancerProvider(String scheme, InetSocketAddress ... addresses) {
        this.scheme = scheme;
        this.authority = addresses != null && addresses.length > 0 ? addresses[0].getHostName() : "unknownhost";
        this.servers = Arrays.stream(addresses).map(EquivalentAddressGroup::new).collect(Collectors.toList());
    }

    public BootLoadBalancerProvider(String scheme, List<? extends InetSocketAddress> addresses) {
        this.scheme = scheme;
        this.authority = addresses != null && !addresses.isEmpty() ? addresses.get(0).getHostName() : "unknownhost";
        this.servers = addresses.stream().map(EquivalentAddressGroup::new).collect(Collectors.toList());
    }

    public NameResolver newNameResolver(URI notUsedTargetUri, NameResolver.Args args) {
        return new NameResolver(){

            public String getServiceAuthority() {
                return BootLoadBalancerProvider.this.authority;
            }

            public void start(NameResolver.Listener2 listener) {
                listener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(BootLoadBalancerProvider.this.servers).setAttributes(Attributes.EMPTY).build());
            }

            public void shutdown() {
            }
        };
    }

    public String getDefaultScheme() {
        return this.scheme;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 0;
    }
}

