/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.multipart;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.util.internal.StringUtil;
import org.summerboot.jexpress.nio.server.multipart.HttpPostBodyUtil;

public class MultipartUtil {
    public static boolean isMultipart(HttpRequest request) {
        String mimeType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (mimeType != null && mimeType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString())) {
            return MultipartUtil.getMultipartDataBoundary(mimeType) != null;
        }
        return false;
    }

    protected static String[] getMultipartDataBoundary(String contentType) {
        String multiPartHeader;
        String[] headerContentType = MultipartUtil.splitHeaderContentType(contentType);
        if (headerContentType[0].regionMatches(true, 0, multiPartHeader = HttpHeaderValues.MULTIPART_FORM_DATA.toString(), 0, multiPartHeader.length())) {
            String charset;
            String charsetHeader;
            int index;
            String bound;
            int crank;
            int mrank;
            String boundaryHeader = HttpHeaderValues.BOUNDARY.toString();
            if (headerContentType[1].regionMatches(true, 0, boundaryHeader, 0, boundaryHeader.length())) {
                mrank = 1;
                crank = 2;
            } else if (headerContentType[2].regionMatches(true, 0, boundaryHeader, 0, boundaryHeader.length())) {
                mrank = 2;
                crank = 1;
            } else {
                return null;
            }
            String boundary = StringUtil.substringAfter((String)headerContentType[mrank], (char)'=');
            if (boundary == null) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Needs a boundary value");
            }
            if (boundary.charAt(0) == '\"' && (bound = boundary.trim()).charAt(index = bound.length() - 1) == '\"') {
                boundary = bound.substring(1, index);
            }
            if (headerContentType[crank].regionMatches(true, 0, charsetHeader = HttpHeaderValues.CHARSET.toString(), 0, charsetHeader.length()) && (charset = StringUtil.substringAfter((String)headerContentType[crank], (char)'=')) != null) {
                return new String[]{"--" + boundary, charset};
            }
            return new String[]{"--" + boundary};
        }
        return null;
    }

    protected static String[] splitHeaderContentType(String sb) {
        int bEnd;
        int aStart = HttpPostBodyUtil.findNonWhitespace(sb, 0);
        int aEnd = sb.indexOf(59);
        if (aEnd == -1) {
            return new String[]{sb, "", ""};
        }
        int bStart = HttpPostBodyUtil.findNonWhitespace(sb, aEnd + 1);
        if (sb.charAt(aEnd - 1) == ' ') {
            --aEnd;
        }
        if ((bEnd = sb.indexOf(59, bStart)) == -1) {
            bEnd = HttpPostBodyUtil.findEndOfString(sb);
            return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), ""};
        }
        int cStart = HttpPostBodyUtil.findNonWhitespace(sb, bEnd + 1);
        if (sb.charAt(bEnd - 1) == ' ') {
            --bEnd;
        }
        int cEnd = HttpPostBodyUtil.findEndOfString(sb);
        return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), sb.substring(cStart, cEnd)};
    }
}

