/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import io.grpc.ServerInterceptor;
import io.netty.channel.ChannelHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Scheduler;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.event.AppLifecycleHandler;
import org.summerboot.jexpress.boot.event.AppLifecycleListener;
import org.summerboot.jexpress.boot.event.HttpExceptionHandler;
import org.summerboot.jexpress.boot.event.HttpExceptionListener;
import org.summerboot.jexpress.boot.event.HttpLifecycleHandler;
import org.summerboot.jexpress.boot.event.HttpLifecycleListener;
import org.summerboot.jexpress.boot.instrumentation.BootHealthInspectorImpl;
import org.summerboot.jexpress.boot.instrumentation.HTTPClientStatusListener;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgrImpl;
import org.summerboot.jexpress.boot.instrumentation.jmx.ServerStatus;
import org.summerboot.jexpress.boot.instrumentation.jmx.ServerStatusMBean;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.integration.cache.AuthTokenCacheLocalImpl;
import org.summerboot.jexpress.integration.quartz.GuiceSchedulerProvider;
import org.summerboot.jexpress.integration.smtp.BootPostOfficeImpl;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.nio.server.BootHttpPingHandler;
import org.summerboot.jexpress.nio.server.BootHttpRequestHandler;
import org.summerboot.jexpress.nio.server.HttpNioChannelInitializer;
import org.summerboot.jexpress.nio.server.NioChannelInitializer;
import org.summerboot.jexpress.security.auth.Authenticator;
import org.summerboot.jexpress.security.auth.LDAPAuthenticator;
import org.summerboot.jexpress.util.ReflectionUtil;

public class BootGuiceModule
extends AbstractModule {
    protected static final String BIND_TO = " --> ";
    protected static final String INFO = BootConstant.BR + "\t- Ioc.default.binding: ";
    protected final Object caller;
    protected final Class callerClass;
    protected final String callerRootPackageName;
    protected final Set<String> userSpecifiedImplTags;
    protected final StringBuilder memo;

    public BootGuiceModule(Object caller, Class callerClass, Set<String> userSpecifiedImplTags, StringBuilder memo) {
        this.caller = caller;
        this.callerClass = callerClass == null ? caller.getClass() : callerClass;
        this.callerRootPackageName = ReflectionUtil.getRootPackageName(this.callerClass, BootConstant.PACKAGE_LEVEL);
        this.userSpecifiedImplTags = userSpecifiedImplTags;
        this.memo = memo;
    }

    protected boolean isCliUseImplTag(String implTag) {
        return this.userSpecifiedImplTags != null && this.userSpecifiedImplTags.contains(implTag);
    }

    public void configure() {
        this.bind(NIOStatusListener.class).to(ServerStatus.class);
        this.memo.append(INFO).append(NIOStatusListener.class.getName()).append(BIND_TO).append(ServerStatus.class.getName());
        this.bind(HTTPClientStatusListener.class).to(ServerStatus.class);
        this.memo.append(INFO).append(HTTPClientStatusListener.class.getName()).append(BIND_TO).append(ServerStatus.class.getName());
        this.bind(ServerStatusMBean.class).to(ServerStatus.class);
        this.memo.append(INFO).append(ServerStatusMBean.class.getName()).append(BIND_TO).append(ServerStatus.class.getName());
        this.bind(InstrumentationMgr.class).to(InstrumentationMgrImpl.class);
        this.memo.append(INFO).append(InstrumentationMgr.class.getName()).append(BIND_TO).append(InstrumentationMgrImpl.class.getName());
        this.bind(NioChannelInitializer.class).to(HttpNioChannelInitializer.class);
        this.bind(ChannelHandler.class).annotatedWith((Annotation)Names.named((String)BootHttpPingHandler.class.getSimpleName())).to(BootHttpPingHandler.class);
        this.memo.append(INFO).append(ChannelHandler.class.getName()).append(BIND_TO).append(BootHttpPingHandler.class.getSimpleName()).append(", named=").append(BootHttpPingHandler.class.getSimpleName());
        this.bind(HealthInspector.class).to(BootHealthInspectorImpl.class);
        this.memo.append(INFO).append(HealthInspector.class.getName()).append(BIND_TO).append(BootHealthInspectorImpl.class.getName());
        this.bind(AuthTokenCache.class).to(AuthTokenCacheLocalImpl.class);
        this.memo.append(INFO).append(AuthTokenCache.class.getName()).append(BIND_TO).append(AuthTokenCacheLocalImpl.class.getName());
        this.bind(Authenticator.class).to(LDAPAuthenticator.class);
        this.memo.append(INFO).append(Authenticator.class.getName()).append(BIND_TO).append(LDAPAuthenticator.class.getName());
        this.bind(ServerInterceptor.class).to(LDAPAuthenticator.class);
        this.memo.append(INFO).append(ServerInterceptor.class.getName()).append(BIND_TO).append(LDAPAuthenticator.class.getName());
        this.bind(HttpExceptionListener.class).to(HttpExceptionHandler.class);
        this.memo.append(INFO).append(HttpExceptionListener.class.getName()).append(BIND_TO).append(HttpExceptionHandler.class.getName());
        this.bind(HttpLifecycleListener.class).to(HttpLifecycleHandler.class);
        this.memo.append(INFO).append(HttpLifecycleListener.class.getName()).append(BIND_TO).append(HttpLifecycleHandler.class.getName());
        this.bind(AppLifecycleListener.class).to(AppLifecycleHandler.class);
        this.memo.append(INFO).append(AppLifecycleListener.class.getName()).append(BIND_TO).append(AppLifecycleHandler.class.getName());
        this.bind(PostOffice.class).to(BootPostOfficeImpl.class);
        this.memo.append(INFO).append(PostOffice.class.getName()).append(BIND_TO).append(BootPostOfficeImpl.class.getName());
        this.bind(ChannelHandler.class).annotatedWith((Annotation)Names.named((String)BootHttpRequestHandler.class.getSimpleName())).to(BootHttpRequestHandler.class);
        this.memo.append(INFO).append(ChannelHandler.class.getName()).append(BIND_TO).append(BootHttpRequestHandler.class.getSimpleName()).append(", named=").append(BootHttpRequestHandler.class.getSimpleName());
        this.scanAnnotation_BindInstance(this.binder(), Controller.class, this.callerRootPackageName);
        if (this.caller != null) {
            this.requestInjection(this.caller);
            this.memo.append(INFO).append(this.caller);
        }
        this.bind(Scheduler.class).toProvider(GuiceSchedulerProvider.class).asEagerSingleton();
    }

    protected void scanAnnotation_BindInstance(Binder binder, Class<? extends Annotation> annotation, String ... rootPackageNames) {
        MapBinder mapbinder = MapBinder.newMapBinder((Binder)binder, String.class, Object.class, annotation);
        HashSet classesAll = new HashSet();
        Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(annotation, false, rootPackageNames);
        for (Class<?> c2 : classes) {
            int mod;
            Controller a = (Controller)c2.getAnnotation(annotation);
            String implTag = a.implTag();
            if (StringUtils.isNotBlank((CharSequence)implTag) && !this.isCliUseImplTag(implTag) || Modifier.isAbstract(mod = c2.getModifiers()) || Modifier.isInterface(mod)) continue;
            classesAll.add(c2);
        }
        classesAll.forEach(c -> mapbinder.addBinding((Object)c.getName()).to(c));
    }
}

