/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.quartz;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.summerboot.jexpress.integration.quartz.BootJobListener;
import org.summerboot.jexpress.integration.quartz.GuiceJobFactory;

public class GuiceSchedulerProvider
implements Provider<Scheduler> {
    @Inject
    protected Injector injector;

    public Scheduler get() {
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            Scheduler scheduler = factory.getScheduler();
            scheduler.setJobFactory((JobFactory)new GuiceJobFactory(this.injector));
            scheduler.getListenerManager().addJobListener((JobListener)new BootJobListener());
            return scheduler;
        }
        catch (SchedulerException ex) {
            throw new RuntimeException("Failed to provide a Scheduler", ex);
        }
    }
}

