/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.ManagedChannel;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.annotation.Nullable;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public abstract class GRPCClient<T extends GRPCClient<T>> {
    protected static final List<NameResolverProvider> NR_Providers = new ArrayList<NameResolverProvider>();
    protected final NameResolverProvider nameResolverProvider;
    protected final URI uri;
    protected final NettyChannelBuilder channelBuilder;
    protected ManagedChannel channel;

    public static NettyChannelBuilder getNettyChannelBuilder(NameResolverProvider nameResolverProvider, LoadBalancingPolicy loadBalancingPolicy, URI uri, @Nullable KeyManagerFactory keyManagerFactory, @Nullable TrustManagerFactory trustManagerFactory, @Nullable String overrideAuthority, @Nullable Iterable<String> ciphers, String ... tlsVersionProtocols) throws SSLException {
        NettyChannelBuilder channelBuilder;
        String target = uri.toString();
        switch (uri.getScheme()) {
            case "unix": {
                channelBuilder = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(uri.getPath())).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext();
                break;
            }
            default: {
                if (nameResolverProvider != null) {
                    NameResolverRegistry nameResolverRegistry = NameResolverRegistry.getDefaultRegistry();
                    for (NameResolverProvider nrp : NR_Providers) {
                        nameResolverRegistry.deregister(nrp);
                    }
                    nameResolverRegistry.register(nameResolverProvider);
                    NR_Providers.add(nameResolverProvider);
                    String policy = loadBalancingPolicy.getValue();
                    channelBuilder = (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)target).defaultLoadBalancingPolicy(policy);
                    break;
                }
                String host = uri.getHost();
                int port = uri.getPort();
                if (host == null) {
                    throw new IllegalArgumentException("The URI format should contains host information, like <scheme>://[host:port]/[service], like grpc:///, grpc://host:port, grpcs://host:port, or unix:///path/to/uds.sock. gRpc.client.LoadBalancing.servers should be provided when host/port are not provided.");
                }
                channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
            }
        }
        if (keyManagerFactory == null) {
            channelBuilder.usePlaintext();
        } else {
            SslContextBuilder sslBuilder = GrpcSslContexts.forClient();
            sslBuilder.keyManager(keyManagerFactory);
            if (trustManagerFactory == null) {
                sslBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else {
                sslBuilder.trustManager(trustManagerFactory);
                if (overrideAuthority != null) {
                    channelBuilder.overrideAuthority(overrideAuthority);
                }
            }
            GrpcSslContexts.configure((SslContextBuilder)sslBuilder, (SslProvider)SslProvider.OPENSSL);
            if (tlsVersionProtocols != null) {
                sslBuilder.protocols(tlsVersionProtocols);
            }
            if (ciphers != null) {
                sslBuilder.ciphers(ciphers);
            }
            SslContext sslContext = sslBuilder.build();
            channelBuilder.sslContext(sslContext).useTransportSecurity();
        }
        return channelBuilder;
    }

    public static NettyChannelBuilder NettyChannelBuilder(NameResolverProvider nameResolverProvider, URI uri) throws SSLException {
        return GRPCClient.getNettyChannelBuilder(nameResolverProvider, LoadBalancingPolicy.ROUND_ROBIN, uri, null, null, null, null, new String[0]);
    }

    public GRPCClient(NameResolverProvider nameResolverProvider, URI uri) throws SSLException {
        this(nameResolverProvider, uri, null, null, null, null, new String[0]);
    }

    public GRPCClient(NameResolverProvider nameResolverProvider, URI uri, @Nullable KeyManagerFactory keyManagerFactory, @Nullable TrustManagerFactory trustManagerFactory, @Nullable String overrideAuthority, @Nullable Iterable<String> ciphers, String ... tlsVersionProtocols) throws SSLException {
        this.nameResolverProvider = nameResolverProvider;
        this.uri = uri;
        this.channelBuilder = GRPCClient.getNettyChannelBuilder(nameResolverProvider, LoadBalancingPolicy.ROUND_ROBIN, uri, keyManagerFactory, trustManagerFactory, overrideAuthority, ciphers, tlsVersionProtocols);
    }

    public GRPCClient(NettyChannelBuilder channelBuilder) {
        this.nameResolverProvider = null;
        this.uri = null;
        this.channelBuilder = channelBuilder;
    }

    public T connect() {
        this.disconnect();
        this.channel = this.channelBuilder.build();
        String info2 = this.channel.authority();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.channel.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, "GRPCClient.shutdown and disconnect from " + info2));
        this.onConnected(this.channel);
        return (T)this;
    }

    protected abstract void onConnected(ManagedChannel var1);

    public void disconnect() {
        if (this.channel != null) {
            try {
                this.channel.shutdownNow();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.channel = null;
            }
        }
    }

    public static enum LoadBalancingPolicy {
        ROUND_ROBIN("round_robin"),
        PICK_FIRST("pick_first");

        private final String value;

        private LoadBalancingPolicy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

