/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Singleton;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.nio.server.multipart.MultipartUtil;

@ChannelHandler.Sharable
@Singleton
public class BootHttpFileUploadRejector
extends SimpleChannelInboundHandler<HttpObject> {
    protected static Logger log = LogManager.getLogger((String)BootHttpFileUploadRejector.class.getName());
    protected static final boolean AUTO_RELEASE = false;

    public BootHttpFileUploadRejector() {
        super(false);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable ex) {
        if (ex instanceof DecoderException) {
            log.warn(ctx.channel().remoteAddress() + ": " + ex);
        } else {
            log.warn(ctx.channel().remoteAddress() + ": " + ex, ex);
        }
        if (ex instanceof OutOfMemoryError) {
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject httpObject) throws Exception {
        HttpRequest request;
        boolean isMultipart = false;
        if (httpObject instanceof HttpRequest && (isMultipart = MultipartUtil.isMultipart(request = (HttpRequest)httpObject))) {
            ReferenceCountUtil.release((Object)httpObject);
            ctx.channel().close();
            return;
        }
        if (!isMultipart) {
            ctx.fireChannelRead((Object)httpObject);
        }
    }
}

