/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.ws.rs;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.lang.invoke.CallSite;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceRequest;
import org.summerboot.jexpress.nio.server.ws.rs.EnumConvert;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

class JaxRsRequestParameter {
    protected final Class targetClass;
    protected final Type parameterizedType;
    protected final Type[] argTypes;
    protected final Class genericClassT;
    protected final ParamType type;
    protected final String key;
    protected final String defaultValue;
    protected final boolean isRequired;
    protected final Pattern pattern;
    protected boolean autoBeanValidation = false;
    protected boolean cookieParamObj = false;
    protected final EnumConvert.To enumConvert;
    protected final String collectionDelimiter;

    public JaxRsRequestParameter(String info2, HttpMethod httpMethod, List<String> consumes, Parameter param) {
        this.collectionDelimiter = null;
        String error2 = "\n\tparameter is not allowed in " + info2 + "(" + param + ")\n\t - ";
        this.parameterizedType = param.getParameterizedType();
        if (this.parameterizedType instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)this.parameterizedType;
            Type fieldRawType = genericType.getRawType();
            this.targetClass = fieldRawType instanceof Class ? (Class)fieldRawType : param.getType();
            this.argTypes = genericType.getActualTypeArguments();
        } else {
            this.targetClass = param.getType();
            this.argTypes = null;
        }
        this.genericClassT = this.argTypes == null || this.argTypes.length < 1 ? null : (Class)this.argTypes[0];
        this.pattern = param.getAnnotation(Pattern.class);
        DefaultValue dft = param.getAnnotation(DefaultValue.class);
        if (dft == null) {
            this.defaultValue = null;
        } else {
            String dv = dft.value();
            String string = this.defaultValue = StringUtils.isBlank((CharSequence)dv) ? null : dv;
        }
        if (this.targetClass.equals(ServiceRequest.class)) {
            this.type = ParamType.Request;
            this.key = null;
        } else if (this.targetClass.equals(ServiceContext.class)) {
            this.type = ParamType.Response;
            this.key = null;
        } else {
            PathParam pathParam = param.getAnnotation(PathParam.class);
            MatrixParam matrixParam = param.getAnnotation(MatrixParam.class);
            QueryParam queryParam = param.getAnnotation(QueryParam.class);
            FormParam formParam = param.getAnnotation(FormParam.class);
            HeaderParam headerParam = param.getAnnotation(HeaderParam.class);
            CookieParam cookieParam = param.getAnnotation(CookieParam.class);
            if (pathParam != null) {
                this.type = ParamType.PathParam;
                this.key = pathParam.value();
            } else if (matrixParam != null) {
                this.type = ParamType.MatrixParam;
                this.key = matrixParam.value();
            } else if (queryParam != null) {
                this.type = ParamType.QueryParam;
                this.key = queryParam.value();
            } else if (formParam != null) {
                this.type = ParamType.FormParam;
                this.key = formParam.value();
            } else if (headerParam != null) {
                this.type = ParamType.HeaderParam;
                this.key = headerParam.value();
            } else if (cookieParam != null) {
                if (this.targetClass.equals(String.class)) {
                    this.cookieParamObj = false;
                } else if (this.targetClass.equals(Cookie.class)) {
                    this.cookieParamObj = true;
                } else {
                    throw new UnsupportedOperationException(error2 + "CookieParam type either String or " + Cookie.class.getName());
                }
                this.type = ParamType.CookieParam;
                this.key = cookieParam.value();
            } else {
                this.key = null;
                if (this.targetClass.equals(String.class)) {
                    this.type = ParamType.Body_STRING;
                } else {
                    String serverConsumesOnlyOneTyoe;
                    Valid v = param.getAnnotation(Valid.class);
                    if (v != null) {
                        this.autoBeanValidation = true;
                    }
                    this.type = consumes == null ? ParamType.Body_OnDemond_BylClientRquestType : (consumes.size() > 1 || consumes.contains("*/*") ? ParamType.Body_OnDemond_BylClientRquestType : ((serverConsumesOnlyOneTyoe = consumes.get(0).toLowerCase()).contains("json") ? ParamType.Body_JSON : (serverConsumesOnlyOneTyoe.contains("xml") ? ParamType.Body_XML : ParamType.Body_OnDemond_BylClientRquestType)));
                }
            }
        }
        this.isRequired = param.getAnnotation(NotNull.class) != null || param.getAnnotation(Nonnull.class) != null;
        EnumConvert cs = param.getAnnotation(EnumConvert.class);
        this.enumConvert = cs != null ? cs.value() : null;
    }

    public ParamType getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object value(ServiceRequest request, ServiceContext context) {
        String ct;
        ParamType currentType = this.type;
        if (currentType.equals((Object)ParamType.Body_OnDemond_BylClientRquestType) && (ct = request.getHttpHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null) {
            if ((ct = ct.toLowerCase()).contains("json")) {
                currentType = ParamType.Body_JSON;
            } else if (ct.contains("xml")) {
                currentType = ParamType.Body_XML;
            }
        }
        switch (currentType) {
            case Request: {
                return request;
            }
            case Response: {
                return context;
            }
            case PathParam: {
                String v = request.getPathParam(this.key);
                return this.parse(v, this.defaultValue, context);
            }
            case MatrixParam: {
                String v = request.getMatrixParam(this.key);
                return this.parse(v, this.defaultValue, context);
            }
            case QueryParam: {
                String v = request.getQueryParam(this.key);
                return this.parse(v, this.defaultValue, context);
            }
            case FormParam: {
                String v = request.getFormParam(this.key);
                return this.parse(v, this.defaultValue, context);
            }
            case HeaderParam: {
                String v = request.getHttpHeaders().get(this.key);
                return this.parse(v, this.defaultValue, context);
            }
            case CookieParam: {
                String v;
                String value = request.getHttpHeaders().get((CharSequence)HttpHeaderNames.COOKIE);
                if (value == null) {
                    return null;
                }
                Set cookies = ServerCookieDecoder.STRICT.decode(value);
                for (Cookie cookie : cookies) {
                    if (!cookie.name().equals(this.key)) continue;
                    if (this.cookieParamObj) {
                        return cookie;
                    }
                    v = cookie.value();
                    if (!StringUtils.isBlank((CharSequence)v) || this.defaultValue == null) return this.parse(v, this.defaultValue, context);
                    v = this.defaultValue;
                    return this.parse(v, this.defaultValue, context);
                }
            }
            case Body_JSON: {
                void var7_10;
                try {
                    if (this.genericClassT == null) {
                        Object t = BeanUtil.fromJson(this.targetClass, request.getHttpPostRequestBody());
                    } else {
                        Object r = BeanUtil.fromJson(this.targetClass, this.genericClassT, request.getHttpPostRequestBody());
                    }
                }
                catch (Throwable ex) {
                    Err<CallSite> e = new Err<CallSite>(61, null, null, ex, (CallSite)((Object)("Unknown request(JSON) body: " + ex.toString())));
                    context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                    return null;
                }
                if (var7_10 == null) {
                    if (!this.isRequired) return null;
                    Err<CallSite> e = new Err<CallSite>(63, null, null, null, (CallSite)((Object)("Missing request(JSON) body: " + this.type)));
                    context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                    return var7_10;
                } else {
                    if (!this.autoBeanValidation) return var7_10;
                    if (var7_10 instanceof Collection) {
                        Collection c = (Collection)var7_10;
                        boolean hasError = false;
                        for (Object o : c) {
                            String validationError = BeanUtil.getBeanValidationResult(o);
                            if (validationError == null) continue;
                            hasError = true;
                            Err<CallSite> e = new Err<CallSite>(66, null, null, null, (CallSite)((Object)("Invalid request(JSON) body: " + validationError)));
                            context.error(e);
                        }
                        if (!hasError) return var7_10;
                        context.status(HttpResponseStatus.BAD_REQUEST);
                        return null;
                    }
                    String validationError = BeanUtil.getBeanValidationResult(var7_10);
                    if (validationError == null) return var7_10;
                    Err<CallSite> e = new Err<CallSite>(66, null, null, null, (CallSite)((Object)("Invalid request(JSON) body: " + validationError)));
                    context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                    return null;
                }
            }
            case Body_STRING: {
                String v = request.getHttpPostRequestBody();
                if (!this.isRequired || !StringUtils.isBlank((CharSequence)v)) return v;
                Err<CallSite> e = new Err<CallSite>(64, null, null, null, (CallSite)((Object)("Missing request body: " + this.type)));
                context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                return v;
            }
            case Body_XML: {
                Object t;
                String v = request.getHttpPostRequestBody();
                try {
                    t = BeanUtil.fromXML(this.targetClass, v);
                }
                catch (Throwable ex) {
                    Err<CallSite> e = new Err<CallSite>(62, null, null, ex, (CallSite)((Object)("Unknown request(XML) body: " + ex.toString())));
                    context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                    return null;
                }
                if (t == null) {
                    if (!this.isRequired) return null;
                    Err<CallSite> e = new Err<CallSite>(65, null, null, null, (CallSite)((Object)("Missing request(XML) body: " + this.type)));
                    context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                    return t;
                } else {
                    String validationError;
                    if (!this.autoBeanValidation || (validationError = BeanUtil.getBeanValidationResult(t)) == null) return t;
                    Err<CallSite> e = new Err<CallSite>(67, null, null, null, (CallSite)((Object)("Invalid request(XML) body: " + validationError)));
                    context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                    return null;
                }
            }
            case Body_OnDemond_BylClientRquestType: {
                String validationError;
                String v = request.getHttpPostRequestBody();
                Object object = this.parse(v, this.defaultValue, context);
                if (!this.autoBeanValidation || (validationError = BeanUtil.getBeanValidationResult(object)) == null) return object;
                Err<CallSite> e = new Err<CallSite>(68, null, null, null, (CallSite)((Object)("Invalid request body: " + validationError)));
                context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                return null;
            }
        }
        return null;
    }

    protected Object parse(String value, String defaultValue, ServiceContext context) {
        String regex;
        if (StringUtils.isBlank((CharSequence)value)) {
            if (defaultValue != null) {
                value = defaultValue;
            } else {
                if (this.isRequired) {
                    Err<CallSite> e = new Err<CallSite>(69, null, null, null, (CallSite)((Object)("Missing Required Filed: " + this.type + "{" + this.key + "}=" + value)));
                    context.status(HttpResponseStatus.BAD_REQUEST).error(e);
                }
                return ReflectionUtil.toStandardJavaType(null, this.targetClass, false, false, null);
            }
        }
        String string = regex = this.pattern == null ? null : this.pattern.regexp();
        if (regex != null && !value.matches(regex)) {
            Err<CallSite> e = new Err<CallSite>(BootErrorCode.BAD_REQUEST_DATA, null, null, null, (CallSite)((Object)("Failed to parse data type: invalid " + this.type + "{" + this.key + "}=" + value + " by regex=" + regex)));
            context.status(HttpResponseStatus.BAD_REQUEST).error(e);
            return ReflectionUtil.toStandardJavaType(null, this.targetClass, false, false, null);
        }
        try {
            return ReflectionUtil.toJavaType(this.targetClass, this.parameterizedType, value, false, false, this.enumConvert, this.collectionDelimiter);
        }
        catch (Throwable ex) {
            Err<CallSite> e = new Err<CallSite>(BootErrorCode.BAD_REQUEST_DATA, null, null, ex, (CallSite)((Object)("Failed to parse data type: invalid " + this.type + "{" + this.key + "}=" + value)));
            context.status(HttpResponseStatus.BAD_REQUEST).error(e);
            return ReflectionUtil.toStandardJavaType(null, this.targetClass, false, false, null);
        }
    }

    public static enum ParamType {
        Request,
        Response,
        Body_STRING,
        Body_JSON,
        Body_XML,
        Body_OnDemond_BylClientRquestType,
        PathParam,
        MatrixParam,
        QueryParam,
        FormParam,
        HeaderParam,
        CookieParam;

    }
}

