/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.cache;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.integration.cache.domain.FlashSale;

public interface BootCache {
    public boolean tryLock(String var1, String var2, long var3, TimeUnit var5);

    public boolean unlock(String var1, String var2);

    default public String generateUnlockPassword() {
        return UUID.randomUUID().toString() + "_" + BootConstant.PID + "_" + Thread.currentThread().getName();
    }

    default public boolean debounced(String key, String unlockPassword, long ttl, TimeUnit timeUnit) {
        return !this.tryLock(key, unlockPassword, ttl, timeUnit);
    }

    default public void flashsaleEnable(String itemId, boolean isEnabled) {
    }

    default public boolean flashsaleInventoryInit(String itemId, long totalAmount, long limit) {
        return false;
    }

    default public long flashsaleAcquireQuota(String itemId, long requestAmount) {
        return -600L;
    }

    default public long flashsaleRevokeQuota(String itemId, long requestAmount) {
        return 0L;
    }

    default public FlashSale flashsaleInventoryReport(String itemId) {
        return null;
    }
}

