/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.security.SSLUtil;

public class LdapSSLConnectionFactory4
extends SocketFactory {
    protected static final AtomicReference<LdapSSLConnectionFactory4> defaultFactory = new AtomicReference();
    protected final SSLSocketFactory sf;
    public static String TLS_PROTOCOL = "TLSv1.3";
    protected static KeyManager[] KMS;
    protected static TrustManager[] TMS;

    public static void init(KeyManagerFactory kmf, TrustManagerFactory tmf, String protocol) {
        KMS = kmf == null ? null : kmf.getKeyManagers();
        TrustManager[] trustManagerArray = TMS = tmf == null ? null : tmf.getTrustManagers();
        if (protocol != null) {
            TLS_PROTOCOL = protocol;
        }
    }

    public LdapSSLConnectionFactory4() {
        try {
            SSLContext sslCtx = SSLUtil.buildSSLContext(KMS, TMS, TLS_PROTOCOL);
            this.sf = sslCtx.getSocketFactory();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static SocketFactory getDefault() {
        LdapSSLConnectionFactory4 value = defaultFactory.get();
        if (value == null) {
            defaultFactory.compareAndSet(null, new LdapSSLConnectionFactory4());
            return defaultFactory.get();
        }
        return value;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.sf.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.sf.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.sf.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sf.createSocket(address, port, localAddress, localPort);
    }
}

