/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpTimeoutException;
import java.nio.channels.UnresolvedAddressException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.naming.NamingException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.boot.event.HttpExceptionListener;
import org.summerboot.jexpress.boot.event.HttpLifecycleListener;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.server.NioServerHttpRequestHandler;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.security.auth.Authenticator;

@Singleton
@ChannelHandler.Sharable
public class BootHttpRequestHandler
extends NioServerHttpRequestHandler {
    @Inject
    protected Authenticator authenticator;
    @Inject
    protected AuthTokenCache authTokenCache;
    @Inject
    protected HttpLifecycleListener httpLifecycleListener;
    @Inject
    protected HttpExceptionListener httpExceptionListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProcessorSettings service(ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        ProcessorSettings processorSettings;
        block36: {
            processorSettings = null;
            RequestProcessor processor = null;
            boolean preProcessSuccess = false;
            try {
                processor = this.getRequestProcessor(httptMethod, httpRequestPath);
                if (processor == null && (processor = this.getRequestProcessor(httptMethod, "")) == null) {
                    this.httpExceptionListener.onActionNotFound(ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                    ProcessorSettings processorSettings2 = processorSettings;
                    return processorSettings2;
                }
                processorSettings = processor.getProcessorSettings();
                ProcessorSettings.LogSettings logSettings = processorSettings.getLogSettings();
                if (logSettings != null) {
                    context.logRequestHeader(logSettings.isLogRequestHeader());
                    context.logRequestBody(logSettings.isLogRequestBody());
                    context.logResponseHeader(logSettings.isLogResponseHeader());
                    context.logResponseBody(logSettings.isLogResponseBody());
                }
                if (processor.isRoleBased()) {
                    context.poi("auth.begin");
                    if (!this.authenticationCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                        context.status(HttpResponseStatus.UNAUTHORIZED);
                        ProcessorSettings processorSettings3 = processorSettings;
                        return processorSettings3;
                    }
                    if (!processor.authorizationCheck(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context, BootErrorCode.AUTH_NO_PERMISSION)) {
                        context.status(HttpResponseStatus.FORBIDDEN);
                        ProcessorSettings processorSettings4 = processorSettings;
                        return processorSettings4;
                    }
                }
                context.poi("process.begin");
                if (this.authenticator != null && !this.authenticator.customizedAuthorizationCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                    ProcessorSettings processorSettings5 = processorSettings;
                    return processorSettings5;
                }
                preProcessSuccess = this.httpLifecycleListener.beforeProcess(processor, httpRequestHeaders, httpRequestPath, context);
                if (preProcessSuccess) {
                    processor.process(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context);
                    break block36;
                }
                ProcessorSettings processorSettings6 = processorSettings;
                return processorSettings6;
            }
            catch (NamingException ex) {
                this.httpExceptionListener.onNamingException(ex, httptMethod, httpRequestPath, context);
            }
            catch (PersistenceException ex) {
                this.httpExceptionListener.onPersistenceException(ex, httptMethod, httpRequestPath, context);
            }
            catch (HttpConnectTimeoutException ex) {
                this.httpExceptionListener.onHttpConnectTimeoutException(ex, httptMethod, httpRequestPath, context);
            }
            catch (HttpTimeoutException ex) {
                this.httpExceptionListener.onHttpTimeoutException(ex, httptMethod, httpRequestPath, context);
            }
            catch (RejectedExecutionException ex) {
                this.httpExceptionListener.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
            }
            catch (ConnectException ex) {
                this.httpExceptionListener.onConnectException(ex, httptMethod, httpRequestPath, context);
            }
            catch (IOException | UnresolvedAddressException ex) {
                Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                if (cause == null) {
                    cause = ex;
                }
                if (cause instanceof RejectedExecutionException) {
                    this.httpExceptionListener.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
                } else {
                    this.httpExceptionListener.onIOException(ex, httptMethod, httpRequestPath, context);
                }
            }
            catch (InterruptedException ex) {
                this.httpExceptionListener.onInterruptedException(ex, httptMethod, httpRequestPath, context);
            }
            catch (Throwable ex) {
                this.httpExceptionListener.onUnexpectedException(ex, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
            }
            finally {
                if (preProcessSuccess) {
                    this.httpLifecycleListener.afterProcess(processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                }
                context.poi("process.end");
            }
        }
        return processorSettings;
    }

    @Override
    protected void afterService(HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        this.httpLifecycleListener.afterService(httpHeaders, httpMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
    }

    protected boolean authenticationCheck(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, ServiceContext context) throws Exception {
        if (this.authenticator == null) {
            return true;
        }
        this.authenticator.verifyToken(httpRequestHeaders, this.authTokenCache, null, context);
        return context.caller() != null;
    }

    @Override
    protected String beforeLogging(String originallLogContent, HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, Throwable ioEx) {
        return this.httpLifecycleListener.beforeLogging(originallLogContent, httpHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
    }

    @Override
    protected void afterLogging(String logContent, HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, Throwable ioEx) throws Exception {
        this.httpLifecycleListener.afterLogging(logContent, httpHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
    }

    @Override
    public String beforeSendingError(String errorContent) {
        return this.httpLifecycleListener.beforeSendingError(errorContent);
    }
}

