/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.summerboot.jexpress.nio.server.ws.rs.EnumConvert;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.FormatterUtil;

public class ReflectionUtil {
    protected static final Set<Class<?>> PluginClasses = new HashSet();
    protected static final Type[] DEFAULT_ARG_TYPES = new Type[]{String.class, String.class};

    public static void setPluginClasses(Set<Class<?>> pluginClasses) {
        PluginClasses.clear();
        if (pluginClasses != null && !pluginClasses.isEmpty()) {
            PluginClasses.addAll(pluginClasses);
        }
    }

    public static <T> Set<Class<? extends T>> getAllImplementationsByInterface(Class<T> interfaceClass, String ... rootPackageNames) {
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        for (String rootPackageName : rootPackageNames) {
            Reflections reflections;
            Set cs;
            if (StringUtils.isBlank((CharSequence)rootPackageName) || (cs = (reflections = new Reflections(rootPackageName, new Scanner[0])).getSubTypesOf(interfaceClass)).isEmpty()) continue;
            classes.addAll(cs);
        }
        for (Class clazz : PluginClasses) {
            if (!interfaceClass.isAssignableFrom(clazz)) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static <T> Set<Class<? extends T>> getAllImplementationsByInterface(Class<T> interfaceClass, Collection<String> rootPackageNames) {
        String[] sa = (String[])rootPackageNames.toArray(String[]::new);
        return ReflectionUtil.getAllImplementationsByInterface(interfaceClass, sa);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> getAllImplementationsByAnnotation(Class<? extends Annotation> annotation, boolean honorInherited, String ... rootPackageNames) {
        void var6_8;
        HashSet classes = new HashSet();
        String[] stringArray = rootPackageNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            Reflections reflections;
            Set cs;
            String rootPackageName = stringArray[var6_8];
            if (!StringUtils.isBlank((CharSequence)rootPackageName) && !(cs = (reflections = new Reflections(rootPackageName, new Scanner[0])).getTypesAnnotatedWith(annotation, honorInherited)).isEmpty()) {
                classes.addAll(cs);
            }
            ++var6_8;
        }
        classes.addAll(PluginClasses);
        HashSet ret = new HashSet();
        for (Class clazz : classes) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            ret.add(clazz);
        }
        return ret;
    }

    public static Set<Class<?>> getAllImplementationsByAnnotation(Class<? extends Annotation> annotation, boolean honorInherited, Collection<String> rootPackageNames) {
        String[] sa = (String[])rootPackageNames.toArray(String[]::new);
        return ReflectionUtil.getAllImplementationsByAnnotation(annotation, honorInherited, sa);
    }

    public static List<Class> getAllInterfaces(Class targetClass, boolean includeSuperClasses) {
        ArrayList<Class> ret = new ArrayList<Class>();
        while (targetClass != null) {
            Class<?>[] ca = targetClass.getInterfaces();
            if (ca != null) {
                for (Class<?> c : ca) {
                    if (c == null) continue;
                    ret.add(c);
                }
            }
            targetClass = includeSuperClasses ? targetClass.getSuperclass() : null;
        }
        return ret;
    }

    public static List<Class> getAllSuperClasses(Class targetClass) {
        ArrayList<Class> ret = new ArrayList<Class>();
        for (Class parent = targetClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            ret.add(parent);
        }
        return ret;
    }

    public static void loadField(Object instance, Field field, String value, boolean autoDecrypt, boolean isEmailRecipients, String collectionDelimiter) throws IllegalAccessException {
        Class<?> targetClass = field.getType();
        Type genericType = field.getGenericType();
        field.setAccessible(true);
        field.set(instance, ReflectionUtil.toJavaType(targetClass, genericType, value, autoDecrypt, isEmailRecipients, null, collectionDelimiter));
    }

    public static Object toJavaType(Class targetClass, Type genericType, String value, boolean autoDecrypt, boolean isEmailRecipients, EnumConvert.To enumConvert, String collectionDelimiter) throws IllegalAccessException {
        Class classT;
        String[] valuesStr;
        if (StringUtils.isBlank((CharSequence)value)) {
            Object nullValue = ReflectionUtil.toStandardJavaType(null, targetClass, autoDecrypt, false, enumConvert);
            return nullValue;
        }
        value = value.trim();
        Type[] argTypes = DEFAULT_ARG_TYPES;
        Class[] upperBoundClasses = new Class[]{};
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type fieldRawType = parameterizedType.getRawType();
            if (fieldRawType instanceof Class) {
                targetClass = (Class)fieldRawType;
            }
            argTypes = parameterizedType.getActualTypeArguments();
            upperBoundClasses = new Class[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                Type upperBoundType = argTypes[i];
                if (upperBoundType instanceof WildcardType) {
                    upperBoundClasses[i] = (Class)((WildcardType)upperBoundType).getUpperBounds()[0];
                    continue;
                }
                if (!(upperBoundType instanceof Class)) continue;
                upperBoundClasses[i] = (Class)upperBoundType;
            }
        }
        if (targetClass.isArray()) {
            valuesStr = FormatterUtil.parseDsv(value, collectionDelimiter);
            if (valuesStr == null || valuesStr.length < 1) {
                return null;
            }
            classT = targetClass.getComponentType();
            Object array = Array.newInstance(classT, valuesStr.length);
            for (int i = 0; i < valuesStr.length; ++i) {
                Array.set(array, i, ReflectionUtil.toStandardJavaType(valuesStr[i], classT, autoDecrypt, isEmailRecipients, enumConvert));
            }
            return array;
        }
        if (targetClass.equals(Set.class)) {
            valuesStr = FormatterUtil.parseDsv(value, collectionDelimiter);
            if (valuesStr == null || valuesStr.length < 1) {
                return null;
            }
            classT = upperBoundClasses[0];
            Object array = Array.newInstance(classT, valuesStr.length);
            for (int i = 0; i < valuesStr.length; ++i) {
                Array.set(array, i, ReflectionUtil.toStandardJavaType(valuesStr[i], classT, autoDecrypt, isEmailRecipients, enumConvert));
            }
            return Set.of((Object[])array);
        }
        if (targetClass.equals(SortedSet.class)) {
            valuesStr = FormatterUtil.parseDsv(value, collectionDelimiter);
            if (valuesStr == null || valuesStr.length < 1) {
                return null;
            }
            classT = upperBoundClasses[0];
            Object array = Array.newInstance(classT, valuesStr.length);
            for (int i = 0; i < valuesStr.length; ++i) {
                Array.set(array, i, ReflectionUtil.toStandardJavaType(valuesStr[i], classT, autoDecrypt, isEmailRecipients, enumConvert));
            }
            return ImmutableSortedSet.copyOf(List.of((Object[])array));
        }
        if (targetClass.equals(List.class)) {
            valuesStr = FormatterUtil.parseDsv(value, collectionDelimiter);
            if (valuesStr == null || valuesStr.length < 1) {
                return null;
            }
            classT = upperBoundClasses[0];
            Object array = Array.newInstance(classT, valuesStr.length);
            for (int i = 0; i < valuesStr.length; ++i) {
                Array.set(array, i, ReflectionUtil.toStandardJavaType(valuesStr[i], classT, autoDecrypt, isEmailRecipients, enumConvert));
            }
            return List.of((Object[])array);
        }
        if (targetClass.equals(Map.class)) {
            Map<String, String> stringMap = FormatterUtil.parseMap(value);
            if (stringMap == null || stringMap.isEmpty()) {
                return null;
            }
            Class classT1 = upperBoundClasses[0];
            Class classT2 = upperBoundClasses[1];
            HashMap<Object, Object> ret = new HashMap<Object, Object>();
            for (String k : stringMap.keySet()) {
                String v = stringMap.get(k);
                Object keyT = ReflectionUtil.toStandardJavaType(k, classT1, autoDecrypt, isEmailRecipients, enumConvert);
                Object valueT = ReflectionUtil.toStandardJavaType(v, classT2, autoDecrypt, isEmailRecipients, enumConvert);
                ret.put(keyT, valueT);
            }
            return Map.copyOf(ret);
        }
        if (targetClass.equals(Class.class)) {
            try {
                Class<?> ret = Class.forName(value);
                if (upperBoundClasses[0] != null && !upperBoundClasses[0].isAssignableFrom(ret)) {
                    throw new IllegalArgumentException("invalid Class name: " + value + ", expected a type of " + upperBoundClasses[0].getName());
                }
                return ret;
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("invalid Class name: " + value, ex);
            }
        }
        if (targetClass.equals(JsonNode.class)) {
            try {
                return BeanUtil.JacksonMapper.readTree(value);
            }
            catch (JsonProcessingException ex) {
                throw new IllegalArgumentException("invalid json data: " + value, ex);
            }
        }
        Object v = ReflectionUtil.toStandardJavaType(value, targetClass, autoDecrypt, isEmailRecipients, enumConvert);
        return v;
    }

    public static Object toStandardJavaType(String value, Class targetClass, boolean autoDecrypt, boolean isEmailRecipients, EnumConvert.To enumConvert) {
        File f;
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)value)) {
            if (targetClass.equals(Boolean.TYPE)) {
                return false;
            }
            if (targetClass.equals(Character.TYPE)) {
                return Character.valueOf('\u0000');
            }
            if (targetClass.equals(Byte.TYPE) || targetClass.equals(Short.TYPE) || targetClass.equals(Integer.TYPE) || targetClass.equals(Long.TYPE) || targetClass.equals(Float.TYPE) || targetClass.equals(Double.TYPE)) {
                return (byte)0;
            }
            if (targetClass.equals(TimeZone.class)) {
                return TimeZone.getDefault();
            }
            return null;
        }
        value = value.trim();
        if (autoDecrypt && value.startsWith("ENC(") && value.endsWith(")")) {
            try {
                value = SecurityUtil.decrypt(value, true);
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalArgumentException("Failed to decrypt", ex);
            }
        }
        if (isEmailRecipients && !(matcher = FormatterUtil.REGEX_EMAIL_PATTERN.matcher(value)).matches()) {
            throw new IllegalArgumentException("invalid email address format");
        }
        if (targetClass.equals(String.class)) {
            return value;
        }
        if (targetClass.equals(Boolean.TYPE) || targetClass.equals(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        if (targetClass.equals(Byte.TYPE) || targetClass.equals(Byte.class)) {
            return Byte.parseByte(value);
        }
        if (targetClass.equals(Character.TYPE)) {
            return Character.valueOf((char)Short.parseShort(value));
        }
        if (targetClass.equals(Short.TYPE) || targetClass.equals(Short.class)) {
            return Short.parseShort(value);
        }
        if (targetClass.equals(Integer.TYPE) || targetClass.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (targetClass.equals(Long.TYPE) || targetClass.equals(Long.class)) {
            return Long.parseLong(value);
        }
        if (targetClass.equals(Float.TYPE) || targetClass.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (targetClass.equals(Double.TYPE) || targetClass.equals(Double.class)) {
            return Double.parseDouble(value);
        }
        if (targetClass.equals(BigDecimal.class)) {
            return BigDecimal.valueOf(Double.parseDouble(value));
        }
        if (targetClass.equals(URI.class)) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("invalid URI format", ex);
            }
        }
        if (targetClass.equals(URL.class)) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("invalid URL format", ex);
            }
        }
        if (targetClass.equals(Path.class)) {
            f = new File(value);
            return f.getAbsoluteFile().toPath().normalize();
        }
        if (targetClass.equals(File.class)) {
            f = new File(value);
            Path path = f.getAbsoluteFile().toPath().normalize();
            return path.toFile();
        }
        if (targetClass.isEnum()) {
            if (enumConvert != null) {
                switch (enumConvert) {
                    case UpperCase: {
                        value = value.toUpperCase();
                        break;
                    }
                    case LowerCase: {
                        value = value.toLowerCase();
                    }
                }
            }
            return Enum.valueOf(targetClass, value);
        }
        if (targetClass.equals(OffsetDateTime.class)) {
            return OffsetDateTime.parse(value, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
        if (targetClass.equals(ZonedDateTime.class)) {
            return ZonedDateTime.parse(value, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
        if (targetClass.equals(LocalDateTime.class)) {
            return LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
        }
        if (targetClass.equals(LocalDate.class)) {
            return LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        if (targetClass.equals(TimeZone.class)) {
            if (value.equals("system") || value.equals("default")) {
                return TimeZone.getDefault();
            }
            return TimeZone.getTimeZone(value);
        }
        if (targetClass.equals(InetSocketAddress.class) || targetClass.equals(SocketAddress.class)) {
            String[] ap = value.trim().split(":");
            return new InetSocketAddress(ap[0], Integer.parseInt(ap[1]));
        }
        try {
            Method mtd = targetClass.getMethod("valueOf", String.class);
            return mtd.invoke(null, value);
        }
        catch (NoSuchMethodException | SecurityException mtd) {
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException mtd) {
            // empty catch block
        }
        try {
            Method mtd = targetClass.getMethod("of", String.class);
            return mtd.invoke(null, value);
        }
        catch (NoSuchMethodException | SecurityException mtd) {
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException mtd) {
            // empty catch block
        }
        try {
            Method mtd = targetClass.getMethod("fromString", String.class);
            return mtd.invoke(null, value);
        }
        catch (NoSuchMethodException | SecurityException mtd) {
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException mtd) {
            // empty catch block
        }
        try {
            Constructor cst = targetClass.getConstructor(String.class);
            return cst.newInstance(value);
        }
        catch (NoSuchMethodException | SecurityException exception) {
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            // empty catch block
        }
        return null;
    }

    public static void loadFields(Class targetClass, Class fieldClass, Map results, boolean includeClassName) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Class<?>[] intfs;
        Class parent = targetClass.getSuperclass();
        if (parent != null) {
            ReflectionUtil.loadFields(parent, fieldClass, results, includeClassName);
        }
        if ((intfs = targetClass.getInterfaces()) != null) {
            for (Class<?> i : intfs) {
                ReflectionUtil.loadFields(i, fieldClass, results, includeClassName);
            }
        }
        for (Field field : fields = targetClass.getDeclaredFields()) {
            Class<?> type = field.getType();
            if (!fieldClass.equals(type)) continue;
            String varName = includeClassName ? targetClass.getName() + "." + field.getName() : field.getName();
            Object varValue = field.get(null);
            results.put(varName, varValue);
        }
    }

    public static String loadFields(Class targetClass, Class fieldClass) throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        HashMap results = new HashMap();
        ReflectionUtil.loadFields(targetClass, fieldClass, results, false);
        Map sorted = results.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (e1, e2) -> e1, LinkedHashMap::new));
        return BeanUtil.toJson(sorted, true, false);
    }

    public static String getRootPackageName(Class callerClass, int level) {
        String packageName = callerClass.getPackageName();
        if (level < 1) {
            return packageName;
        }
        String[] packageNames = FormatterUtil.parseDsv(packageName, "\\.");
        if (level >= packageNames.length) {
            return packageName;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(packageNames[i]);
        }
        return sb.toString();
    }

    public static List<Field> getDeclaredAndSuperClassesFields(Class targetClass) {
        ArrayList<Field> ret = new ArrayList<Field>();
        do {
            Field[] fields = targetClass.getDeclaredFields();
            ret.addAll(Arrays.asList(fields));
        } while ((targetClass = targetClass.getSuperclass()) != null);
        return ret;
    }

    public static List<Field> getDeclaredAndSuperClassesFields(Class targetClass, boolean isParentFirst) {
        ArrayList<Field> ret = new ArrayList<Field>();
        List<Class> classes = ReflectionUtil.getAllSuperClasses(targetClass);
        classes.add(0, targetClass);
        if (isParentFirst) {
            Collections.reverse(classes);
        }
        for (Class c : classes) {
            Field[] fields = c.getDeclaredFields();
            ret.addAll(Arrays.asList(fields));
        }
        return ret;
    }

    public static List<Method> getDeclaredAndSuperClassesMethods(Class targetClass, boolean includOverriddenSuperMethod) {
        ArrayList<Method> ret = new ArrayList<Method>();
        do {
            Method[] methods = targetClass.getDeclaredMethods();
            if (includOverriddenSuperMethod) {
                ret.addAll(Arrays.asList(methods));
                continue;
            }
            for (Method m : methods) {
                if (ret.contains(m)) continue;
                ret.add(m);
            }
        } while ((targetClass = targetClass.getSuperclass()) != null);
        return ret;
    }

    public static Method getMethod(Class targetClass, String methodName, Class[] cArg) {
        Method ret = null;
        do {
            try {
                ret = targetClass.getDeclaredMethod(methodName, cArg);
            }
            catch (NoSuchMethodException ex) {
                targetClass = targetClass.getSuperclass();
            }
        } while (ret == null && targetClass != null);
        return ret;
    }
}

