/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.jpa;

import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.time.OffsetDateTime;

@MappedSuperclass
public abstract class AbstractEntity
implements Serializable {
    @Version
    @Column(name="version")
    protected int version;
    @Column(name="createdTs", nullable=false, updatable=false)
    protected OffsetDateTime createdTs = OffsetDateTime.now();
    @Column(name="updatedTs", nullable=false, updatable=true)
    protected OffsetDateTime updatedTs = OffsetDateTime.now();

    protected AbstractEntity() {
    }

    @PreUpdate
    protected void updateTimestamp() {
        this.updatedTs = OffsetDateTime.now();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public OffsetDateTime getCreatedTs() {
        return this.createdTs;
    }

    public void setCreatedTs(OffsetDateTime createdTs) {
        this.createdTs = createdTs;
    }

    public OffsetDateTime getUpdatedTs() {
        return this.updatedTs;
    }

    public void setUpdatedTs(OffsetDateTime updatedTs) {
        this.updatedTs = updatedTs;
    }
}

