/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.ldap;

public class LDAPEncoder {
    public static String escapeDN(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (name.length() > 0 && (name.charAt(0) == ' ' || name.charAt(0) == '#')) {
            sb.append('\\');
        }
        block9: for (int i = 0; i < name.length(); ++i) {
            char curChar = name.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '&': {
                    sb.append("\\&");
                    continue block9;
                }
                case '+': {
                    sb.append("\\+");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '<': {
                    sb.append("\\<");
                    continue block9;
                }
                case '>': {
                    sb.append("\\>");
                    continue block9;
                }
                case ';': {
                    sb.append("\\;");
                    continue block9;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        if (name.length() > 1 && name.charAt(name.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    public static final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }
}

