/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.nio.grpc.BootLoadBalancerProvider;
import org.summerboot.jexpress.nio.grpc.GRPCClient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public abstract class GRPCClientConfig
extends BootConfig {
    protected static final String FILENAME_TRUSTSTORE_4CLIENT = "truststore_grpc_client.p12";
    protected static final String ID = "gRpc.client";
    @ConfigHeader(title="1. gRpc.client provider", format="server1:port1, server2:port2, ..., serverN:portN", example="localhost:8424, remotehost:8425, 127.0.0.1:8426")
    @Config(key="gRpc.client.LoadBalancing.servers", predefinedValue="0.0.0.0:8424, 0.0.0.0:8425", required=false)
    protected volatile List<InetSocketAddress> loadBalancingServers;
    @Config(key="gRpc.client.LoadBalancing.scheme", defaultValue="grpc", desc="In case you have more than one gRPC client needs to connect to different gRPC services, you can set this to distinguish them")
    protected volatile String loadBalancingTargetScheme = "grpc";
    @Config(key="gRpc.client.LoadBalancing.policy", defaultValue="ROUND_ROBIN", desc="available options: ROUND_ROBIN, PICK_FIRST")
    protected volatile LoadBalancingPolicy loadBalancingPolicy;
    protected volatile NameResolverProvider nameResolverProvider;
    @Config(key="gRpc.client.target.url", defaultValue="grpc:///", desc="grpc:///\ngrpc://127.0.0.1:8424\nunix:/tmp/grpcsrver.socket")
    protected volatile URI uri;
    @Config(key="gRpc.client.ssl.Protocols", defaultValue="TLSv1.3")
    protected String[] sslProtocols;
    @Config(key="gRpc.client.ssl.ciphers")
    protected List ciphers;
    protected static final String KEY_kmf_key = "gRpc.client.ssl.KeyStore";
    protected static final String KEY_kmf_StorePwdKey = "gRpc.client.ssl.KeyStorePwd";
    protected static final String KEY_kmf_AliasKey = "gRpc.client.ssl.KeyAlias";
    protected static final String KEY_kmf_AliasPwdKey = "gRpc.client.ssl.KeyPwd";
    @ConfigHeader(title="2. gRpc.client keystore")
    @Config(key="gRpc.client.ssl.KeyStore", StorePwdKey="gRpc.client.ssl.KeyStorePwd", AliasKey="gRpc.client.ssl.KeyAlias", AliasPwdKey="gRpc.client.ssl.KeyPwd", desc="Path to key store file. Use SSL/TLS when keystore is provided, otherwise use plain socket", callbackMethodName4Dump="generateTemplate_keystore")
    protected volatile KeyManagerFactory kmf;
    protected static final String KEY_tmf_key = "gRpc.client.ssl.TrustStore";
    protected static final String KEY_tmf_StorePwdKey = "gRpc.client.ssl.TrustStorePwd";
    @ConfigHeader(title="3. gRpc.client truststore")
    @Config(key="gRpc.client.ssl.TrustStore", StorePwdKey="gRpc.client.ssl.TrustStorePwd", callbackMethodName4Dump="generateTemplate_truststore", desc="Path to trust store file. Auth the remote peer certificate when a truststore is provided, otherwise blindly trust all remote peer certificate")
    @JsonIgnore
    protected volatile TrustManagerFactory tmf;
    @Config(key="gRpc.client.ssl.overrideAuthority", predefinedValue="server2.4096.jexpress.org", desc="NOT for PRODUCTION! Set server certificate DNS name here when server is not yet running on its certificate Subject Alternative Names (SAN)")
    protected volatile String overrideAuthority;
    @JsonIgnore
    protected volatile NettyChannelBuilder channelBuilder;
    @ConfigHeader(title="4. gRpc.client Channel Settings", desc="The following settings are for NettyChannelBuilder, which is used to create a gRPC channel")
    @Config(key="gRpc.client.channel.userAgent", desc="string: default null")
    protected volatile String userAgent = null;
    @Config(key="gRpc.client.channel.maxInboundMessageSize", desc="int: default 4194304 if not set")
    protected volatile Integer maxInboundMessageSize = null;
    @Config(key="gRpc.client.channel.maxHeaderListSize", desc="int: default 8192 if not set")
    protected volatile Integer maxHeaderListSize = null;
    @Config(key="gRpc.client.channel.perRpcBufferLimit", desc="long: default 1048576L if not set")
    protected volatile Long perRpcBufferLimit = null;
    @Config(key="gRpc.client.channel.maxHedgedAttempts", desc="int: default 5 if not set")
    protected volatile Integer maxHedgedAttempts = null;
    @Config(key="gRpc.client.channel.idleTimeoutSeconds", desc="long: default 1800 (30 minutes) if not set")
    protected volatile Long idleTimeoutSeconds = null;
    @Config(key="gRpc.client.channel.keepAliveWithoutCalls", desc="boolean: default false if not set. keepAliveWithoutCalls is used when you are willing to spend client, server, and network resources to have lower latency for very infrequent RPCs")
    protected volatile Boolean keepAliveWithoutCalls = null;
    @Config(key="gRpc.client.channel.keepAliveTimeSeconds", desc="long: default Long.MAX_VALUE (never) if not set. The interval in seconds between PING frames.")
    protected volatile Long keepAliveTimeSeconds = null;
    @Config(key="gRpc.client.channel.keepAliveTimeoutSeconds", desc="long: default 20 seconds if not set. The timeout in seconds for a PING frame to be acknowledged. If sender does not receive an acknowledgment within this time, it will close the connection.")
    protected volatile Long keepAliveTimeoutSeconds = null;
    @Config(key="gRpc.client.channel.retryEnabled", desc="boolean: default true if not set")
    protected volatile Boolean retryEnabled = null;
    @Config(key="gRpc.client.channel.maxRetryAttempts", desc="int: default 5 if not set")
    protected volatile Integer maxRetryAttempts = null;
    @Config(key="gRpc.client.channel.retryBufferSize", desc="int: default 16777216L if not set")
    protected volatile Long retryBufferSize = null;
    protected static int priority = 0;
    private Set<GRPCClient> listeners = new HashSet<GRPCClient>();

    public static void main(String[] args) {
        class A
        extends GRPCClientConfig {
            A() {
            }
        }
        String t = GRPCClientConfig.generateTemplate(A.class);
        System.out.println(t);
    }

    protected GRPCClientConfig() {
    }

    protected void generateTemplate_keystore(StringBuilder sb) {
        sb.append("gRpc.client.ssl.KeyStore=keystore.p12\n");
        sb.append("gRpc.client.ssl.KeyStorePwd=DEC(changeit)\n");
        sb.append("gRpc.client.ssl.KeyAlias=server3_4096.jexpress.org\n");
        sb.append("gRpc.client.ssl.KeyPwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    protected void generateTemplate_truststore(StringBuilder sb) {
        sb.append("gRpc.client.ssl.TrustStore=truststore_grpc_client.p12\n");
        sb.append("gRpc.client.ssl.TrustStorePwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    @Override
    protected void preLoad(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) {
        this.createIfNotExist("keystore.p12", "keystore.p12");
        this.createIfNotExist("truststore.p12", FILENAME_TRUSTSTORE_4CLIENT);
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws IOException {
        if (!isReal) {
            return;
        }
        NameResolverRegistry nameResolverRegistry = NameResolverRegistry.getDefaultRegistry();
        if (this.nameResolverProvider != null) {
            nameResolverRegistry.deregister(this.nameResolverProvider);
        }
        if (this.loadBalancingServers != null && !this.loadBalancingServers.isEmpty()) {
            this.nameResolverProvider = new BootLoadBalancerProvider(this.loadBalancingTargetScheme, ++priority, this.loadBalancingServers);
            nameResolverRegistry.register(this.nameResolverProvider);
        }
        this.channelBuilder = GRPCClientConfig.initNettyChannelBuilder(this.nameResolverProvider, this.loadBalancingPolicy, this.uri, this.kmf, this.tmf, this.overrideAuthority, this.ciphers, this.sslProtocols);
        this.configNettyChannelBuilder(this.channelBuilder);
        for (GRPCClient listener : this.listeners) {
            listener.updateChannelBuilder(this.channelBuilder);
        }
    }

    protected void configNettyChannelBuilder(NettyChannelBuilder nettyChannelBuilder) {
        if (this.userAgent != null) {
            nettyChannelBuilder.userAgent(this.userAgent);
        }
        if (this.maxInboundMessageSize != null) {
            nettyChannelBuilder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        if (this.maxHeaderListSize != null) {
            nettyChannelBuilder.maxInboundMetadataSize(this.maxHeaderListSize.intValue());
        }
        if (this.perRpcBufferLimit != null) {
            nettyChannelBuilder.perRpcBufferLimit(this.perRpcBufferLimit.longValue());
        }
        if (this.maxHedgedAttempts != null) {
            nettyChannelBuilder.maxHedgedAttempts(this.maxHedgedAttempts.intValue());
        }
        if (this.idleTimeoutSeconds != null) {
            nettyChannelBuilder.idleTimeout(this.idleTimeoutSeconds.longValue(), TimeUnit.SECONDS);
        }
        if (this.keepAliveWithoutCalls != null) {
            nettyChannelBuilder.keepAliveWithoutCalls(this.keepAliveWithoutCalls.booleanValue());
        }
        if (this.keepAliveTimeSeconds != null) {
            nettyChannelBuilder.keepAliveTime(this.keepAliveTimeSeconds.longValue(), TimeUnit.SECONDS);
        }
        if (this.keepAliveTimeoutSeconds != null) {
            nettyChannelBuilder.keepAliveTimeout(this.keepAliveTimeoutSeconds.longValue(), TimeUnit.SECONDS);
        }
        if (this.retryEnabled != null) {
            if (this.retryEnabled.booleanValue()) {
                nettyChannelBuilder.enableRetry();
                if (this.maxRetryAttempts != null) {
                    nettyChannelBuilder.maxRetryAttempts(this.maxRetryAttempts.intValue());
                }
                if (this.retryBufferSize != null) {
                    nettyChannelBuilder.retryBufferSize(this.retryBufferSize.longValue());
                }
            } else {
                nettyChannelBuilder.disableRetry();
            }
        }
    }

    @Override
    public void shutdown() {
    }

    public void addConfigUpdateListener(GRPCClient listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeConfigUpdateListener(GRPCClient listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public static NettyChannelBuilder initNettyChannelBuilder(NameResolverProvider nameResolverProvider, LoadBalancingPolicy loadBalancingPolicy, URI uri, @Nullable KeyManagerFactory keyManagerFactory, @Nullable TrustManagerFactory trustManagerFactory, @Nullable String overrideAuthority, @Nullable Iterable<String> ciphers, String ... tlsVersionProtocols) throws SSLException {
        NettyChannelBuilder channelBuilder;
        if (nameResolverProvider != null) {
            Object nameResolverRegistry = NameResolverRegistry.getDefaultRegistry();
            nameResolverRegistry.register(nameResolverProvider);
            String policy = loadBalancingPolicy.getValue();
            String target = nameResolverProvider.getDefaultScheme() + ":///";
            channelBuilder = (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)target).defaultLoadBalancingPolicy(policy);
        } else {
            switch (uri.getScheme()) {
                case "unix": {
                    channelBuilder = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(uri.getPath())).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class);
                    break;
                }
                default: {
                    String host = uri.getHost();
                    int port = uri.getPort();
                    if (host == null) {
                        throw new IllegalArgumentException("The URI format should contains host information, like <scheme>://[host:port]/[service], like grpc:///, grpc://host:port, grpcs://host:port, or unix:///path/to/uds.sock. gRpc.client.LoadBalancing.servers should be provided when host/port are not provided.");
                    }
                    channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
                }
            }
        }
        if (keyManagerFactory == null) {
            channelBuilder.usePlaintext();
        } else {
            SslContextBuilder sslBuilder = GrpcSslContexts.forClient();
            sslBuilder.keyManager(keyManagerFactory);
            if (trustManagerFactory == null) {
                sslBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else {
                sslBuilder.trustManager(trustManagerFactory);
                if (overrideAuthority != null) {
                    channelBuilder.overrideAuthority(overrideAuthority);
                }
            }
            GrpcSslContexts.configure((SslContextBuilder)sslBuilder, (SslProvider)SslProvider.OPENSSL);
            if (tlsVersionProtocols != null) {
                sslBuilder.protocols(tlsVersionProtocols);
            }
            if (ciphers != null) {
                sslBuilder.ciphers(ciphers);
            }
            SslContext sslContext = sslBuilder.build();
            channelBuilder.sslContext(sslContext).useTransportSecurity();
        }
        return channelBuilder;
    }

    public List<InetSocketAddress> getLoadBalancingServers() {
        return this.loadBalancingServers;
    }

    public LoadBalancingPolicy getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public NameResolverProvider getNameResolverProvider() {
        return this.nameResolverProvider;
    }

    public URI getUri() {
        return this.uri;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public List getCiphers() {
        return this.ciphers;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public String getOverrideAuthority() {
        return this.overrideAuthority;
    }

    public NettyChannelBuilder getChannelBuilder() {
        return this.channelBuilder;
    }

    public static enum LoadBalancingPolicy {
        ROUND_ROBIN("round_robin"),
        PICK_FIRST("pick_first");

        private final String value;

        private LoadBalancingPolicy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

