/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.Grpc;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.config.NamedDefaultThreadFactory;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.nio.grpc.GRPCServiceCounter;

public class GRPCServer {
    protected static final Logger log = LogManager.getLogger((String)GRPCServer.class.getName());
    protected final String bindingAddr;
    protected final int port;
    protected final ServerCredentials serverCredentials;
    protected final ServerBuilder serverBuilder;
    protected Server server = null;
    protected ScheduledExecutorService statusReporter = null;
    protected final GRPCServiceCounter serviceCounter = new GRPCServiceCounter();

    public ServerBuilder getServerBuilder() {
        return this.serverBuilder;
    }

    public GRPCServiceCounter getServiceCounter() {
        return this.serviceCounter;
    }

    public GRPCServer(String bindingAddr, int port, KeyManagerFactory kmf, TrustManagerFactory tmf, ServerInterceptor serverInterceptor, ThreadPoolExecutor tpe, boolean useVirtualThread, NIOStatusListener nioListener) {
        this.bindingAddr = bindingAddr;
        this.port = port;
        this.serverCredentials = this.initTLS(kmf, tmf);
        this.serverBuilder = this.serverCredentials == null ? NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(bindingAddr, port)) : Grpc.newServerBuilderForPort((int)port, (ServerCredentials)this.serverCredentials);
        if (serverInterceptor != null) {
            this.serverBuilder.intercept(serverInterceptor);
        }
        this.serverBuilder.executor((Executor)tpe);
        this.initThreadPool(tpe, useVirtualThread, nioListener, bindingAddr, port);
    }

    protected ServerCredentials initTLS(KeyManagerFactory kmf, TrustManagerFactory tmf) {
        if (kmf == null) {
            return null;
        }
        TlsServerCredentials.Builder tlsBuilder = TlsServerCredentials.newBuilder().keyManager(kmf.getKeyManagers());
        if (tmf != null) {
            tlsBuilder.trustManager(tmf.getTrustManagers());
            tlsBuilder.clientAuth(TlsServerCredentials.ClientAuth.REQUIRE);
        }
        return tlsBuilder.build();
    }

    protected GRPCServiceCounter initThreadPool(ThreadPoolExecutor tpe, boolean useVirtualThread, NIOStatusListener nioListener, String bindingAddr, int port) {
        int interval = 1;
        AtomicReference<Long> lastBizHitRef = new AtomicReference<Long>();
        lastBizHitRef.set(-1L);
        long totalChannel = -1L;
        long activeChannel = -1L;
        ScheduledExecutorService old2 = this.statusReporter;
        this.statusReporter = Executors.newSingleThreadScheduledExecutor(NamedDefaultThreadFactory.build("Netty-gRPC.QPS_SERVICE@" + bindingAddr + ":" + port, useVirtualThread));
        AtomicLong lastChecksum = new AtomicLong(0L);
        String appInfo = "gRPC@jExpress 2.5.0 " + BootConstant.PID;
        this.statusReporter.scheduleAtFixedRate(() -> {
            if (nioListener == null && !log.isDebugEnabled()) {
                return;
            }
            long bizHit = this.serviceCounter.getBiz();
            lastBizHitRef.set(bizHit);
            long hps = this.serviceCounter.getHitAndReset();
            long tps = this.serviceCounter.getProcessedAndReset();
            long pingHit = this.serviceCounter.getPing();
            long totalHit = bizHit + pingHit;
            int active = tpe.getActiveCount();
            int queue = tpe.getQueue().size();
            long pool = tpe.getPoolSize();
            int core = tpe.getCorePoolSize();
            long max = tpe.getMaximumPoolSize();
            long largest = tpe.getLargestPoolSize();
            long task = tpe.getTaskCount();
            long completed = tpe.getCompletedTaskCount();
            long checksum = hps + tps + (long)active + (long)queue + bizHit + task + completed + (long)active + pool + (long)core + max + largest;
            if (lastChecksum.get() != checksum) {
                lastChecksum.set(checksum);
                log.debug(() -> "hps=" + hps + ", tps=" + tps + ", totalHit=" + totalHit + " (ping" + pingHit + " + biz" + bizHit + "), task=" + task + ", completed=" + completed + ", queue=" + queue + ", active=" + active + ", pool=" + pool + ", core=" + core + ", max=" + max + ", largest=" + largest);
                if (nioListener != null) {
                    nioListener.onNIOAccessReportUpdate(appInfo, hps, tps, totalHit, pingHit, bizHit, totalChannel, activeChannel, task, completed, queue, active, pool, core, max, largest);
                }
            }
        }, 0L, interval, TimeUnit.SECONDS);
        if (old2 != null) {
            old2.shutdownNow();
        }
        return this.serviceCounter;
    }

    public void start(StringBuilder memo) throws IOException {
        this.start(false, memo);
    }

    public void start(boolean isBlockingMode, StringBuilder memo) throws IOException {
        if (this.server != null) {
            this.shutdown();
        }
        String appInfo = "jExpress 2.5.0 " + BootConstant.PID;
        this.server = this.serverBuilder.build().start();
        String schema = this.serverCredentials == null ? "grpc" : "grpcs";
        String info2 = "Netty GRPC server [" + appInfo + "] is listening on " + schema + "://" + this.bindingAddr + ":" + this.port;
        memo.append(BootConstant.BR).append(info2);
        log.info(info2);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown(), "GRPCServer.shutdown and stop listening on " + schema + "://" + this.bindingAddr + ":" + this.port));
        if (isBlockingMode) {
            try {
                this.server.awaitTermination();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void shutdown() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.shutdown();
            if (this.statusReporter != null) {
                this.statusReporter.shutdown();
            }
            log.warn("*** GRPCServer shutdown " + this.bindingAddr + ":" + this.port);
            this.server.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            System.err.println("GRPCServer shutdown timeout " + this.bindingAddr + ":" + this.port);
        }
        finally {
            this.server = null;
        }
    }
}

