/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpTimeoutException;
import java.nio.channels.UnresolvedAddressException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.naming.NamingException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.boot.event.HttpExceptionListener;
import org.summerboot.jexpress.boot.event.HttpLifecycleListener;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.server.NioServerHttpRequestHandler;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.security.auth.Authenticator;

@Singleton
@ChannelHandler.Sharable
public class BootHttpRequestHandler
extends NioServerHttpRequestHandler {
    @Inject
    protected Authenticator authenticator;
    @Inject
    protected AuthTokenCache authTokenCache;
    @Inject
    protected HttpLifecycleListener httpLifecycleListener;
    @Inject
    protected HttpExceptionListener httpExceptionListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ProcessorSettings service(ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        Throwable processException;
        Object processResult;
        boolean preProcessResult;
        RequestProcessor processor;
        ProcessorSettings processorSettings;
        block39: {
            ProcessorSettings processorSettings2;
            block38: {
                ProcessorSettings processorSettings3;
                block37: {
                    ProcessorSettings processorSettings4;
                    block36: {
                        ProcessorSettings processorSettings5;
                        block35: {
                            processorSettings = null;
                            processor = null;
                            preProcessResult = false;
                            processResult = null;
                            processException = null;
                            try {
                                processor = this.getRequestProcessor(httptMethod, httpRequestPath);
                                if (processor == null && (processor = this.getRequestProcessor(httptMethod, "")) == null) {
                                    this.httpExceptionListener.onActionNotFound(ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                                    ProcessorSettings processorSettings6 = processorSettings;
                                    return processorSettings6;
                                }
                                processorSettings = processor.getProcessorSettings();
                                ProcessorSettings.LogSettings logSettings = processorSettings.getLogSettings();
                                if (logSettings != null) {
                                    context.logRequestHeader(logSettings.isLogRequestHeader());
                                    context.logRequestBody(logSettings.isLogRequestBody());
                                    context.logResponseHeader(logSettings.isLogResponseHeader());
                                    context.logResponseBody(logSettings.isLogResponseBody());
                                }
                                if (processor.isRoleBased()) {
                                    context.poi("auth.begin");
                                    if (!this.authenticationCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                                        context.status(HttpResponseStatus.UNAUTHORIZED);
                                        processorSettings5 = processorSettings;
                                        this.httpLifecycleListener.afterProcess(preProcessResult, processResult, processException, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                                        break block35;
                                    }
                                    if (!processor.authorizationCheck(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context, BootErrorCode.AUTH_NO_PERMISSION)) {
                                        context.status(HttpResponseStatus.FORBIDDEN);
                                        processorSettings4 = processorSettings;
                                        this.httpLifecycleListener.afterProcess(preProcessResult, processResult, processException, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                                        break block36;
                                    }
                                }
                                context.poi("process.begin");
                                if (this.authenticator != null && !this.authenticator.customizedAuthorizationCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                                    processorSettings3 = processorSettings;
                                    this.httpLifecycleListener.afterProcess(preProcessResult, processResult, processException, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                                    break block37;
                                }
                                preProcessResult = this.httpLifecycleListener.beforeProcess(processor, httpRequestHeaders, httpRequestPath, context);
                                if (!preProcessResult) {
                                    processorSettings2 = processorSettings;
                                    this.httpLifecycleListener.afterProcess(preProcessResult, processResult, processException, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                                    break block38;
                                }
                                processResult = processor.process(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context);
                                this.httpLifecycleListener.afterProcess(preProcessResult, processResult, processException, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                                break block39;
                            }
                            catch (NamingException ex) {
                                processException = ex;
                                this.httpExceptionListener.onNamingException(ex, httptMethod, httpRequestPath, context);
                                return processorSettings;
                            }
                            catch (PersistenceException ex) {
                                processException = ex;
                                this.httpExceptionListener.onPersistenceException(ex, httptMethod, httpRequestPath, context);
                                return processorSettings;
                            }
                            catch (HttpConnectTimeoutException ex) {
                                processException = ex;
                                this.httpExceptionListener.onHttpConnectTimeoutException(ex, httptMethod, httpRequestPath, context);
                                return processorSettings;
                            }
                            catch (HttpTimeoutException ex) {
                                processException = ex;
                                this.httpExceptionListener.onHttpTimeoutException(ex, httptMethod, httpRequestPath, context);
                                return processorSettings;
                            }
                            catch (RejectedExecutionException ex) {
                                processException = ex;
                                this.httpExceptionListener.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
                                return processorSettings;
                            }
                            catch (ConnectException ex) {
                                processException = ex;
                                this.httpExceptionListener.onConnectException(ex, httptMethod, httpRequestPath, context);
                                return processorSettings;
                            }
                            catch (IOException | UnresolvedAddressException ex) {
                                processException = ex;
                                Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                                if (cause == null) {
                                    cause = ex;
                                }
                                if (cause instanceof RejectedExecutionException) {
                                    this.httpExceptionListener.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
                                    return processorSettings;
                                }
                                this.httpExceptionListener.onIOException(ex, httptMethod, httpRequestPath, context);
                                return processorSettings;
                            }
                            catch (InterruptedException ex) {
                                processException = ex;
                                this.httpExceptionListener.onInterruptedException(ex, httptMethod, httpRequestPath, context);
                                return processorSettings;
                            }
                            catch (Throwable ex) {
                                processException = ex;
                                this.httpExceptionListener.onUnexpectedException(ex, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                                return processorSettings;
                            }
                        }
                        context.poi("process.end");
                        return processorSettings5;
                    }
                    context.poi("process.end");
                    return processorSettings4;
                }
                context.poi("process.end");
                return processorSettings3;
            }
            context.poi("process.end");
            return processorSettings2;
        }
        context.poi("process.end");
        return processorSettings;
        finally {
            this.httpLifecycleListener.afterProcess(preProcessResult, processResult, processException, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
            context.poi("process.end");
        }
    }

    @Override
    protected void afterService(HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        this.httpLifecycleListener.afterService(httpHeaders, httpMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
    }

    protected boolean authenticationCheck(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, ServiceContext context) throws Exception {
        if (this.authenticator == null) {
            return true;
        }
        this.authenticator.verifyToken(httpRequestHeaders, this.authTokenCache, null, context);
        return context.caller() != null;
    }

    @Override
    protected String beforeLogging(String originallLogContent, HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, Throwable ioEx) {
        return this.httpLifecycleListener.beforeLogging(originallLogContent, httpHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
    }

    @Override
    protected void afterLogging(String logContent, HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, Throwable ioEx) throws Exception {
        this.httpLifecycleListener.afterLogging(logContent, httpHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
    }

    @Override
    public String beforeSendingError(String errorContent) {
        return this.httpLifecycleListener.beforeSendingError(errorContent);
    }
}

