/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.security.auth.RoleMapping;
import org.summerboot.jexpress.util.BeanUtil;

public class User
implements Serializable,
Caller,
Comparable<User> {
    protected Long tenantId;
    protected String tenantName;
    protected Long id;
    protected String uid;
    protected String displayName;
    @JsonIgnore
    protected String password;
    protected int type = 1;
    protected boolean enabled = true;
    protected Long tokenTtlSec;
    protected Set<String> groups;
    protected Map<String, Object> customizedFields;

    public User(Long id, String uid) {
        this(null, null, id, uid);
    }

    public User(@JsonProperty(value="tenantId") Long tenantId, @JsonProperty(value="tenantName") String tenantName, @JsonProperty(value="id") Long id, @JsonProperty(value="uid") String uid) {
        this.tenantId = tenantId == null ? 0L : tenantId;
        this.tenantName = tenantName == null ? "0" : tenantName;
        this.id = id == null ? 0L : id;
        this.uid = uid == null ? "0" : uid;
        this.displayName = uid;
    }

    public String toString() {
        try {
            return BeanUtil.toJson(this, false, true);
        }
        catch (JsonProcessingException ex) {
            return "User{id=" + this.id + ", uid=" + this.uid + ", type=" + this.type + ", ex=" + String.valueOf((Object)ex) + "}";
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.tenantId);
        hash = 59 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (!Objects.equals(this.tenantId, other.tenantId)) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }

    @Override
    public int compareTo(User arg0) {
        Long tenantId2;
        if (arg0 == null) {
            return 1;
        }
        Long id2 = arg0.getId();
        if (this.id == null) {
            if (id2 == null) {
                return 0;
            }
            return -1;
        }
        if (id2 == null) {
            return 1;
        }
        Long tenantId1 = this.getTenantId();
        if (tenantId1 == null) {
            tenantId1 = 0L;
        }
        if ((tenantId2 = arg0.getTenantId()) == null) {
            tenantId2 = 0L;
        }
        if (!tenantId1.equals(tenantId2)) {
            return tenantId1.compareTo(tenantId2);
        }
        return this.id.compareTo(id2);
    }

    @Override
    public Long getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getTenantName() {
        return this.tenantName;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Long getTokenTtlSec() {
        return this.tokenTtlSec;
    }

    public void setTokenTtlSec(Long tokenTtlSec) {
        this.tokenTtlSec = tokenTtlSec;
    }

    public void addGroup(String group) {
        if (group == null) {
            return;
        }
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        this.groups.add(group);
    }

    @Override
    public boolean isInGroup(String group) {
        return this.groups != null && this.groups.contains(group);
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public boolean isInRole(String role) {
        RoleMapping rm = AuthConfig.cfg.getRole(role);
        if (rm == null) {
            return false;
        }
        if (rm.getUsers().contains(this.uid)) {
            return true;
        }
        return rm.getGroups().stream().anyMatch(group -> this.isInGroup((String)group));
    }

    public void setCustomizedFields(Map<String, Object> customizedFields) {
        this.customizedFields = customizedFields;
    }

    public Map<String, Object> getCustomizedFields() {
        return this.customizedFields;
    }

    @Override
    public <T> T getCustomizedField(String key) {
        if (this.customizedFields == null || key == null) {
            return null;
        }
        return (T)this.customizedFields.get(key);
    }

    @Override
    public void setCustomizedField(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        if (this.customizedFields == null) {
            this.customizedFields = new HashMap<String, Object>();
        }
        this.customizedFields.put(key, value);
    }

    @Override
    public <T> T removeCustomizedField(String key) {
        if (this.customizedFields == null || key == null) {
            return null;
        }
        return (T)this.customizedFields.remove(key);
    }

    @Override
    public Set<String> customizedFieldKeys() {
        if (this.customizedFields == null) {
            return null;
        }
        return this.customizedFields.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> customizedFields() {
        if (this.customizedFields == null) {
            return null;
        }
        return this.customizedFields.entrySet();
    }
}

