/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PropertiesFile
extends Properties {
    private List<String> orderedKeys = new ArrayList<String>();

    public List<String> keyList() {
        return this.orderedKeys;
    }

    public List<ImmutablePair<String, String>> load(File propertiesFile) throws IOException {
        try (FileInputStream is = new FileInputStream(propertiesFile);
             InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
            super.load(isr);
        }
        ArrayList<ImmutablePair<String, String>> pairs = new ArrayList<ImmutablePair<String, String>>();
        for (String key : this.orderedKeys) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)key, (Object)super.getProperty(key)));
        }
        return pairs;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        String keyStr = key instanceof String ? (String)key : key.toString();
        this.orderedKeys.add(keyStr);
        return super.put(key, value);
    }

    @Override
    public synchronized void clear() {
        this.orderedKeys.clear();
        super.clear();
    }
}

