/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.annotation.Unique;

@Unique(name="SystemErrorCode", type=int.class)
public interface BootErrorCode {
    public static final int OK = BootErrorCode.getErrorCode(0);
    public static final int NIO_BASE = BootErrorCode.getErrorCode(1);
    public static final int NIO_TOO_MANY_REQUESTS = BootErrorCode.getErrorCode(NIO_BASE + 1);
    public static final int NIO_UNEXPECTED_EXECUTOR_FAILURE = BootErrorCode.getErrorCode(NIO_BASE + 2);
    public static final int NIO_UNEXPECTED_SERVICE_FAILURE = BootErrorCode.getErrorCode(NIO_BASE + 3);
    public static final int NIO_UNEXPECTED_PROCESSOR_FAILURE = BootErrorCode.getErrorCode(NIO_BASE + 4);
    public static final int NIO_FILE_UPLOAD_BAD_REQUEST = BootErrorCode.getErrorCode(NIO_BASE + 5);
    public static final int NIO_FILE_UPLOAD_BAD_LENGTH = BootErrorCode.getErrorCode(NIO_BASE + 6);
    public static final int NIO_FILE_UPLOAD_EXCEED_SIZE_LIMIT = BootErrorCode.getErrorCode(NIO_BASE + 7);
    public static final int NIO_REQUEST_BAD_HEADER = BootErrorCode.getErrorCode(NIO_BASE + 8);
    public static final int BAD_REQUEST_DATA = BootErrorCode.getErrorCode(NIO_BASE + 9);
    public static final int NIO_REQUEST_BAD_ENCODING = BootErrorCode.getErrorCode(NIO_BASE + 10);
    public static final int NIO_REQUEST_BAD_DOWNLOAD = BootErrorCode.getErrorCode(NIO_BASE + 11);
    public static final int SERVICE_UNAVAILABLE = BootErrorCode.getErrorCode(NIO_BASE + 12);
    public static final int SERVICE_HEALTH_CHECK_FAILED = BootErrorCode.getErrorCode(NIO_BASE + 13);
    public static final int SERVICE_PAUSED = BootErrorCode.getErrorCode(NIO_BASE + 14);
    public static final int IO_BASE = BootErrorCode.getErrorCode(20);
    public static final int APP_INTERRUPTED = BootErrorCode.getErrorCode(IO_BASE + 1);
    public static final int HTTP_REQUEST_TIMEOUT = BootErrorCode.getErrorCode(IO_BASE + 2);
    public static final int HTTPCLIENT_TOO_MANY_CONNECTIONS_REJECT = BootErrorCode.getErrorCode(IO_BASE + 3);
    public static final int HTTP_CONNECTION_TIMEOUT = BootErrorCode.getErrorCode(IO_BASE + 4);
    public static final int HTTPCLIENT_UNKNOWN_RESPONSE_FORMAT = BootErrorCode.getErrorCode(IO_BASE + 5);
    public static final int HTTPCLIENT_INVALID_RESPONSE_FORMAT = BootErrorCode.getErrorCode(IO_BASE + 6);
    public static final int NETWORK_ERROR = BootErrorCode.getErrorCode(IO_BASE + 7);
    public static final int FILE_NOT_ACCESSABLE = BootErrorCode.getErrorCode(IO_BASE + 8);
    public static final int FILE_NOT_FOUND = BootErrorCode.getErrorCode(IO_BASE + 9);
    public static final int AUTH_BASE = BootErrorCode.getErrorCode(40);
    public static final int AUTH_REQUIRE_TOKEN = BootErrorCode.getErrorCode(AUTH_BASE + 1);
    public static final int AUTH_INVALID_TOKEN = BootErrorCode.getErrorCode(AUTH_BASE + 2);
    public static final int AUTH_EXPIRED_TOKEN = BootErrorCode.getErrorCode(AUTH_BASE + 3);
    public static final int AUTH_INVALID_URL = BootErrorCode.getErrorCode(AUTH_BASE + 4);
    public static final int AUTH_LOGIN_FAILED = BootErrorCode.getErrorCode(AUTH_BASE + 5);
    public static final int AUTH_NO_PERMISSION = BootErrorCode.getErrorCode(AUTH_BASE + 6);
    public static final int AUTH_INVALID_IP = BootErrorCode.getErrorCode(AUTH_BASE + 7);
    public static final int ACCESS_BASE = BootErrorCode.getErrorCode(50);
    public static final int ACCESS_ERROR_CACHE = BootErrorCode.getErrorCode(ACCESS_BASE + 1);
    public static final int ACCESS_ERROR_LDAP = BootErrorCode.getErrorCode(ACCESS_BASE + 2);
    public static final int ACCESS_ERROR_SMTP = BootErrorCode.getErrorCode(ACCESS_BASE + 3);
    public static final int ACCESS_ERROR_DATABASE = BootErrorCode.getErrorCode(ACCESS_BASE + 4);
    public static final int ACCESS_ERROR_RPC = BootErrorCode.getErrorCode(ACCESS_BASE + 5);
    public static final int BR_BASE = BootErrorCode.getErrorCode(60);
    public static final int BAD_REQUEST_UNKNOWN_JSON_REQUEST_BODY = BootErrorCode.getErrorCode(BR_BASE + 1);
    public static final int BAD_REQUEST_UNKNOWN_XML_REQUEST_BODY = BootErrorCode.getErrorCode(BR_BASE + 2);
    public static final int BAD_REQUEST_MISSING_JSON_REQUEST_BODY = BootErrorCode.getErrorCode(BR_BASE + 3);
    public static final int BAD_REQUEST_MISSING_REQUEST_BODY = BootErrorCode.getErrorCode(BR_BASE + 4);
    public static final int BAD_REQUEST_MISSING_XML_REQUEST_BODY = BootErrorCode.getErrorCode(BR_BASE + 5);
    public static final int BAD_REQUEST_INVALID_JSON_REQUEST_BODY = BootErrorCode.getErrorCode(BR_BASE + 6);
    public static final int BAD_REQUEST_INVALID_XML_REQUEST_BODY = BootErrorCode.getErrorCode(BR_BASE + 7);
    public static final int BAD_REQUEST_INVALID_REQUEST_BODY = BootErrorCode.getErrorCode(BR_BASE + 8);
    public static final int BAD_REQUEST_MISSING_REQUIRED_FILED = BootErrorCode.getErrorCode(BR_BASE + 9);
    public static final int RTO_CLS_EXIT = BootErrorCode.getErrorCode(80);
    public static final int RTO_CLI_PARSER_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 1);
    public static final int RTO_CLI_MISSING_ARG_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 2);
    public static final int RTO_CLI_INVALID_ARG_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 3);
    public static final int RTO_CLI_INVALID_ALTERNATIVE_NAME_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 4);
    public static final int RTO_CFG_BOOT_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 5);
    public static final int RTO_CFG_LOADING_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 6);
    public static final int RTO_CFG_DIR_ACCESS_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 7);
    public static final int RTO_CFG_GENERATE_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 8);
    public static final int RTO_CREATE_IF_NOT_EXIST_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 9);
    public static final int RTO_PLUGIN_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 10);
    public static final int RTO_CODE_ERROR_HM = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 11);
    public static final int RTO_CODE_ERROR_UNIQUE = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 12);
    public static final int RTO_CODING_ERROR_SERVICE_IOC = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 13);
    public static final int RTO_CODING_ERROR_PROCESSOR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 14);
    public static final int RTO_UNKNOWN_HOST_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 15);
    public static final int RTO_BINDING_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 16);
    public static final int RTO_UNKNOWN_ERROR = BootErrorCode.getErrorCode(RTO_CLS_EXIT + 17);

    private static int getErrorCode(int code) {
        Map<Integer, Integer> errorCodeMapping = BackOffice.agent.getBootErrorCodeMapping();
        if (errorCodeMapping == null) {
            return code;
        }
        Integer ret = errorCodeMapping.get(code);
        return ret == null ? code : ret;
    }

    public static interface CustomHttpStatus {
        public static final HttpResponseStatus UNAVAILABLE_FOR_LEGAL_REASONS = HttpResponseStatus.valueOf((int)451, (String)"Unavailable For Legal Reasons");
        public static final HttpResponseStatus ABP_POSSIBLE_REJECTION = HttpResponseStatus.valueOf((int)520, (String)"ABP Possible rejection");
    }
}

