/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.util.Properties;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.security.EncryptorUtil;

class MasterPassword
extends BootConfig {
    public static final MasterPassword cfg = new MasterPassword();
    @ConfigHeader(title="To protect configuration via Bse64 encoded Master Password in a file:", desc="\n  1. Copy this file to a secure location and change the password, e.g. /etc/security/master.password\n  2. Make it only accessible by OS admin but not application admin nor other users\n  3. To start the app: java -jar <app>.jar -authfile <path to this file> [-dmain <domain>]\n\n", format="Base64 Encoded", example="java -jar jExpressApp.jar -authfile /etc/security/master.password")
    @Config(key="APP_ROOT_PASSWORD", predefinedValue="Y2hhbmdlaXQ=", required=true)
    @JsonIgnore
    private volatile String base64EncodedAdminPwd;
    @JsonIgnore
    private volatile String masterPassword;

    public static void main(String[] args) {
        String t = MasterPassword.generateTemplate(MasterPassword.class);
        System.out.println(t);
    }

    protected MasterPassword() {
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        this.masterPassword = EncryptorUtil.base64Decode(this.base64EncodedAdminPwd);
    }

    @Override
    public void shutdown() {
    }

    String getMasterPassword() {
        return this.masterPassword;
    }
}

