/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import java.io.File;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.filter.LevelRangeFilter;
import org.quartz.SchedulerException;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.boot.SummerBigBang;
import org.summerboot.jexpress.boot.SummerRunner;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.event.AppLifecycleListener;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.boot.instrumentation.Timeout;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.integration.quartz.QuartzUtil;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.nio.grpc.GRPCServer;
import org.summerboot.jexpress.nio.grpc.GRPCServerConfig;
import org.summerboot.jexpress.nio.server.NioChannelInitializer;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioServer;
import org.summerboot.jexpress.util.ApplicationUtil;

public abstract class SummerApplication
extends SummerBigBang {
    @Inject
    protected InstrumentationMgr instrumentationMgr;
    protected NioServer httpServer;
    protected List<GRPCServer> gRPCServerList = new ArrayList<GRPCServer>();
    @Inject
    protected PostOffice postOffice;
    @Inject
    protected AppLifecycleListener appLifecycleListener;
    protected boolean memoLogged = false;

    private SummerApplication(Class callerClass, Module userOverrideModule, String ... args) {
        super(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run() {
        Module userOverrideModule = null;
        return SummerApplication.run(userOverrideModule);
    }

    public static void run(Class callerClass, String[] args) {
        Module userOverrideModule = null;
        SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Module userOverrideModule) {
        StackTraceElement[] stackTrace;
        String[] mainCommand = ApplicationUtil.getApplicationArgs();
        int size = mainCommand.length;
        String[] args = size > 0 ? new String[size - 1] : ApplicationUtil.EMPTY_ARGS;
        String mainClassName = mainCommand[0];
        System.arraycopy(mainCommand, 1, args, 0, size - 1);
        Class<?> callerClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                callerClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            try {
                callerClass = Class.forName(mainClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            throw new RuntimeException("Failed to find the caller class");
        }
        return SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(String[] args) {
        Module userOverrideModule = null;
        return SummerApplication.run(userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Module userOverrideModule, String[] args) {
        StackTraceElement[] stackTrace;
        Class<?> callerClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                callerClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            throw new RuntimeException("Failed to find the caller class");
        }
        return SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Class callerClass, Module userOverrideModule, String argsStr) {
        String[] args = argsStr.split(" ");
        return SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Class callerClass, Module userOverrideModule, String[] args) {
        SummerApplication app = new SummerApplication(callerClass, userOverrideModule, args){};
        app.start();
        return (T)app;
    }

    public static <T extends SummerApplication> T unittest(Class callerClass, Module userOverrideModule, String argsStr) {
        String[] args = argsStr.split(" ");
        return SummerApplication.unittest(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T unittest(Class callerClass, Module userOverrideModule, String ... args) {
        SummerApplication app = new SummerApplication(callerClass, userOverrideModule, args){};
        app.traceConfig();
        return (T)app;
    }

    public List<GRPCServer> getgRPCServers() {
        return this.gRPCServerList;
    }

    @Override
    protected Class getAddtionalI18n() {
        return null;
    }

    protected void traceConfig() {
        log.trace("");
        if (!this.memoLogged) {
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_LOGID).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_LOGID));
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_LOGFILEPATH).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_LOGFILEPATH));
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_LOGFILENAME).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_LOGFILENAME));
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_SERVER_NAME).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_SERVER_NAME));
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_APP_PACKAGE_NAME).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_APP_PACKAGE_NAME));
            this.memo.append(BootConstant.BR).append("\t- start: PostOffice=").append(this.postOffice.getClass().getName());
            this.memo.append(BootConstant.BR).append("\t- start: InstrumentationMgr=").append(this.instrumentationMgr.getClass().getName());
            this.memoLogged = true;
        }
        log.trace(() -> this.memo.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        log.trace("");
        this.traceConfig();
        if (this.appLifecycleListener != null) {
            ConfigUtil.setConfigChangeListener(this.appLifecycleListener);
        }
        log.trace("1. init email");
        if (this.postOffice != null) {
            this.postOffice.setAppVersion(this.appVersion);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.appLifecycleListener != null) {
                    this.appLifecycleListener.onApplicationStop(this.appVersion);
                }
            }, "ShutdownHook.BootApp"));
        }
        if (this.appLifecycleListener != null) {
            HealthMonitor.setAppLifecycleListener(this.appLifecycleListener);
        }
        try {
            log.trace("2. initialize JMX instrumentation");
            if (this.instrumentationMgr != null) {
                this.instrumentationMgr.start("jExpress 2.6.0");
            }
            log.trace("3a. runner.run");
            SummerRunner.RunnerContext context = new SummerRunner.RunnerContext(this.cli, this.userSpecifiedConfigDir, this.guiceInjector, this.postOffice);
            for (SummerRunner summerRunner : this.summerRunners) {
                summerRunner.run(context);
            }
            log.trace("3b. start scheduler");
            if (this.schedulerTriggers > 0) {
                this.scheduler.start();
                StringBuilder sb = new StringBuilder();
                sb.append("Scheduled jobs next fire time by ").append(this.schedulerTriggers).append(" triggers: ");
                QuartzUtil.getNextFireTimes(this.scheduler, sb);
                log.info(() -> sb.toString());
            }
            log.trace("4. health inspection");
            String serviceStatus = HealthMonitor.start(true, this.guiceInjector);
            long timeoutMs = BackOffice.agent.getProcessTimeoutMilliseconds();
            String timeoutDesc = BackOffice.agent.getProcessTimeoutAlertMessage();
            StringBuilder startingMemo = new StringBuilder();
            if (this.hasGRPCImpl) {
                log.trace("5a. start server: gRPC hasGRPCImpl.bs={}", (Object)this.gRPCBindableServiceImplClasses);
                log.trace("5a. start server: gRPC hasGRPCImpl.ssd={}", (Object)this.gRPCServerServiceDefinitionImplClasses);
                ServerInterceptor serverInterceptor = (ServerInterceptor)this.guiceInjector.getInstance(ServerInterceptor.class);
                GRPCServerConfig gRPCCfg = GRPCServerConfig.cfg;
                List<InetSocketAddress> bindingAddresses = gRPCCfg.getBindingAddresses();
                NIOStatusListener nioListener = (NIOStatusListener)this.guiceInjector.getInstance(NIOStatusListener.class);
                boolean doReport = true;
                for (InetSocketAddress bindingAddress : bindingAddresses) {
                    String host = bindingAddress.getAddress().getHostAddress();
                    int port = bindingAddress.getPort();
                    log.trace("5a. binding gRPC on {}:{}", (Object)host, (Object)port);
                    try (Timeout a = Timeout.watch("starting gRPCServer at " + host + ":" + port, timeoutMs).withDesc(timeoutDesc);){
                        BindableService impl;
                        boolean useVirtualThread = gRPCCfg.getTpeThreadingMode().equals((Object)BootConfig.ThreadingMode.VirtualThread);
                        GRPCServer gRPCServer = new GRPCServer(host, port, gRPCCfg.getKmf(), gRPCCfg.getTmf(), gRPCCfg.getTpe(), useVirtualThread, doReport, nioListener, serverInterceptor);
                        doReport = false;
                        ServerBuilder serverBuilder = gRPCServer.getServerBuilder();
                        for (Class c : this.gRPCBindableServiceImplClasses) {
                            impl = (BindableService)this.guiceInjector.getInstance(c);
                            serverBuilder.addService(impl);
                        }
                        for (Class c : this.gRPCServerServiceDefinitionImplClasses) {
                            impl = (ServerServiceDefinition)this.guiceInjector.getInstance(c);
                            serverBuilder.addService((ServerServiceDefinition)impl);
                        }
                        if (gRPCCfg.isAutoStart()) {
                            gRPCServer.start(startingMemo);
                        }
                        this.gRPCServerList.add(gRPCServer);
                    }
                }
            }
            log.trace("5b. start server: HTTP hasControllers={}", (Object)this.hasControllers);
            if (this.hasControllers && NioConfig.cfg.isAutoStart()) {
                try (Timeout a = Timeout.watch("starting Web Server", timeoutMs).withDesc(timeoutDesc);){
                    NioChannelInitializer channelInitializer = (NioChannelInitializer)((Object)this.guiceInjector.getInstance(NioChannelInitializer.class));
                    NIOStatusListener nioListener = (NIOStatusListener)this.guiceInjector.getInstance(NIOStatusListener.class);
                    this.httpServer = new NioServer(channelInitializer.init(this.guiceInjector, this.channelHandlerNames), nioListener);
                    this.httpServer.bind(NioConfig.cfg, startingMemo);
                }
            }
            startingMemo.append(BootConstant.BR).append(serviceStatus);
            startingMemo.append(BootConstant.BR).append("pid#" + BootConstant.PID);
            log.info(() -> BootConstant.BR + BootConstant.BR + I18n.info.launched.format(this.userSpecifiedResourceBundle, this.appVersion + " pid#" + BootConstant.PID) + serviceStatus);
            if (this.appLifecycleListener != null) {
                this.appLifecycleListener.onApplicationStart(this.appVersion, startingMemo.toString());
            }
        }
        catch (BindException ex) {
            log.fatal(String.valueOf(ex) + BootConstant.BR + BackOffice.agent.getPortInUseAlertMessage());
            ApplicationUtil.RTO(BootErrorCode.RTO_BINDING_ERROR, null, null);
        }
        catch (Throwable ex) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            if (cause instanceof BindException) {
                log.fatal(String.valueOf(ex) + BootConstant.BR + BackOffice.agent.getPortInUseAlertMessage());
            } else {
                log.fatal(I18n.info.unlaunched.format(this.userSpecifiedResourceBundle, new String[0]), ex);
            }
            ApplicationUtil.RTO(BootErrorCode.RTO_UNKNOWN_ERROR, null, null);
        }
        finally {
            String prompt = null;
            try {
                Logger c = (Logger)log;
                Map as = c.getContext().getConfiguration().getAppenders();
                int countConsoleAppender = 0;
                for (Map.Entry entry : as.entrySet()) {
                    LevelRangeFilter lrf;
                    Level maxLevel;
                    Appender appender = (Appender)entry.getValue();
                    if (!(appender instanceof ConsoleAppender)) continue;
                    if (++countConsoleAppender > 1) {
                        prompt = null;
                        break;
                    }
                    ConsoleAppender sa = (ConsoleAppender)appender;
                    Filter f = sa.getFilter();
                    if (!(f instanceof LevelRangeFilter) || Level.ALL.equals((Object)(maxLevel = (lrf = (LevelRangeFilter)f).getMaxLevel()))) continue;
                    prompt = "\nTo show logs in console, please edit " + String.valueOf(this.userSpecifiedConfigDir) + File.separator + "log4j2.xml \n\t<Configuration ...>\n\t  <Appenders>\n\t    <Console name=\"" + sa.getName() + "\" target=\"" + String.valueOf(sa.getTarget()) + "\">\n\t      <LevelRangeFilter maxLevel=\"" + String.valueOf(maxLevel) + "\"/>\n\tchange around line#13: set maxLevel=\"" + String.valueOf(Level.ALL) + "\"";
                }
            }
            catch (Throwable ex) {
                log.error("Failed to inspect " + String.valueOf(this.userSpecifiedConfigDir) + File.separator + "log4j2.xml", ex);
            }
            if (prompt != null) {
                System.out.println(prompt);
            }
        }
    }

    public void shutdown() {
        log.trace("");
        if (this.gRPCServerList != null && !this.gRPCServerList.isEmpty()) {
            for (GRPCServer gRPCServer : this.gRPCServerList) {
                gRPCServer.shutdown();
            }
        }
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
        if (this.instrumentationMgr != null) {
            this.instrumentationMgr.shutdown();
        }
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
            }
            catch (SchedulerException ex) {
                log.warn("Failed to shoutdown scheduler", (Throwable)ex);
            }
        }
    }
}

