/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;

public class ConfigurationMonitor
implements FileAlterationListener {
    protected static final Logger log = LogManager.getLogger((String)ConfigurationMonitor.class.getName());
    public static final ConfigurationMonitor cfgMonitor = new ConfigurationMonitor();
    protected volatile boolean running;
    protected Map<File, Runnable> cfgUpdateTasks;
    protected FileAlterationMonitor monitor;
    private static final String PAUSE_LOCK_CODE = BootConstant.PAUSE_LOCK_CODE_VIAFILE;
    private final Map<Path, FileTime> lastModifiedTimes = new HashMap<Path, FileTime>();
    private final Map<Path, Long> lastTriggeredTimes = new HashMap<Path, Long>();

    protected ConfigurationMonitor() {
    }

    public void start() throws Exception {
        if (this.monitor != null) {
            this.monitor.start();
        }
    }

    public void stop() throws Exception {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Path path = Paths.get("D:\\temp", new String[0]);
        cfgMonitor.start(path, 5000L, null);
    }

    public void start(Path folderPath, long throttleMillis, Map<File, Runnable> cfgUpdateTasks) throws IOException, InterruptedException {
        this.cfgUpdateTasks = cfgUpdateTasks;
        this.initPauseStatus(folderPath);
        WatchService watchService = FileSystems.getDefault().newWatchService();
        folderPath.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        Runnable configFolderWatcher = () -> {
            while (true) {
                WatchKey key = null;
                try {
                    key = watchService.take();
                }
                catch (InterruptedException ex) {
                    log.fatal("Failed to take configFolderWatcher@" + String.valueOf(folderPath), (Throwable)ex);
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path filePath = (Path)event.context();
                    File file = new File(folderPath.toString(), filePath.toString()).getAbsoluteFile();
                    Path fullPath = file.toPath();
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        if (!Files.isRegularFile(fullPath, new LinkOption[0])) continue;
                        try {
                            boolean isThrottled;
                            FileTime currentModTime = Files.getLastModifiedTime(fullPath, new LinkOption[0]);
                            FileTime lastTime = this.lastModifiedTimes.get(fullPath);
                            long now = System.currentTimeMillis();
                            Long lastTrigger = this.lastTriggeredTimes.getOrDefault(fullPath, 0L);
                            boolean isModified = lastTime == null || currentModTime.compareTo(lastTime) > 0;
                            boolean bl = isThrottled = now - lastTrigger < throttleMillis;
                            if (!isModified || isThrottled) continue;
                            this.lastModifiedTimes.put(fullPath, currentModTime);
                            this.lastTriggeredTimes.put(fullPath, now);
                            this.onFileChange(file);
                        }
                        catch (IOException ex) {
                            log.error("Failed to check modified time for: " + String.valueOf(fullPath), (Throwable)ex);
                        }
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        if (Files.isRegularFile(fullPath, new LinkOption[0])) {
                            this.onFileCreate(file);
                            continue;
                        }
                        if (!Files.isDirectory(fullPath, new LinkOption[0])) continue;
                        this.onDirectoryCreate(file);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    if (Files.isDirectory(fullPath, new LinkOption[0])) {
                        this.onDirectoryDelete(file);
                        continue;
                    }
                    this.onFileDelete(file);
                }
                boolean valid = key.reset();
                if (!valid) break;
            }
        };
        BackOffice.execute(configFolderWatcher);
    }

    protected void initPauseStatus(Path folderPath) {
        File folder = folderPath.toFile();
        File pauseFile = Paths.get(folder.getAbsolutePath(), BootConstant.FILE_PAUSE).toFile();
        boolean pause = pauseFile.exists();
        String cause = pause ? "File detected: " + pauseFile.getAbsolutePath() : "File not detected: " + pauseFile.getAbsolutePath();
        HealthMonitor.pauseService(pause, PAUSE_LOCK_CODE, cause);
    }

    private boolean isPauseFile(File file) {
        return BootConstant.FILE_PAUSE.equals(file.getName());
    }

    public void onStart(FileAlterationObserver fao) {
    }

    public void onStop(FileAlterationObserver fao) {
    }

    public void onDirectoryCreate(File file) {
        log.info(() -> "dir.new " + String.valueOf(file.getAbsoluteFile()));
    }

    public void onDirectoryChange(File file) {
    }

    public void onDirectoryDelete(File file) {
        log.info(() -> "dir.del " + String.valueOf(file.getAbsoluteFile()));
    }

    public void onFileCreate(File file) {
        if (!this.isPauseFile(file)) {
            return;
        }
        log.info(() -> "new " + String.valueOf(file.getAbsoluteFile()));
        HealthMonitor.pauseService(true, PAUSE_LOCK_CODE, "file created " + file.getAbsolutePath());
    }

    public void onFileDelete(File file) {
        if (!this.isPauseFile(file)) {
            return;
        }
        log.info(() -> "del " + String.valueOf(file.getAbsoluteFile()));
        HealthMonitor.pauseService(false, PAUSE_LOCK_CODE, "file deleted " + file.getAbsolutePath());
    }

    public void onFileChange(File file) {
        if (this.isPauseFile(file)) {
            return;
        }
        log.info(() -> "mod " + String.valueOf(file.getAbsoluteFile()));
        Runnable task = this.cfgUpdateTasks.get(file.getAbsoluteFile());
        if (task != null) {
            task.run();
        }
    }
}

