/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.cache;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.integration.cache.BootCache;
import org.summerboot.jexpress.integration.cache.JedisCall;
import org.summerboot.jexpress.integration.cache.RedisConfig;
import org.summerboot.jexpress.integration.cache.domain.FlashSale;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.params.SetParams;

@Singleton
public class BootCache_RedisImple
implements AuthTokenCache,
BootCache {
    protected static final String LUA_SCRIPT_UNLOCK = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    protected static final String LUA_SCRIPT_THROTTLE = "local key = KEYS[1]\nlocal initBurst = tonumber(ARGV[1])\nlocal maxBurstPerPeriod = tonumber(ARGV[2])\nlocal period = tonumber(ARGV[3])\nlocal quota = ARGV[4]\nreturn redis.call('CL.THROTTLE', key, initBurst, maxBurstPerPeriod, period, quota)";
    protected static final String LUA_SCRIPT_FLASHSALE = "local order = tonumber(ARGV[1])\nif not order or order < 1 then return 0 end\nlocal vals = redis.call(\"HMGET\", KEYS[1], \"Status\", \"Total\", \"Limit\", \"Booked\")\nlocal status = tonumber(vals[1])\nif not status or status < 1 then return 0 end\nlocal total = tonumber(vals[2])\nlocal limit = tonumber(vals[3])\nlocal booked = tonumber(vals[4])\nif not total or not limit or not booked then return 0 end\nif order <= limit and booked + order <= total then\n    redis.call(\"HINCRBY\", KEYS[1], \"Booked\", order)\n    return order\nend\nreturn 0";
    protected static final String REDIS_SUCCESS = "OK";
    protected static final Long RELEASE_SUCCESS = 1L;
    protected static final Logger log = LogManager.getLogger((String)BootCache_RedisImple.class.getName());
    protected static final ThreadPoolExecutor tpe = BootConfig.buildThreadPoolExecutor(null, "Redis", BootConfig.ThreadingMode.VirtualThread, 1, 1, 1, 60L, null, false, false, false);
    protected static final RuntimeException REDIS_MASTER_NULL_EX = new RuntimeException("Redis master is null");
    protected static RedisConfig redisCfg = RedisConfig.cfg;
    @Inject
    protected PostOffice po;

    protected void execute(JedisCall caller) {
        this.executeEx(caller, 0, 6);
    }

    protected void execute(boolean retry, JedisCall caller) {
        if (retry) {
            this.executeEx(caller, 0, 6);
        } else {
            this.executeEx(caller, 0, 0);
        }
    }

    protected void executeEx(JedisCall caller, int currentRetry, int maxRetry) {
        boolean success;
        block18: {
            success = false;
            try (Jedis jedis = redisCfg.getMaster();){
                if (jedis == null) {
                    this.onRedisDown(REDIS_MASTER_NULL_EX);
                    if (currentRetry >= maxRetry) {
                        return;
                    }
                } else {
                    caller.call(jedis);
                    success = true;
                }
            }
            catch (JedisConnectionException ex) {
                if (currentRetry == 2) {
                    this.onRedisDown(ex);
                }
                if (currentRetry >= maxRetry) {
                    throw ex;
                }
            }
            catch (JedisDataException ex) {
                if (currentRetry < maxRetry) break block18;
                throw ex;
            }
        }
        if (!success) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.executeEx(caller, ++currentRetry, maxRetry);
        }
    }

    protected void onRedisDown(Throwable ex) {
        Runnable asyncTask = () -> {
            String newNode;
            long lastAlertTs = 0L;
            do {
                Thread.currentThread().setPriority(10);
                newNode = redisCfg.autoFailover(ex);
                long elapsedMinutes = (System.currentTimeMillis() - lastAlertTs) / 60000L;
                if (elapsedMinutes >= (long)redisCfg.getSendAlertIntervalMinutes()) {
                    this.onNoticeRedisDown(redisCfg.info(), ex);
                    lastAlertTs = System.currentTimeMillis();
                }
                if (newNode != null) continue;
                try {
                    TimeUnit.MINUTES.sleep(redisCfg.getReconnectRetryIntervalMinutes());
                }
                catch (InterruptedException ex1) {
                    Thread.currentThread().interrupt();
                    log.warn("Redis.autoFailover failed to sleep", (Throwable)ex1);
                }
            } while (newNode == null);
            this.onNoticeAutoFailover(redisCfg.info(), newNode);
        };
        if (tpe.getActiveCount() < 1) {
            try {
                tpe.execute(asyncTask);
            }
            catch (RejectedExecutionException ex2) {
                log.debug("Rejected");
            }
        } else {
            log.debug("Skipped");
        }
    }

    protected void onNoticeRedisDown(String info2, Throwable ex) {
        if (this.po != null) {
            this.po.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Redis is Down", info2, ex, false);
        }
    }

    protected void onNoticeAutoFailover(String info2, String newNode) {
        if (this.po != null) {
            this.po.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Redis Auto Failover to " + newNode, info2, null, false);
        }
    }

    @Override
    public boolean tryLock(String lockName, String unlockPassword, long ttlToExpireIncaseUnableToUnlock, TimeUnit timeUnit) {
        Holder<Boolean> holder = new Holder<Boolean>(this, false);
        this.execute(true, jedis -> {
            SetParams p = (SetParams)new SetParams().nx().px(timeUnit.toMillis(ttlToExpireIncaseUnableToUnlock));
            String result = jedis.set(lockName, unlockPassword, p);
            boolean isLocked = REDIS_SUCCESS.equalsIgnoreCase(result);
            holder.value(isLocked);
        });
        return holder.value();
    }

    @Override
    public boolean unlock(String lockName, String unlockPassword) {
        Holder<Boolean> holder = new Holder<Boolean>(this, false);
        this.execute(true, jedis -> {
            Object result = jedis.eval(LUA_SCRIPT_UNLOCK, Collections.singletonList(lockName), Collections.singletonList(unlockPassword));
            boolean isReleased = RELEASE_SUCCESS.equals(result);
            holder.value(isReleased);
        });
        return holder.value();
    }

    @Override
    public void blacklist(String key, String value, long ttlMilliseconds) {
        if (key == null) {
            return;
        }
        this.execute(true, jedis -> {
            if (ttlMilliseconds > 0L) {
                jedis.psetex(key, ttlMilliseconds, value == null ? "?" : value);
            }
        });
    }

    @Override
    public boolean isBlacklist(String key) {
        if (key == null) {
            return false;
        }
        Holder<Boolean> holder = new Holder<Boolean>(this, false);
        this.execute(true, jedis -> {
            boolean exists = jedis.exists(key);
            holder.value(exists);
        });
        return holder.value();
    }

    @Override
    public boolean flashsaleInventoryInit(String itemId, long totalAmount, long limit) {
        Holder<Boolean> holder = new Holder<Boolean>(this, false);
        this.execute(true, jedis -> {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("Status", "0");
            item.put("Total", String.valueOf(totalAmount));
            item.put("Limit", String.valueOf(limit));
            item.put("Booked", "0");
            String result = jedis.hmset(itemId, item);
            boolean success = REDIS_SUCCESS.equalsIgnoreCase(result);
            holder.value(success);
        });
        return holder.value();
    }

    @Override
    public FlashSale flashsaleInventoryReport(String itemId) {
        FlashSale ret = new FlashSale();
        this.execute(true, jedis -> {
            List result = jedis.hmget(itemId, new String[]{"Status", "Total", "Limit", "Booked"});
            ret.setStatus(Integer.parseInt((String)result.get(0)));
            ret.setTotal(Long.parseLong((String)result.get(1)));
            ret.setLimit(Long.parseLong((String)result.get(2)));
            ret.setBooked(Long.parseLong((String)result.get(3)));
        });
        return ret;
    }

    @Override
    public void flashsaleEnable(String itemId, boolean isEnabled) {
        this.execute(true, jedis -> jedis.hset(itemId, "Status", isEnabled ? "1" : "0"));
    }

    @Override
    public long flashsaleAcquireQuota(String itemId, long requestAmount) {
        if (requestAmount < 1L) {
            return -1L;
        }
        Holder<Long> holder = new Holder<Long>(this, 0L);
        this.execute(true, jedis -> {
            Object result = jedis.eval(LUA_SCRIPT_FLASHSALE, Collections.singletonList(itemId), Collections.singletonList(String.valueOf(requestAmount)));
            holder.value((Long)result);
        });
        return holder.value();
    }

    @Override
    public long flashsaleRevokeQuota(String itemId, long requestAmount) {
        if (requestAmount < 1L) {
            return -1L;
        }
        Holder<Long> holder = new Holder<Long>(this, 0L);
        this.execute(true, jedis -> {
            Long result = jedis.hincrBy(itemId, "Booked", 0L - requestAmount);
            holder.value(result);
        });
        return holder.value();
    }

    public long rateLimiterGetWaitTime(String key, int initBurst, int maxBurstPerPeriod, int period, int requestQuota) {
        Holder<Integer> holder = new Holder<Integer>(this, -1);
        this.execute(true, jedis -> {
            ArrayList<String> argvs = new ArrayList<String>();
            argvs.add(String.valueOf(initBurst));
            argvs.add(String.valueOf(maxBurstPerPeriod));
            argvs.add(String.valueOf(period));
            argvs.add(String.valueOf(requestQuota));
            Object result = jedis.eval(LUA_SCRIPT_THROTTLE, Collections.singletonList(key), argvs);
            List quotaResult = (List)result;
            int retryAfterSeconds = (Integer)quotaResult.get(3);
            holder.value(retryAfterSeconds);
        });
        return holder.value().intValue();
    }

    @Deprecated
    public long rateLimiterGetSlidingWindowRate(String key, int periodSecond) {
        long nowTs = System.currentTimeMillis();
        Holder<Long> holder = new Holder<Long>(this, 0L);
        this.execute(true, jedis -> {
            Response count;
            try (Pipeline pipeline = jedis.pipelined();){
                pipeline.zadd(key, (double)nowTs, String.valueOf(nowTs));
                pipeline.zremrangeByScore(key, 0.0, (double)(nowTs - (long)(periodSecond * 1000)));
                count = pipeline.zcard(key);
                pipeline.expire(key, (long)(periodSecond + 1));
                pipeline.syncAndReturnAll();
            }
            if (count != null && count.get() != null) {
                long c = (Long)count.get();
                holder.value(c);
            }
        });
        return holder.value();
    }

    protected class Holder<T> {
        protected T value;

        public Holder(BootCache_RedisImple this$0, T value) {
            this.value = value;
        }

        public void value(T value) {
            this.value = value;
        }

        public T value() {
            return this.value;
        }
    }
}

